/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.YarnWebServiceUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Singleton
@Path(value="/ws/v1/applicationhistory")
public class AHSWebServices
extends WebServices {
    private static final Log LOG = LogFactory.getLog(AHSWebServices.class);
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Joiner DOT_JOINER = Joiner.on((String)". ");
    private final Configuration conf;

    @Inject
    public AHSWebServices(ApplicationBaseProtocol appBaseProt, Configuration conf) {
        super(appBaseProt);
        this.conf = conf;
    }

    @GET
    @Path(value="/about")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TimelineAbout about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return TimelineUtils.createTimelineAbout((String)"Generic History Service API");
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo get(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        return this.getApps(req, res, null, Collections.emptySet(), null, null, null, null, null, null, null, null, Collections.emptySet());
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes) {
        this.init(res);
        AHSWebServices.validateStates(stateQuery, statesQuery);
        return super.getApps(req, res, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getApp(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getAppAttempts(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.init(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    private static void validateStates(String stateQuery, Set<String> statesQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        Set appStates = AHSWebServices.parseQueries(statesQuery, (boolean)true);
        block3: for (String appState : appStates) {
            switch (YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)appState))) {
                case FINISHED: 
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            throw new BadRequestException("Invalid application-state " + appState + " specified. It should be a final state");
        }
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId = null;
        this.init(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return this.getContainerLogMeta(appId, null, null, containerIdStr, false);
        }
        if (this.isFinishedState(appInfo.getAppState())) {
            return this.getContainerLogMeta(appId, null, null, containerIdStr, false);
        }
        if (this.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            String appOwner;
            block14: {
                appOwner = appInfo.getUser();
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug((Object)ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return this.getContainerLogMeta(appId, appOwner, null, containerIdStr, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return this.getContainerLogMeta(appId, appOwner, null, containerIdStr, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)this.getAbsoluteNMWebAddress(nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        throw new NotFoundException("The application is not at Running or Finished State.");
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") boolean redirected_from_node) {
        return this.getLogs(req, res, containerIdStr, filename, format, size, nmId, redirected_from_node);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId;
        this.init(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return this.createBadResponse(Response.Status.NOT_FOUND, "Invalid ContainerId: " + containerIdStr);
        }
        long length = this.parseLongParam(size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return this.sendStreamOutputResponse(appId, null, null, containerIdStr, filename, format, length, false);
        }
        String appOwner = appInfo.getUser();
        if (this.isFinishedState(appInfo.getAppState())) {
            return this.sendStreamOutputResponse(appId, appOwner, null, containerIdStr, filename, format, length, false);
        }
        if (this.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            block14: {
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug((Object)ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return this.sendStreamOutputResponse(appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return this.sendStreamOutputResponse(appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)this.getAbsoluteNMWebAddress(nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        return this.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    private boolean isRunningState(YarnApplicationState appState) {
        return appState == YarnApplicationState.RUNNING;
    }

    private boolean isFinishedState(YarnApplicationState appState) {
        return appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED;
    }

    private Response createBadResponse(Response.Status status, String errMessage) {
        Response response = Response.status((Response.Status)status).entity((Object)DOT_JOINER.join((Object)status.toString(), (Object)errMessage, new Object[0])).build();
        return response;
    }

    private Response sendStreamOutputResponse(ApplicationId appId, String appOwner, String nodeId, String containerIdStr, String fileName, String format, long bytes, boolean printEmptyLocalContainerLog) {
        String contentType = WebAppUtils.getDefaultLogContentType();
        if (format != null && !format.isEmpty() && (contentType = WebAppUtils.getSupportedLogContentType((String)format)) == null) {
            String errorMessage = "The valid values for the parameter : format are " + WebAppUtils.listSupportedLogContentType();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        StreamingOutput stream = null;
        try {
            stream = this.getStreamingOutput(appId, appOwner, nodeId, containerIdStr, fileName, bytes, printEmptyLocalContainerLog);
        }
        catch (Exception ex) {
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        Response.ResponseBuilder response = Response.ok((Object)stream);
        response.header("Content-Type", (Object)contentType);
        response.header("X-Content-Type-Options", (Object)"nosniff");
        return response.build();
    }

    private StreamingOutput getStreamingOutput(final ApplicationId appId, final String appOwner, final String nodeId, final String containerIdStr, final String logFile, final long bytes, final boolean printEmptyLocalContainerLog) throws IOException {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                byte[] buf = new byte[65535];
                boolean findLogs = LogToolUtils.outputAggregatedContainerLog((Configuration)AHSWebServices.this.conf, (ApplicationId)appId, (String)appOwner, (String)containerIdStr, (String)nodeId, (String)logFile, (long)bytes, (OutputStream)os, (byte[])buf);
                if (!findLogs) {
                    os.write(("Can not find logs for container:" + containerIdStr).getBytes(Charset.forName("UTF-8")));
                } else if (printEmptyLocalContainerLog) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(containerIdStr + "\n");
                    sb.append("LogAggregationType: " + ContainerLogAggregationType.LOCAL + "\n");
                    sb.append("LogContents:\n");
                    sb.append(AHSWebServices.getNoRedirectWarning() + "\n");
                    os.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                }
            }
        };
        return stream;
    }

    private long parseLongParam(String bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(bytes);
    }

    private Response getContainerLogMeta(ApplicationId appId, String appOwner, String nodeId, String containerIdStr, boolean emptyLocalContainerLogMeta) {
        try {
            List containerLogMeta = LogToolUtils.getContainerLogMetaFromRemoteFS((Configuration)this.conf, (ApplicationId)appId, (String)containerIdStr, (String)nodeId, (String)appOwner);
            if (containerLogMeta.isEmpty()) {
                throw new NotFoundException("Can not get log meta for container: " + containerIdStr);
            }
            ArrayList<ContainerLogsInfo> containersLogsInfo = new ArrayList<ContainerLogsInfo>();
            for (ContainerLogMeta meta : containerLogMeta) {
                ContainerLogsInfo logInfo = new ContainerLogsInfo(meta, ContainerLogAggregationType.AGGREGATED);
                containersLogsInfo.add(logInfo);
            }
            if (emptyLocalContainerLogMeta) {
                ContainerLogMeta emptyMeta = new ContainerLogMeta(containerIdStr, "N/A");
                ContainerLogsInfo empty = new ContainerLogsInfo(emptyMeta, ContainerLogAggregationType.LOCAL);
                containersLogsInfo.add(empty);
            }
            GenericEntity<List<ContainerLogsInfo>> meta = new GenericEntity<List<ContainerLogsInfo>>(containersLogsInfo){};
            Response.ResponseBuilder response = Response.ok((Object)meta);
            response.header("X-Content-Type-Options", (Object)"nosniff");
            return response.build();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static String getNoRedirectWarning() {
        return "We do not have NodeManager web address, so we can not re-direct the request to related NodeManager for local container logs.";
    }

    private String getAbsoluteNMWebAddress(String nmWebAddress) {
        if (nmWebAddress.contains("http://") || nmWebAddress.contains("https://")) {
            return nmWebAddress;
        }
        return WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + nmWebAddress;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public String getNMWebAddressFromRM(Configuration configuration, String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        JSONObject nodeInfo = YarnWebServiceUtils.getNodeInfoFromRMWebService((Configuration)configuration, (String)nodeId).getJSONObject("node");
        return nodeInfo.has("nodeHTTPAddress") ? nodeInfo.getString("nodeHTTPAddress") : null;
    }
}

