/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourcePBImpl
extends Resource {
    YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.getDefaultInstance();
    YarnProtos.ResourceProto.Builder builder = null;
    boolean viaProto = false;

    static YarnProtos.ResourceProto getProto(Resource r) {
        ResourcePBImpl pb;
        if (r instanceof ResourcePBImpl) {
            pb = (ResourcePBImpl)r;
        } else {
            pb = new ResourcePBImpl();
            pb.setMemorySize(r.getMemorySize());
            pb.setVirtualCores(r.getVirtualCores());
        }
        return pb.getProto();
    }

    public ResourcePBImpl() {
        this.builder = YarnProtos.ResourceProto.newBuilder();
    }

    public ResourcePBImpl(YarnProtos.ResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceProto.newBuilder((YarnProtos.ResourceProto)this.proto);
        }
        this.viaProto = false;
    }

    public int getMemory() {
        return (int)this.getMemorySize();
    }

    public long getMemorySize() {
        YarnProtos.ResourceProto p = this.viaProto ? this.proto : this.builder;
        return p.getMemory();
    }

    public void setMemory(int memory) {
        this.setMemorySize(memory);
    }

    public void setMemorySize(long memory) {
        this.maybeInitBuilder();
        this.builder.setMemory(memory);
    }

    public int getVirtualCores() {
        YarnProtos.ResourceProto p = this.viaProto ? this.proto : this.builder;
        return p.getVirtualCores();
    }

    public void setVirtualCores(int vCores) {
        this.maybeInitBuilder();
        this.builder.setVirtualCores(vCores);
    }
}

