/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.client.api.impl.NMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NMClient
extends AbstractService {
    private NMTokenCache nmTokenCache = NMTokenCache.getSingleton();

    @InterfaceAudience.Public
    public static NMClient createNMClient() {
        NMClientImpl client = new NMClientImpl();
        return client;
    }

    @InterfaceAudience.Public
    public static NMClient createNMClient(String name) {
        NMClientImpl client = new NMClientImpl(name);
        return client;
    }

    @InterfaceAudience.Private
    protected NMClient(String name) {
        super(name);
    }

    public abstract Map<String, ByteBuffer> startContainer(Container var1, ContainerLaunchContext var2) throws YarnException, IOException;

    public abstract void increaseContainerResource(Container var1) throws YarnException, IOException;

    public abstract void stopContainer(ContainerId var1, NodeId var2) throws YarnException, IOException;

    public abstract ContainerStatus getContainerStatus(ContainerId var1, NodeId var2) throws YarnException, IOException;

    public abstract void reInitializeContainer(ContainerId var1, ContainerLaunchContext var2, boolean var3) throws YarnException, IOException;

    public abstract void restartContainer(ContainerId var1) throws YarnException, IOException;

    public abstract void rollbackLastReInitialization(ContainerId var1) throws YarnException, IOException;

    public abstract void commitLastReInitialization(ContainerId var1) throws YarnException, IOException;

    public abstract void cleanupRunningContainersOnStop(boolean var1);

    public void setNMTokenCache(NMTokenCache nmTokenCache) {
        this.nmTokenCache = nmTokenCache;
    }

    public NMTokenCache getNMTokenCache() {
        return this.nmTokenCache;
    }

    public NodeId getNodeIdOfStartedContainer(ContainerId containerId) {
        return null;
    }

    protected static enum UpgradeOp {
        REINIT,
        RESTART,
        COMMIT,
        ROLLBACK;

    }
}

