/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class YarnClient
extends AbstractService {
    @InterfaceAudience.Public
    public static YarnClient createYarnClient() {
        YarnClientImpl client = new YarnClientImpl();
        return client;
    }

    @InterfaceAudience.Private
    protected YarnClient(String name) {
        super(name);
    }

    public abstract YarnClientApplication createApplication() throws YarnException, IOException;

    public abstract ApplicationId submitApplication(ApplicationSubmissionContext var1) throws YarnException, IOException;

    public abstract void failApplicationAttempt(ApplicationAttemptId var1) throws YarnException, IOException;

    public abstract void killApplication(ApplicationId var1) throws YarnException, IOException;

    public abstract void killApplication(ApplicationId var1, String var2) throws YarnException, IOException;

    public abstract ApplicationReport getApplicationReport(ApplicationId var1) throws YarnException, IOException;

    public abstract Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId var1) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications() throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications(Set<String> var1) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> var1) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications(Set<String> var1, EnumSet<YarnApplicationState> var2) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications(Set<String> var1, EnumSet<YarnApplicationState> var2, Set<String> var3) throws YarnException, IOException;

    public abstract List<ApplicationReport> getApplications(Set<String> var1, Set<String> var2, Set<String> var3, EnumSet<YarnApplicationState> var4) throws YarnException, IOException;

    public List<ApplicationReport> getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        throw new UnsupportedOperationException("The sub-class extending " + YarnClient.class.getName() + " is expected to implement this !");
    }

    public abstract YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException;

    public abstract List<NodeReport> getNodeReports(NodeState ... var1) throws YarnException, IOException;

    public abstract org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text var1) throws YarnException, IOException;

    public abstract QueueInfo getQueueInfo(String var1) throws YarnException, IOException;

    public abstract List<QueueInfo> getAllQueues() throws YarnException, IOException;

    public abstract List<QueueInfo> getRootQueueInfos() throws YarnException, IOException;

    public abstract List<QueueInfo> getChildQueueInfos(String var1) throws YarnException, IOException;

    public abstract List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException;

    public abstract ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId var1) throws YarnException, IOException;

    public abstract List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId var1) throws YarnException, IOException;

    public abstract ContainerReport getContainerReport(ContainerId var1) throws YarnException, IOException;

    public abstract List<ContainerReport> getContainers(ApplicationAttemptId var1) throws YarnException, IOException;

    public abstract void moveApplicationAcrossQueues(ApplicationId var1, String var2) throws YarnException, IOException;

    public abstract GetNewReservationResponse createReservation() throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest var1) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationUpdateResponse updateReservation(ReservationUpdateRequest var1) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationDeleteResponse deleteReservation(ReservationDeleteRequest var1) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationListResponse listReservations(ReservationListRequest var1) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<NodeId, Set<NodeLabel>> getNodeToLabels() throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<NodeLabel, Set<NodeId>> getLabelsToNodes() throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<NodeLabel, Set<NodeId>> getLabelsToNodes(Set<String> var1) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<NodeLabel> getClusterNodeLabels() throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Priority updateApplicationPriority(ApplicationId var1, Priority var2) throws YarnException, IOException;

    public abstract void signalToContainer(ContainerId var1, SignalContainerCommand var2) throws YarnException, IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        throw new UnsupportedOperationException("The sub-class extending " + YarnClient.class.getName() + " is expected to implement this !");
    }
}

