/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

public class TestAccessControlList
extends TestCase {
    private static Groups testGroups = null;

    public void setUp() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMappingTestWrapper");
        testGroups = Groups.getUserToGroupsMappingService((Configuration)conf);
    }

    public void tearDown() {
        testGroups = null;
    }

    public void testNetgroups() throws Exception {
        AccessControlList acl = new AccessControlList("ja my");
        acl = new AccessControlList("sinatra ratpack,@lasVegas");
        acl = new AccessControlList(" somegroups,@somenetgroup");
        List elvisGroups = testGroups.getGroups("elvis");
        TestAccessControlList.assertTrue((boolean)elvisGroups.contains("@lasVegas"));
        testGroups.refresh();
        acl = new AccessControlList("ja ratpack,@lasVegas");
        UserGroupInformation elvis = UserGroupInformation.createRemoteUser((String)"elvis");
        UserGroupInformation ja = UserGroupInformation.createRemoteUser((String)"ja");
        UserGroupInformation unwanted = UserGroupInformation.createRemoteUser((String)"unwanted");
        this.assertUserAllowed(elvis, acl);
        this.assertUserAllowed(ja, acl);
        this.assertUserNotAllowed(unwanted, acl);
    }

    public void testWildCardAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("*");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("  * ");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList(" *");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("*  ");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
    }

    public void testToString() {
        AccessControlList acl = new AccessControlList("*");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("All users are allowed"));
        acl = new AccessControlList(" ");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("No users are allowed"));
        acl = new AccessControlList("user1,user2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] are allowed"));
        acl = new AccessControlList("user1,user2 ");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] are allowed"));
        acl = new AccessControlList(" group1,group2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Members of the groups [group1, group2] are allowed"));
        acl = new AccessControlList("user1,user2 group1,group2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] and members of the groups [group1, group2] are allowed"));
    }

    public void testAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("drwho tardis");
        Set users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        Set groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new AccessControlList("drwho");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new AccessControlList("drwho ");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new AccessControlList(" tardis");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)0);
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new AccessControlList("drwho,joe tardis, users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)2);
        Iterator iter = users.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"joe");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)2);
        iter = groups.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"users");
    }

    public void testIsUserAllowed() {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation susan = UserGroupInformation.createUserForTesting((String)"susan@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation barbara = UserGroupInformation.createUserForTesting((String)"barbara@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        UserGroupInformation ian = UserGroupInformation.createUserForTesting((String)"ian@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        AccessControlList acl = new AccessControlList("drwho humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho ");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList(" humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho,ian aliens,teachers");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserAllowed(barbara, acl);
        this.assertUserAllowed(ian, acl);
    }

    private void assertUserAllowed(UserGroupInformation ugi, AccessControlList acl) {
        TestAccessControlList.assertTrue((String)("User " + ugi + " is not granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }

    private void assertUserNotAllowed(UserGroupInformation ugi, AccessControlList acl) {
        TestAccessControlList.assertFalse((String)("User " + ugi + " is incorrectly granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }
}

