/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.impl.TestMetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.AbstractMetricsSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.sink.ganglia.AbstractGangliaSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaMetricsTestHelper;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink30;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink31;
import org.junit.Assert;
import org.junit.Test;

public class TestGangliaMetrics {
    public static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    private final String[] expectedMetrics = new String[]{"test.s1rec.c1", "test.s1rec.g1", "test.s1rec.s1_num_ops", "test.s1rec.s1_avg_time"};

    @Test
    public void testGangliaMetrics2() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("default.period", 10).add("test.sink.gsink30.context", "test").add("test.sink.gsink31.context", "test").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (MetricsSource)new TestSource("s1rec"));
        s1.s1.add(0L);
        GangliaSink30 gsink30 = new GangliaSink30();
        gsink30.init(cb.subset("test"));
        MockDatagramSocket mockds30 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket((AbstractGangliaSink)gsink30, mockds30);
        GangliaSink31 gsink31 = new GangliaSink31();
        gsink31.init(cb.subset("test"));
        MockDatagramSocket mockds31 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket((AbstractGangliaSink)gsink31, mockds31);
        ms.register("gsink30", "gsink30 desc", (MetricsSink)gsink30);
        ms.register("gsink31", "gsink31 desc", (MetricsSink)gsink31);
        ms.onTimerEvent();
        ms.stop();
        this.checkMetrics(mockds30.getCapturedSend());
        this.checkMetrics(mockds31.getCapturedSend());
    }

    private void checkMetrics(List<byte[]> bytearrlist) {
        boolean[] foundMetrics = new boolean[this.expectedMetrics.length];
        block0: for (byte[] bytes : bytearrlist) {
            String binaryStr = new String(bytes);
            for (int index = 0; index < this.expectedMetrics.length; ++index) {
                if (binaryStr.indexOf(this.expectedMetrics[index]) < 0) continue;
                foundMetrics[index] = true;
                continue block0;
            }
        }
        for (int index = 0; index < foundMetrics.length; ++index) {
            if (foundMetrics[index]) continue;
            Assert.assertTrue((String)("Missing metrics: " + this.expectedMetrics[index]), (boolean)false);
        }
    }

    private static class MockDatagramSocket
    extends DatagramSocket {
        private ArrayList<byte[]> capture = new ArrayList();

        @Override
        public void send(DatagramPacket p) throws IOException {
            byte[] bytes = new byte[p.getLength()];
            System.arraycopy(p.getData(), p.getOffset(), bytes, 0, p.getLength());
            this.capture.add(bytes);
        }

        ArrayList<byte[]> getCapturedSend() {
            return this.capture;
        }
    }

    private static class TestSource
    extends AbstractMetricsSource {
        final MetricMutableCounterLong c1;
        final MetricMutableGaugeLong g1;
        final MetricMutableStat s1;

        TestSource(String name) {
            super(name);
            this.registry.setContext("test");
            this.c1 = this.registry.newCounter("c1", "c1 desc", 1L);
            this.g1 = this.registry.newGauge("g1", "g1 desc", 2L);
            this.s1 = this.registry.newStat("s1", "s1 desc", "ops", "time");
        }
    }
}

