/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Scanner;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class TestNonLocalJobJarSubmission
extends ClusterMapReduceTestCase {
    public void testNonLocalJobJarSubmission() throws Exception {
        FileSystem hdfs = this.getFileSystem();
        FSDataOutputStream os = hdfs.create(new Path(this.getInputDir(), "dummy.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("dummy\n");
        ((Writer)wr).close();
        String jobJarPath = this.createAndUploadJobJar(hdfs);
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setJobPriority(JobPriority.HIGH);
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(NullWritable.class);
        conf.setMapperClass(ClasspathMapper.class);
        conf.setReducerClass(ClasspathReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        conf.setJar(jobJarPath);
        String jobID = JobClient.runJob((JobConf)conf).getID().toString();
        this.verifyClasspath(hdfs, jobID);
    }

    private String createAndUploadJobJar(FileSystem hdfs) throws Exception {
        File tmp = new File(System.getProperty("test.build.data", "/tmp"), ((Object)((Object)this)).getClass().getSimpleName());
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        File jobJarFile = new File(tmp, "jobjar-on-local.jar");
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jobJarFile));
        ZipEntry ze = new ZipEntry("lib/lib1.jar");
        jstream.putNextEntry(ze);
        jstream.closeEntry();
        ze = new ZipEntry("lib/lib2.jar");
        jstream.putNextEntry(ze);
        jstream.closeEntry();
        jstream.finish();
        jstream.close();
        Path jobJarPath = new Path(this.getTestRootDir().makeQualified(hdfs), "jobjar-on-hdfs.jar");
        hdfs.moveFromLocalFile(new Path(jobJarFile.toURI().toString()), jobJarPath);
        if (jobJarFile.exists()) {
            jobJarFile.delete();
        }
        return jobJarPath.toUri().toString();
    }

    private void verifyClasspath(FileSystem hdfs, String jobID) throws Exception {
        FileStatus[] fstats;
        boolean containsLib1Jar = false;
        String lib1JarStr = "jobcache/" + jobID + "/jars/lib/lib1.jar";
        boolean containsLib2Jar = false;
        String lib2JarStr = "jobcache/" + jobID + "/jars/lib/lib2.jar";
        for (FileStatus fstat : fstats = hdfs.listStatus(this.getOutputDir())) {
            Path p = fstat.getPath();
            if (!hdfs.isFile(p) || !p.getName().startsWith("part-")) continue;
            FSDataInputStream is = hdfs.open(p);
            Scanner sc = new Scanner((InputStream)is);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                containsLib1Jar = containsLib1Jar || line.endsWith(lib1JarStr);
                containsLib2Jar = containsLib2Jar || line.endsWith(lib2JarStr);
            }
            sc.close();
            is.close();
        }
        TestNonLocalJobJarSubmission.assertTrue((String)"lib/lib1.jar should have been unzipped from the job jar and added to the classpath but was not", (boolean)containsLib1Jar);
        TestNonLocalJobJarSubmission.assertTrue((String)"lib/lib2.jar should have been unzipped from the job jar and added to the classpath but was not", (boolean)containsLib2Jar);
    }

    static class ClasspathReducer
    implements Reducer<IntWritable, Text, Text, NullWritable> {
        ClasspathReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<Text> it, OutputCollector<Text, NullWritable> out, Reporter reporter) throws IOException {
            while (it.hasNext()) {
                out.collect((Object)it.next(), (Object)NullWritable.get());
            }
        }

        public void close() {
        }
    }

    static class ClasspathMapper
    implements Mapper<LongWritable, Text, IntWritable, Text> {
        private static final IntWritable zero = new IntWritable(0);

        ClasspathMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(LongWritable key, Text val, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            URL[] urls;
            ClassLoader applicationClassLoader = this.getClass().getClassLoader();
            if (applicationClassLoader == null) {
                applicationClassLoader = ClassLoader.getSystemClassLoader();
            }
            for (URL url : urls = ((URLClassLoader)applicationClassLoader).getURLs()) {
                out.collect((Object)zero, (Object)new Text(url.toString()));
            }
        }

        public void close() {
        }
    }
}

