/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;

public class TestJobEndNotifier
extends TestCase {
    HttpServer server;
    URL baseUrl;

    public void setUp() throws Exception {
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        this.server = new HttpServer("test", "0.0.0.0", 0, true);
        this.server.addServlet("delay", "/delay", DelayServlet.class);
        this.server.addServlet("jobend", "/jobend", JobEndServlet.class);
        this.server.addServlet("fail", "/fail", FailServlet.class);
        this.server.start();
        int port = this.server.getPort();
        this.baseUrl = new URL("http://localhost:" + port + "/");
        JobEndServlet.calledTimes = 0;
        JobEndServlet.requestUri = null;
        DelayServlet.calledTimes = 0;
        FailServlet.calledTimes = 0;
    }

    public void tearDown() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUriSubstitution() throws InterruptedException {
        try {
            JobEndNotifier.startNotifier();
            JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", 2);
            JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), 0, this.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
            JobEndNotifier.registerNotification((JobConf)jobConf, (JobStatus)jobStatus);
            int maxLoop = 100;
            while (JobEndServlet.calledTimes != 1 && maxLoop-- > 0) {
                Thread.sleep(100L);
            }
            TestJobEndNotifier.assertEquals((int)1, (int)JobEndServlet.calledTimes);
            TestJobEndNotifier.assertEquals((String)"jobid=job_20130313155005308_0001&status=SUCCEEDED", (String)JobEndServlet.requestUri.getQuery());
        }
        finally {
            JobEndNotifier.stopNotifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetryCount() throws InterruptedException {
        try {
            JobEndNotifier.startNotifier();
            int retryAttempts = 3;
            JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", 2);
            JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), retryAttempts, this.baseUrl + "fail");
            JobEndNotifier.registerNotification((JobConf)jobConf, (JobStatus)jobStatus);
            int maxLoop = 100;
            while (FailServlet.calledTimes != retryAttempts + 1 && maxLoop-- > 0) {
                Thread.sleep(100L);
            }
            TestJobEndNotifier.assertEquals((int)(retryAttempts + 1), (int)FailServlet.calledTimes);
        }
        finally {
            JobEndNotifier.stopNotifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationTimeout() throws InterruptedException {
        try {
            Configuration conf = new Configuration();
            conf.setInt("mapreduce.job.end-notification.timeout", 1000);
            JobEndNotifier.startNotifier();
            JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", 2);
            JobConf jobConf = TestJobEndNotifier.createTestJobConf(conf, 0, this.baseUrl + "delay");
            JobEndNotifier.registerNotification((JobConf)jobConf, (JobStatus)jobStatus);
            jobConf.setJobEndNotificationURI(this.baseUrl + "jobend");
            JobEndNotifier.registerNotification((JobConf)jobConf, (JobStatus)jobStatus);
            int maxLoop = 100;
            while (JobEndServlet.calledTimes != 1 && maxLoop-- > 0) {
                Thread.sleep(100L);
            }
            TestJobEndNotifier.assertEquals((String)"JobEnd notification should have been received by now", (int)1, (int)JobEndServlet.calledTimes);
            TestJobEndNotifier.assertEquals((int)1, (int)DelayServlet.calledTimes);
            TestJobEndNotifier.assertEquals((String)"/jobend", (String)JobEndServlet.requestUri.getPath());
        }
        finally {
            JobEndNotifier.stopNotifier();
        }
    }

    public void testLocalJobRunnerUriSubstitution() throws InterruptedException {
        JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", 2);
        JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), 0, this.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
        JobEndNotifier.localRunnerNotification((JobConf)jobConf, (JobStatus)jobStatus);
        TestJobEndNotifier.assertEquals((int)1, (int)JobEndServlet.calledTimes);
        TestJobEndNotifier.assertEquals((String)"jobid=job_20130313155005308_0001&status=SUCCEEDED", (String)JobEndServlet.requestUri.getQuery());
    }

    public void testLocalJobRunnerRetryCount() throws InterruptedException {
        int retryAttempts = 3;
        JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", 2);
        JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), retryAttempts, this.baseUrl + "fail");
        JobEndNotifier.localRunnerNotification((JobConf)jobConf, (JobStatus)jobStatus);
        TestJobEndNotifier.assertEquals((int)(retryAttempts + 1), (int)FailServlet.calledTimes);
    }

    private static JobStatus createTestJobStatus(String jobId, int state) {
        return new JobStatus(JobID.forName((String)jobId), 0.5f, 0.0f, state);
    }

    private static JobConf createTestJobConf(Configuration conf, int retryAttempts, String notificationUri) {
        JobConf jobConf = new JobConf(conf);
        jobConf.setInt("job.end.retry.attempts", retryAttempts);
        jobConf.set("job.end.retry.interval", "0");
        jobConf.setJobEndNotificationURI(notificationUri);
        return jobConf;
    }

    public static class FailServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ++calledTimes;
            throw new IOException("I am failing!");
        }
    }

    public static class DelayServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean timedOut = false;
            ++calledTimes;
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                timedOut = true;
            }
            Assert.assertTrue((String)"DelayServlet should be interrupted", (boolean)timedOut);
        }
    }

    public static class JobEndServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;
        public static URI requestUri;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            InputStreamReader in = new InputStreamReader((InputStream)request.getInputStream());
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            ++calledTimes;
            try {
                requestUri = new URI(null, null, request.getRequestURI(), request.getQueryString(), null);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            in.close();
            out.close();
        }
    }
}

