/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRWithDFS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestJobClientRetries {
    private static final Log LOG = LogFactory.getLog(TestJobClientRetries.class);
    MiniMRCluster mr;

    @Test
    public void testJobSubmission() throws Exception {
        this.mr = new MiniMRCluster(2, "file:///", 3);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        JobConf jobConf = this.mr.createJobConf();
        LOG.info((Object)"Stopping JobTracker");
        this.mr.stopJobTracker();
        LOG.info((Object)"Stopping JobTracker");
        jobConf.setBoolean("mapreduce.jobclient.retry.policy.enabled", true);
        WordCountThread wc = new WordCountThread(jobConf, exceptions);
        wc.start();
        Thread.sleep(5000L);
        LOG.info((Object)"Re-starting JobTracker for job-submission to go through");
        this.mr.startJobTracker();
        LOG.info((Object)"Waiting for job success/failure ...");
        wc.join();
        Assert.assertNotNull((Object)wc.result);
        Assert.assertEquals((Object)"The\t1\nbrown\t1\nfox\t2\nhas\t1\nmany\t1\nquick\t1\nred\t1\nsilly\t1\nsox\t1\n", (Object)wc.result.output);
        Assert.assertTrue((String)("exceptions is not empty: " + exceptions), (boolean)exceptions.isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        this.mr.shutdown();
    }

    public static class WordCountThread
    extends Thread {
        JobConf jobConf;
        List<Exception> exceptions;
        TestMiniMRWithDFS.TestResult result;

        public WordCountThread(JobConf jobConf, List<Exception> exceptions) {
            super(WordCountThread.class.getName());
            this.jobConf = jobConf;
            this.exceptions = exceptions;
        }

        @Override
        public void run() {
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)this.jobConf);
                Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)fs);
                Path inDir = new Path(testdir, "input");
                Path outDir = new Path(testdir, "output");
                String input = "The quick brown fox\nhas many silly\nred fox sox\n";
                LOG.info((Object)"Starting word-count");
                this.result = TestMiniMRWithDFS.launchWordCount(this.jobConf, inDir, outDir, input, 3, 1);
                LOG.info((Object)"Finished word-count");
            }
            catch (Exception e) {
                LOG.error((Object)"Caught exception during word-count", (Throwable)e);
                this.exceptions.add(e);
                this.result = null;
            }
        }
    }
}

