/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;

public class TestCleanupQueue {
    @Test(timeout=2000L)
    public void testCleanupQueueClosesFilesystem() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        File file = new File("afile.txt");
        file.createNewFile();
        Path path = new Path(file.getAbsoluteFile().toURI());
        FileSystem.get((Configuration)conf);
        Assert.assertEquals((int)1, (int)FileSystem.getCacheSize());
        CleanupQueue cleanupQueue = new CleanupQueue();
        CleanupQueue.PathDeletionContext context = new CleanupQueue.PathDeletionContext(path, conf, UserGroupInformation.getLoginUser());
        cleanupQueue.addToQueue(new CleanupQueue.PathDeletionContext[]{context});
        while (FileSystem.getCacheSize() > 0) {
            Thread.sleep(100L);
        }
        file.createNewFile();
        FileSystem.get((Configuration)conf);
        Assert.assertEquals((int)1, (int)FileSystem.getCacheSize());
        context = new CleanupQueue.PathDeletionContext(path, conf);
        cleanupQueue.addToQueue(new CleanupQueue.PathDeletionContext[]{context});
        while (file.exists()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)1, (int)FileSystem.getCacheSize());
    }
}

