/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRCluster;

public class MiniMRClusterAdapter
implements MiniMRClientCluster {
    private MiniMRCluster miniMRCluster;
    private static final Log LOG = LogFactory.getLog(MiniMRClusterAdapter.class);

    public MiniMRClusterAdapter(MiniMRCluster miniMRCluster) {
        this.miniMRCluster = miniMRCluster;
    }

    @Override
    public Configuration getConfig() throws IOException {
        return this.miniMRCluster.createJobConf();
    }

    @Override
    public void start() throws IOException {
        this.miniMRCluster.startJobTracker();
        this.miniMRCluster.startTaskTracker(null, null, 0, 1);
    }

    @Override
    public void stop() throws IOException {
        this.miniMRCluster.shutdown();
    }

    @Override
    public void restart() throws IOException {
        if (!this.miniMRCluster.getJobTrackerRunner().isActive()) {
            LOG.warn((Object)"Cannot restart the mini cluster, start it first");
            return;
        }
        int jobTrackerPort = this.miniMRCluster.getJobTrackerPort();
        int taskTrackerPort = this.getConfig().getInt("mapred.task.tracker.report.address", 0);
        int numtaskTrackers = this.miniMRCluster.getNumTaskTrackers();
        String namenode = this.getConfig().get("fs.default.name");
        this.stop();
        for (int i = 0; i < 30; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            try {
                this.miniMRCluster = new MiniMRCluster(jobTrackerPort, taskTrackerPort, numtaskTrackers, namenode, 1);
                break;
            }
            catch (Exception e) {
                LOG.info((Object)"Retrying to start the cluster");
                continue;
            }
        }
    }
}

