/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestIOUtils {
    @Test
    public void testWrappedReadForCompressedData() throws IOException {
        byte[] buf = new byte[2];
        InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)mockStream.read(buf, 0, 1)).thenReturn((Object)1);
        Mockito.when((Object)mockStream.read(buf, 0, 2)).thenThrow(new Throwable[]{new InternalError()});
        try {
            Assert.assertEquals((String)"Check expected value", (long)1L, (long)IOUtils.wrappedReadForCompressedData((InputStream)mockStream, (byte[])buf, (int)0, (int)1));
        }
        catch (IOException ioe) {
            Assert.fail((String)"Unexpected error while reading");
        }
        try {
            IOUtils.wrappedReadForCompressedData((InputStream)mockStream, (byte[])buf, (int)0, (int)2);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"Unexpected exception caught", (boolean)ioe.getMessage().contains("Error while reading compressed data"));
        }
    }
}

