/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeCorruptionRecovery {
    private static final Log LOG = LogFactory.getLog(TestNameNodeCorruptionRecovery.class);
    private MiniDFSCluster cluster;

    @After
    public void tearDownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFsTimeFileCorrupt() throws IOException, InterruptedException {
        this.cluster = new MiniDFSCluster(new Configuration(), 0, true, null);
        this.cluster.waitActive();
        Assert.assertEquals((long)this.cluster.getNameDirs().size(), (long)2L);
        TestNameNodeCorruptionRecovery.truncateStorageDirFile(this.cluster, FSImage.NameNodeFile.TIME, 0);
        this.cluster.restartNameNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditsFsTimeLessThanImageFsTime() throws Exception {
        Configuration conf = new Configuration();
        File testDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
        conf.set("dfs.name.dir", new File(testDir, "name").getPath());
        conf.set("dfs.name.edits.dir", new File(testDir, "edits").getPath());
        this.cluster = new MiniDFSCluster(0, conf, 1, true, false, true, null, null, null, null);
        this.cluster.waitActive();
        this.createFile("one");
        this.createFile("two");
        this.createFile("three");
        Assert.assertTrue((boolean)this.checkFileExists("one"));
        Assert.assertTrue((boolean)this.checkFileExists("two"));
        Assert.assertTrue((boolean)this.checkFileExists("three"));
        this.cluster.restartNameNode();
        File[] editsFsTime = this.cluster.getNameNode().getFSImage().getFileNames(FSImage.NameNodeFile.TIME, FSImage.NameNodeDirType.EDITS);
        Assert.assertTrue((String)"expected exactly one edits directory containing fstime file", (editsFsTime.length == 1 ? 1 : 0) != 0);
        this.cluster.shutdown();
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(editsFsTime[0]);
            dos = new DataOutputStream(fos);
            dos.writeLong(0L);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos, fos});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos, fos});
        this.cluster = new MiniDFSCluster(0, conf, 1, false, false, true, null, null, null, null);
        this.cluster.waitActive();
        this.cluster.restartNameNode();
        Assert.assertTrue((boolean)this.checkFileExists("one"));
        Assert.assertTrue((boolean)this.checkFileExists("two"));
        Assert.assertTrue((boolean)this.checkFileExists("three"));
    }

    private boolean checkFileExists(String file) throws IOException {
        return this.cluster.getFileSystem().exists(new Path(file));
    }

    private void createFile(String file) throws IOException {
        this.cluster.getFileSystem().create(new Path(file)).close();
    }

    private static void truncateStorageDirFile(MiniDFSCluster cluster, FSImage.NameNodeFile f, int storageDirIndex) throws IOException {
        File currentDir = cluster.getNameNode().getFSImage().getStorageDir(storageDirIndex).getCurrentDir();
        File nameNodeFile = new File(currentDir, f.getName());
        Assert.assertTrue((boolean)nameNodeFile.isFile());
        Assert.assertTrue((boolean)nameNodeFile.delete());
        Assert.assertTrue((boolean)nameNodeFile.createNewFile());
    }
}

