/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class UpgradeUtilities {
    private static File TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp").replace(' ', '+'));
    private static File namenodeStorage = new File(TEST_ROOT_DIR, "namenodeMaster");
    private static long namenodeStorageChecksum;
    private static int namenodeStorageNamespaceID;
    private static long namenodeStorageFsscTime;
    private static File datanodeStorage;
    private static long datanodeStorageChecksum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws Exception {
        UpgradeUtilities.createEmptyDirs(new String[]{TEST_ROOT_DIR.toString()});
        Configuration config = new Configuration();
        config.set("dfs.name.dir", namenodeStorage.toString());
        config.set("dfs.data.dir", datanodeStorage.toString());
        MiniDFSCluster cluster = null;
        try {
            UpgradeUtilities.createEmptyDirs(new String[]{datanodeStorage.toString()});
            NameNode.format((Configuration)config);
            cluster = new MiniDFSCluster(config, 1, HdfsConstants.StartupOption.REGULAR);
            NameNode namenode = cluster.getNameNode();
            namenodeStorageNamespaceID = namenode.versionRequest().getNamespaceID();
            namenodeStorageFsscTime = namenode.versionRequest().getCTime();
            FileSystem fs = FileSystem.get((Configuration)config);
            Path baseDir = new Path("/TestUpgrade");
            fs.mkdirs(baseDir);
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < bufferSize; ++i) {
                buffer[i] = (byte)(48 + i % 50);
            }
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file1"), buffer, bufferSize);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file2"), buffer, bufferSize);
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            namenode.saveNamespace();
            namenode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file3"), buffer, bufferSize);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file4"), buffer, bufferSize);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            FileUtil.fullyDelete((File)new File(namenodeStorage, "in_use.lock"));
            FileUtil.fullyDelete((File)new File(datanodeStorage, "in_use.lock"));
        }
        namenodeStorageChecksum = UpgradeUtilities.checksumContents(HdfsConstants.NodeType.NAME_NODE, new File(namenodeStorage, "current"));
        datanodeStorageChecksum = UpgradeUtilities.checksumContents(HdfsConstants.NodeType.DATA_NODE, new File(datanodeStorage, "current"));
    }

    private static void writeFile(FileSystem fs, Path path, byte[] buffer, int bufferSize) throws IOException {
        FSDataOutputStream out = fs.create(path, true, bufferSize, (short)1, 1024L);
        out.write(buffer, 0, bufferSize);
        out.close();
    }

    public static Configuration initializeStorageStateConf(int numDirs, Configuration conf) {
        StringBuffer nameNodeDirs = new StringBuffer(new File(TEST_ROOT_DIR, "name1").toString());
        StringBuffer dataNodeDirs = new StringBuffer(new File(TEST_ROOT_DIR, "data1").toString());
        for (int i = 2; i <= numDirs; ++i) {
            nameNodeDirs.append("," + new File(TEST_ROOT_DIR, "name" + i));
            dataNodeDirs.append("," + new File(TEST_ROOT_DIR, "data" + i));
        }
        if (conf == null) {
            conf = new Configuration();
        }
        conf.set("dfs.name.dir", nameNodeDirs.toString());
        conf.set("dfs.data.dir", dataNodeDirs.toString());
        conf.setInt("dfs.blockreport.intervalMsec", 10000);
        return conf;
    }

    public static void createEmptyDirs(String[] dirs) throws IOException {
        for (String d : dirs) {
            File dir = new File(d);
            if (dir.exists()) {
                FileUtil.fullyDelete((File)dir);
            }
            dir.mkdirs();
        }
    }

    public static long checksumMasterContents(HdfsConstants.NodeType nodeType) throws IOException {
        if (nodeType == HdfsConstants.NodeType.NAME_NODE) {
            return namenodeStorageChecksum;
        }
        return datanodeStorageChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksumContents(HdfsConstants.NodeType nodeType, File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Given argument is not a directory:" + dir);
        }
        Object[] list = dir.listFiles();
        Arrays.sort(list);
        CRC32 checksum = new CRC32();
        for (int i = 0; i < list.length; ++i) {
            if (!((File)list[i]).isFile() || nodeType == HdfsConstants.NodeType.DATA_NODE && ((File)list[i]).getName().equals("VERSION")) continue;
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream((File)list[i]);
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    checksum.update(buffer, 0, bytesRead);
                }
                continue;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return checksum.getValue();
    }

    public static File[] createStorageDirs(HdfsConstants.NodeType nodeType, String[] parents, String dirName) throws Exception {
        File[] retVal = new File[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            File newDir = new File(parents[i], dirName);
            UpgradeUtilities.createEmptyDirs(new String[]{newDir.toString()});
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)new Configuration());
            switch (nodeType) {
                case NAME_NODE: {
                    localFS.copyToLocalFile(new Path(namenodeStorage.toString(), "current"), new Path(newDir.toString()), false);
                    Path newImgDir = new Path(newDir.getParent(), "image");
                    if (localFS.exists(newImgDir)) break;
                    localFS.copyToLocalFile(new Path(namenodeStorage.toString(), "image"), newImgDir, false);
                    break;
                }
                case DATA_NODE: {
                    localFS.copyToLocalFile(new Path(datanodeStorage.toString(), "current"), new Path(newDir.toString()), false);
                    Path newStorageFile = new Path(newDir.getParent(), "storage");
                    if (localFS.exists(newStorageFile)) break;
                    localFS.copyToLocalFile(new Path(datanodeStorage.toString(), "storage"), newStorageFile, false);
                }
            }
            retVal[i] = newDir;
        }
        return retVal;
    }

    public static File[] createVersionFile(HdfsConstants.NodeType nodeType, File[] parent, StorageInfo version) throws IOException {
        FSImage storage = null;
        File[] versionFiles = new File[parent.length];
        for (int i = 0; i < parent.length; ++i) {
            File versionFile = new File(parent[i], "VERSION");
            FileUtil.fullyDelete((File)versionFile);
            switch (nodeType) {
                case NAME_NODE: {
                    storage = new FSImage(version);
                    break;
                }
                case DATA_NODE: {
                    storage = new DataStorage(version, "doNotCare");
                }
            }
            FSImage fSImage = storage;
            fSImage.getClass();
            Storage.StorageDirectory sd = new Storage.StorageDirectory((Storage)fSImage, parent[i].getParentFile());
            sd.write(versionFile);
            versionFiles[i] = versionFile;
        }
        return versionFiles;
    }

    public static void corruptFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Given argument is not a file:" + file);
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rws");
        Random random = new Random();
        for (long i = 0L; i < raf.length(); ++i) {
            raf.seek(i);
            if (!random.nextBoolean()) continue;
            raf.writeByte(random.nextInt());
        }
        raf.close();
    }

    public static int getCurrentLayoutVersion() {
        return -41;
    }

    public static int getCurrentNamespaceID(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNode().versionRequest().getNamespaceID();
        }
        return namenodeStorageNamespaceID;
    }

    public static long getCurrentFsscTime(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNode().versionRequest().getCTime();
        }
        return namenodeStorageFsscTime;
    }

    static {
        datanodeStorage = new File(TEST_ROOT_DIR, "datanodeMaster");
    }
}

