/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLease {
    final Path dir = new Path("/test/lease/");
    static final ClientProtocol mcp = (ClientProtocol)Mockito.mock(ClientProtocol.class);

    static boolean hasLease(MiniDFSCluster cluster, Path src) {
        return cluster.getNameNode().getNamesystem().leaseManager.getLeaseByPath(src.toString()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLease() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        try {
            FileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path b = new Path(this.dir, "b");
            FSDataOutputStream a_out = fs.create(a);
            a_out.writeBytes("something");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, a));
            Assert.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            FSDataOutputStream b_out = fs.create(b);
            b_out.writeBytes("something");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, a));
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, b));
            a_out.close();
            b_out.close();
            Assert.assertTrue((!TestLease.hasLease(cluster, a) ? 1 : 0) != 0);
            Assert.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testFactory() throws Exception {
        String[] groups = new String[]{"supergroup"};
        UserGroupInformation[] ugi = new UserGroupInformation[3];
        for (int i = 0; i < ugi.length; ++i) {
            ugi[i] = UserGroupInformation.createUserForTesting((String)("user" + i), (String[])groups);
        }
        Configuration conf = new Configuration();
        DFSClient c1 = TestLease.createDFSClientAs(ugi[0], conf);
        FSDataOutputStream out1 = this.createFsOut(c1, "/out1");
        DFSClient c2 = TestLease.createDFSClientAs(ugi[0], conf);
        FSDataOutputStream out2 = this.createFsOut(c2, "/out2");
        Assert.assertEquals((Object)c1.getLeaseRenewer(), (Object)c2.getLeaseRenewer());
        DFSClient c3 = TestLease.createDFSClientAs(ugi[1], conf);
        FSDataOutputStream out3 = this.createFsOut(c3, "/out3");
        Assert.assertTrue((c1.getLeaseRenewer() != c3.getLeaseRenewer() ? 1 : 0) != 0);
        DFSClient c4 = TestLease.createDFSClientAs(ugi[1], conf);
        FSDataOutputStream out4 = this.createFsOut(c4, "/out4");
        Assert.assertEquals((Object)c3.getLeaseRenewer(), (Object)c4.getLeaseRenewer());
        DFSClient c5 = TestLease.createDFSClientAs(ugi[2], conf);
        FSDataOutputStream out5 = this.createFsOut(c5, "/out5");
        Assert.assertTrue((c1.getLeaseRenewer() != c5.getLeaseRenewer() ? 1 : 0) != 0);
        Assert.assertTrue((c3.getLeaseRenewer() != c5.getLeaseRenewer() ? 1 : 0) != 0);
    }

    private FSDataOutputStream createFsOut(DFSClient dfs, String path) throws IOException {
        return new FSDataOutputStream(dfs.create(path, true), null);
    }

    public static DFSClient createDFSClientAs(UserGroupInformation ugi, final Configuration conf) throws Exception {
        return (DFSClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws Exception {
                return new DFSClient(null, mcp, conf, null);
            }
        });
    }
}

