/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.HsftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHftpFileSystem {
    Token<DelegationTokenIdentifier> hftpToken;
    Token<DelegationTokenIdentifier> hdfsToken;
    Token<DelegationTokenIdentifier> gotToken;

    @Before
    public void resetFileSystem() throws IOException {
        FileSystem.closeAll();
    }

    @Test
    public void testHftpDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hftp://localhost");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50070L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)50070L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:50070", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hftp://localhost");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)123L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:123", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomUriPortWithDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hftp://localhost:123");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50070L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)uri.getPort(), (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:123", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHftpCustomUriPortWithCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hftp://localhost:789");
        HftpFileSystem fs = (HftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)789L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:789", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hsftp://localhost");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50470L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)50470L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:50470", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hsftp://localhost");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)456L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:456", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomUriPortWithDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        URI uri = URI.create("hsftp://localhost:123");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)50470L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)uri.getPort(), (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:123", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testHsftpCustomUriPortWithCustomDefaultPorts() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
        URI uri = URI.create("hsftp://localhost:789");
        HsftpFileSystem fs = (HsftpFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        URI fsUri = fs.getUri();
        Assert.assertEquals((Object)uri.getHost(), (Object)fsUri.getHost());
        Assert.assertEquals((long)789L, (long)fsUri.getPort());
        Assert.assertEquals((Object)"127.0.0.1:789", (Object)fs.getCanonicalServiceName());
    }

    static Token<DelegationTokenIdentifier> makeDummyToken(String kind) {
        Token token = new Token();
        token.setKind(new Text(kind));
        return token;
    }

    @Before
    public void resetTokens() {
        this.gotToken = null;
        this.hdfsToken = null;
        this.hftpToken = null;
    }

    @Test
    public void testHftpWithNoTokens() throws IOException {
        new StubbedHftpFileSystem().initDelegationToken();
        Assert.assertNotNull(this.gotToken);
        Assert.assertEquals((Object)new Text("new"), (Object)this.gotToken.getKind());
    }

    @Test
    public void testHftpWithHftpToken() throws IOException {
        this.hftpToken = TestHftpFileSystem.makeDummyToken("hftp");
        new StubbedHftpFileSystem().initDelegationToken();
        Assert.assertNotNull(this.gotToken);
        Assert.assertEquals(this.gotToken, this.hftpToken);
    }

    @Test
    public void testHftpWithHdfsToken() throws IOException {
        this.hdfsToken = TestHftpFileSystem.makeDummyToken("hdfs");
        new StubbedHftpFileSystem().initDelegationToken();
        Assert.assertNotNull(this.gotToken);
        Assert.assertEquals(this.gotToken, this.hdfsToken);
    }

    @Test
    public void testHftpWithHftpAndHdfsToken() throws IOException {
        this.hftpToken = TestHftpFileSystem.makeDummyToken("hftp");
        this.hdfsToken = TestHftpFileSystem.makeDummyToken("hdfs");
        new StubbedHftpFileSystem().initDelegationToken();
        Assert.assertNotNull(this.gotToken);
        Assert.assertEquals(this.gotToken, this.hftpToken);
    }

    class StubbedHftpFileSystem
    extends HftpFileSystem {
        StubbedHftpFileSystem() {
        }

        protected Token<DelegationTokenIdentifier> selectHftpDelegationToken() {
            return TestHftpFileSystem.this.hftpToken;
        }

        protected Token<DelegationTokenIdentifier> selectHdfsDelegationToken() {
            return TestHftpFileSystem.this.hdfsToken;
        }

        public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) {
            return TestHftpFileSystem.makeDummyToken("new");
        }

        public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
            TestHftpFileSystem.this.gotToken = token;
        }
    }
}

