/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.OutputOnlyApp;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestUnconsumedInput {
    protected final int EXPECTED_OUTPUT_SIZE = 10000;
    protected File INPUT_FILE = new File("stream_uncinput_input.txt");
    protected File OUTPUT_DIR = new File("stream_uncinput_out");
    protected String input = "roses.are.red\nviolets.are.blue\nbunnies.are.pink\n";
    protected String map = UtilTest.makeJavaCommand(OutputOnlyApp.class, (String[])new String[]{Integer.toString(10000)});
    private StreamJob job;

    public TestUnconsumedInput() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        for (int i = 0; i < 10000; ++i) {
            out.write(this.input.getBytes("UTF-8"));
        }
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", "org.apache.hadoop.mapred.lib.IdentityReducer", "-numReduceTasks", "0", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnconsumedInput() throws Exception {
        String outFileName = "part-00000";
        File outFile = null;
        try {
            try {
                FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.createInput();
            Configuration conf = new Configuration();
            conf.set("stream.minRecWrittenToEnableSkip_", "0");
            this.job = new StreamJob();
            this.job.setConf(conf);
            int exitCode = this.job.run(this.genArgs());
            Assert.assertEquals((String)"Job failed", (long)0L, (long)exitCode);
            outFile = new File(this.OUTPUT_DIR, outFileName).getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            Assert.assertEquals((String)"Output was truncated", (long)10000L, (long)StringUtils.countMatches((String)output, (String)"\t"));
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }
}

