/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TrApp;
import org.apache.hadoop.streaming.TrAppReduce;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamingSeparator {
    protected File INPUT_FILE = new File("TestStreamingSeparator.input.txt");
    protected File OUTPUT_DIR = new File("TestStreamingSeparator.out");
    protected String input = "roses1are.red\nviolets1are.blue\nbunnies1are.pink\n";
    protected String map = UtilTest.makeJavaCommand(TrApp.class, (String[])new String[]{"2", "3"});
    protected String reduce = UtilTest.makeJavaCommand(TrAppReduce.class, (String[])new String[]{"3", "4"});
    protected String outputExpect = "bunnies5are.pink\nroses5are.red\nviolets5are.blue\n";
    private StreamJob job;

    public TestStreamingSeparator() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", this.reduce, "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-inputformat", "KeyValueTextInputFormat", "-jobconf", "mapreduce.input.keyvaluelinerecordreader.key.value.separator=1", "-jobconf", "stream.map.input.field.separator=2", "-jobconf", "stream.map.output.field.separator=3", "-jobconf", "stream.reduce.input.field.separator=3", "-jobconf", "stream.reduce.output.field.separator=4", "-jobconf", "mapreduce.output.textoutputformat.separator=5"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        try {
            try {
                FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.createInput();
            boolean mayExit = false;
            this.job = new StreamJob(this.genArgs(), mayExit);
            this.job.go();
            File outFile = new File(this.OUTPUT_DIR, "part-00000").getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            outFile.delete();
            System.err.println("outEx1=" + this.outputExpect);
            System.err.println("  out1=" + output);
            Assert.assertEquals((Object)this.outputExpect, (Object)output);
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }

    public static void main(String[] args) throws Exception {
        new TestStreamingSeparator().testCommandLine();
    }
}

