/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class Environment
extends Properties {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment() throws IOException {
        String command = null;
        String OS = System.getProperty("os.name");
        String lowerOs = StringUtils.toLowerCase((String)OS);
        if (OS.indexOf("Windows") > -1) {
            command = "cmd /C set";
        } else if (lowerOs.indexOf("ix") > -1 || lowerOs.indexOf("linux") > -1 || lowerOs.indexOf("freebsd") > -1 || lowerOs.indexOf("sunos") > -1 || lowerOs.indexOf("solaris") > -1 || lowerOs.indexOf("hp-ux") > -1) {
            command = "env";
        } else if (lowerOs.startsWith("mac os x") || lowerOs.startsWith("darwin")) {
            command = "env";
        }
        if (command == null) {
            throw new RuntimeException("Operating system " + OS + " not supported by this class");
        }
        Process pid = Runtime.getRuntime().exec(command);
        BufferedReader in = new BufferedReader(new InputStreamReader(pid.getInputStream(), Charset.forName("UTF-8")));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int p = line.indexOf("=");
                if (p == -1) continue;
                String name = line.substring(0, p);
                String value = line.substring(p + 1);
                this.setProperty(name, value);
            }
            in.close();
            in = null;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
        try {
            pid.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    String[] toArray() {
        String[] arr = new String[super.size()];
        Enumeration<Object> it = super.keys();
        int i = -1;
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            String val = (String)this.get((Object)key);
            arr[++i] = key + "=" + val;
        }
        return arr;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> it = super.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            String val = (String)this.get((Object)key);
            map.put(key, val);
        }
        return map;
    }

    public String getHost() {
        String host = this.getProperty("HOST");
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        return host;
    }
}

