/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;
import org.apache.hadoop.yarn.sls.synthetic.SynthUtils;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class SynthTraceJobProducer
implements JobStoryProducer {
    private static final Log LOG = LogFactory.getLog(SynthTraceJobProducer.class);
    private final Configuration conf;
    private final AtomicInteger numJobs;
    private final Trace trace;
    private final long seed;
    private int totalWeight;
    private final Queue<StoryParams> listStoryParams;
    private final JDKRandomGenerator rand;
    public static final String SLS_SYNTHETIC_TRACE_FILE = "sls.synthetic.trace_file";
    private static final int DEFAULT_MAPPER_PRIORITY = 20;
    private static final int DEFAULT_REDUCER_PRIORITY = 10;

    public SynthTraceJobProducer(Configuration conf) throws IOException {
        this(conf, new Path(conf.get(SLS_SYNTHETIC_TRACE_FILE)));
    }

    public SynthTraceJobProducer(Configuration conf, Path path) throws IOException {
        LOG.info((Object)"SynthTraceJobProducer");
        this.conf = conf;
        this.rand = new JDKRandomGenerator();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.INTERN_FIELD_NAMES, true);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FileSystem ifs = path.getFileSystem(conf);
        FSDataInputStream fileIn = ifs.open(path);
        this.trace = (Trace)mapper.readValue((InputStream)fileIn, Trace.class);
        this.seed = this.trace.rand_seed;
        this.rand.setSeed(this.seed);
        this.trace.init(this.rand);
        this.numJobs = new AtomicInteger(this.trace.num_jobs);
        for (Double w : this.trace.workload_weights) {
            this.totalWeight = (int)((double)this.totalWeight + w);
        }
        this.listStoryParams = this.createStory();
        LOG.info((Object)("Generated " + this.listStoryParams.size() + " deadlines for " + this.numJobs.get() + " jobs"));
    }

    private Queue<StoryParams> createStory() {
        PriorityQueue<StoryParams> storyQueue = new PriorityQueue<StoryParams>(this.numJobs.get(), new Comparator<StoryParams>(){

            @Override
            public int compare(StoryParams o1, StoryParams o2) {
                return Math.toIntExact(o1.actualSubmissionTime - o2.actualSubmissionTime);
            }
        });
        for (int i = 0; i < this.numJobs.get(); ++i) {
            Workload wl = this.trace.generateWorkload();
            long actualSubmissionTime = wl.generateSubmissionTime();
            String queue = wl.queue_name;
            JobDefinition job = wl.generateJobDefinition();
            storyQueue.add(new StoryParams(actualSubmissionTime, queue, job));
        }
        return storyQueue;
    }

    public JobStory getNextJob() throws IOException {
        if (this.numJobs.decrementAndGet() < 0) {
            return null;
        }
        StoryParams storyParams = this.listStoryParams.poll();
        return new SynthJob(this.rand, this.conf, storyParams.jobDef, storyParams.queue, storyParams.actualSubmissionTime);
    }

    public void close() {
    }

    public String toString() {
        return "SynthTraceJobProducer [ conf=" + this.conf + ", numJobs=" + this.numJobs + ", r=" + this.rand + ", totalWeight=" + this.totalWeight + ", workloads=" + this.trace.workloads + "]";
    }

    public int getNumJobs() {
        return this.trace.num_jobs;
    }

    private static void validateJobDef(JobDefinition jobDef) {
        if (jobDef.tasks == null) {
            LOG.info((Object)"Detected old JobDefinition format. Converting.");
            try {
                jobDef.tasks = new ArrayList<TaskDefinition>();
                jobDef.type = "mapreduce";
                jobDef.deadline_factor = new Sample(jobDef.deadline_factor_avg, jobDef.deadline_factor_stddev);
                jobDef.duration = new Sample(jobDef.dur_avg, jobDef.dur_stddev);
                jobDef.reservation = new Sample(jobDef.chance_of_reservation);
                TaskDefinition map = new TaskDefinition();
                map.type = "map";
                map.count = new Sample(jobDef.mtasks_avg, jobDef.mtasks_stddev);
                map.time = new Sample(jobDef.mtime_avg, jobDef.mtime_stddev);
                map.max_memory = new Sample(Double.valueOf(jobDef.map_max_memory_avg), jobDef.map_max_memory_stddev);
                map.max_vcores = new Sample(Double.valueOf(jobDef.map_max_vcores_avg), jobDef.map_max_vcores_stddev);
                map.priority = 20;
                map.executionType = jobDef.map_execution_type;
                jobDef.tasks.add(map);
                TaskDefinition reduce = new TaskDefinition();
                reduce.type = "reduce";
                reduce.count = new Sample(jobDef.rtasks_avg, jobDef.rtasks_stddev);
                reduce.time = new Sample(jobDef.rtime_avg, jobDef.rtime_stddev);
                reduce.max_memory = new Sample(Double.valueOf(jobDef.reduce_max_memory_avg), jobDef.reduce_max_memory_stddev);
                reduce.max_vcores = new Sample(Double.valueOf(jobDef.reduce_max_vcores_avg), jobDef.reduce_max_vcores_stddev);
                reduce.priority = 10;
                reduce.executionType = jobDef.reduce_execution_type;
                jobDef.tasks.add(reduce);
            }
            catch (JsonMappingException e) {
                LOG.warn((Object)"Error converting old JobDefinition format", (Throwable)e);
            }
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public int getNodesPerRack() {
        return this.trace.nodes_per_rack < 1 ? 1 : this.trace.nodes_per_rack;
    }

    public int getNumNodes() {
        return this.trace.num_nodes;
    }

    public static class TimeSample {
        @JsonProperty(value="time")
        int time;
        @JsonProperty(value="weight")
        double weight;
    }

    public static class Sample {
        private static final Dist DEFAULT_DIST = Dist.LOGNORM;
        private final double val;
        private final double std;
        private final Dist dist;
        private AbstractRealDistribution dist_instance;
        private final List<String> discrete;
        private final List<Double> weights;
        private final Mode mode;
        private JDKRandomGenerator rand;

        public Sample(Double val) throws JsonMappingException {
            this(val, null);
        }

        public Sample(Double val, Double std) throws JsonMappingException {
            this(val, std, null, null, null);
        }

        @JsonCreator
        public Sample(@JsonProperty(value="val") Double val, @JsonProperty(value="std") Double std, @JsonProperty(value="dist") String dist, @JsonProperty(value="discrete") List<String> discrete, @JsonProperty(value="weights") List<Double> weights) throws JsonMappingException {
            if (val != null) {
                if (std == null) {
                    if (dist != null || discrete != null || weights != null) {
                        throw new JsonMappingException("Instantiation of " + Sample.class + " failed");
                    }
                    this.mode = Mode.CONST;
                    this.val = val;
                    this.std = 0.0;
                    this.dist = null;
                    this.discrete = null;
                    this.weights = null;
                } else {
                    if (discrete != null || weights != null) {
                        throw new JsonMappingException("Instantiation of " + Sample.class + " failed");
                    }
                    this.mode = Mode.DIST;
                    this.val = val;
                    this.std = std;
                    this.dist = dist != null ? Dist.valueOf(dist) : DEFAULT_DIST;
                    this.discrete = null;
                    this.weights = null;
                }
            } else {
                if (discrete == null) {
                    throw new JsonMappingException("Instantiation of " + Sample.class + " failed");
                }
                this.mode = Mode.DISC;
                this.val = 0.0;
                this.std = 0.0;
                this.dist = null;
                this.discrete = discrete;
                if (weights == null) {
                    weights = new ArrayList<Double>(Collections.nCopies(discrete.size(), 1.0));
                }
                if (weights.size() != discrete.size()) {
                    throw new JsonMappingException("Instantiation of " + Sample.class + " failed");
                }
                this.weights = weights;
            }
        }

        public void init(JDKRandomGenerator random) {
            if (this.rand != null) {
                throw new YarnRuntimeException("init called twice");
            }
            this.rand = random;
            if (this.mode == Mode.DIST) {
                switch (this.dist) {
                    case LOGNORM: {
                        this.dist_instance = SynthUtils.getLogNormalDist(this.rand, this.val, this.std);
                        return;
                    }
                    case NORM: {
                        this.dist_instance = SynthUtils.getNormalDist(this.rand, this.val, this.std);
                        return;
                    }
                }
                throw new YarnRuntimeException("Unknown distribution " + this.dist.name());
            }
        }

        public int getInt() {
            return Math.toIntExact(this.getLong());
        }

        public long getLong() {
            return Math.round(this.getDouble());
        }

        public double getDouble() {
            return Double.parseDouble(this.getString());
        }

        public String getString() {
            if (this.rand == null) {
                throw new YarnRuntimeException("getValue called without init");
            }
            switch (this.mode) {
                case CONST: {
                    return Double.toString(this.val);
                }
                case DIST: {
                    return Double.toString(this.dist_instance.sample());
                }
                case DISC: {
                    return this.discrete.get(SynthUtils.getWeighted(this.weights, (Random)this.rand));
                }
            }
            throw new YarnRuntimeException("Unknown sampling mode " + this.mode.name());
        }

        public String toString() {
            switch (this.mode) {
                case CONST: {
                    return "value: " + Double.toString(this.val);
                }
                case DIST: {
                    return "value: " + this.val + " std: " + this.std + " dist: " + this.dist.name();
                }
                case DISC: {
                    return "discrete: " + this.discrete + ", weights: " + this.weights;
                }
            }
            throw new YarnRuntimeException("Unknown sampling mode " + this.mode.name());
        }

        private static enum Dist {
            LOGNORM,
            NORM;

        }

        private static enum Mode {
            CONST,
            DIST,
            DISC;

        }
    }

    public static class TaskDefinition {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="count")
        Sample count;
        @JsonProperty(value="time")
        Sample time;
        @JsonProperty(value="max_memory")
        Sample max_memory;
        @JsonProperty(value="max_vcores")
        Sample max_vcores;
        @JsonProperty(value="priority")
        int priority;
        @JsonProperty(value="execution_type")
        String executionType = ExecutionType.GUARANTEED.name();

        public String toString() {
            return "\nTaskDefinition " + this.type + " Count[" + this.count + "] Time[" + this.time + "] Memory[" + this.max_memory + "] Vcores[" + this.max_vcores + "] Priority[" + this.priority + "] ExecutionType[" + this.executionType + "]";
        }
    }

    public static class JobDefinition {
        @JsonProperty(value="class_name")
        String class_name;
        @JsonProperty(value="user_name")
        String user_name;
        @JsonProperty(value="class_weight")
        double class_weight;
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="deadline_factor")
        Sample deadline_factor;
        @JsonProperty(value="duration")
        Sample duration;
        @JsonProperty(value="reservation")
        Sample reservation;
        @JsonProperty(value="tasks")
        List<TaskDefinition> tasks;
        @JsonProperty(value="params")
        Map<String, String> params;
        @JsonProperty(value="chance_of_reservation")
        double chance_of_reservation;
        @JsonProperty(value="deadline_factor_avg")
        double deadline_factor_avg;
        @JsonProperty(value="deadline_factor_stddev")
        double deadline_factor_stddev;
        @JsonProperty(value="dur_avg")
        double dur_avg;
        @JsonProperty(value="dur_stddev")
        double dur_stddev;
        @JsonProperty(value="mtime_avg")
        double mtime_avg;
        @JsonProperty(value="mtime_stddev")
        double mtime_stddev;
        @JsonProperty(value="rtime_avg")
        double rtime_avg;
        @JsonProperty(value="rtime_stddev")
        double rtime_stddev;
        @JsonProperty(value="mtasks_avg")
        double mtasks_avg;
        @JsonProperty(value="mtasks_stddev")
        double mtasks_stddev;
        @JsonProperty(value="rtasks_avg")
        double rtasks_avg;
        @JsonProperty(value="rtasks_stddev")
        double rtasks_stddev;
        @JsonProperty(value="map_max_memory_avg")
        long map_max_memory_avg;
        @JsonProperty(value="map_max_memory_stddev")
        double map_max_memory_stddev;
        @JsonProperty(value="reduce_max_memory_avg")
        long reduce_max_memory_avg;
        @JsonProperty(value="reduce_max_memory_stddev")
        double reduce_max_memory_stddev;
        @JsonProperty(value="map_max_vcores_avg")
        long map_max_vcores_avg;
        @JsonProperty(value="map_max_vcores_stddev")
        double map_max_vcores_stddev;
        @JsonProperty(value="reduce_max_vcores_avg")
        long reduce_max_vcores_avg;
        @JsonProperty(value="reduce_max_vcores_stddev")
        double reduce_max_vcores_stddev;
        @JsonProperty(value="map_execution_type")
        String map_execution_type = ExecutionType.GUARANTEED.name();
        @JsonProperty(value="reduce_execution_type")
        String reduce_execution_type = ExecutionType.GUARANTEED.name();

        public void init(JDKRandomGenerator rand) {
            this.deadline_factor.init(rand);
            this.duration.init(rand);
            this.reservation.init(rand);
            for (TaskDefinition t : this.tasks) {
                t.count.init(rand);
                t.time.init(rand);
                t.max_memory.init(rand);
                t.max_vcores.init(rand);
            }
        }

        public String toString() {
            return "\nJobDefinition " + this.class_name + ", weight: " + this.class_weight + ", type: " + this.type + " " + this.tasks.toString().replace("\n", "\n\t");
        }
    }

    public static class Workload {
        @JsonProperty(value="workload_name")
        String workload_name;
        @JsonProperty(value="workload_weight")
        double workload_weight;
        @JsonProperty(value="queue_name")
        String queue_name;
        @JsonProperty(value="job_classes")
        List<JobDefinition> job_classes;
        @JsonProperty(value="time_distribution")
        List<TimeSample> time_distribution;
        JDKRandomGenerator rand;
        List<Double> job_weights;
        List<Double> time_weights;

        public void init(JDKRandomGenerator random) {
            this.rand = random;
            for (JobDefinition def : this.job_classes) {
                SynthTraceJobProducer.validateJobDef(def);
                def.init(this.rand);
            }
            this.job_weights = new ArrayList<Double>();
            this.job_weights = new ArrayList<Double>();
            for (JobDefinition j : this.job_classes) {
                this.job_weights.add(j.class_weight);
            }
            this.time_weights = new ArrayList<Double>();
            for (TimeSample ts : this.time_distribution) {
                this.time_weights.add(ts.weight);
            }
        }

        public long generateSubmissionTime() {
            int index = SynthUtils.getWeighted(this.time_weights, (Random)this.rand);
            int start = this.time_distribution.get((int)index).time;
            index = index + 1 < this.time_distribution.size() ? index + 1 : index;
            int end = this.time_distribution.get((int)index).time;
            int range = end - start;
            return start + (range > 0 ? this.rand.nextInt(range) : 0);
        }

        public JobDefinition generateJobDefinition() {
            return this.job_classes.get(SynthUtils.getWeighted(this.job_weights, (Random)this.rand));
        }

        public String toString() {
            return "\nWorkload " + this.workload_name + ", weight: " + this.workload_weight + ", queue: " + this.queue_name + " " + this.job_classes.toString().replace("\n", "\n\t");
        }
    }

    @XmlRootElement
    public static class Trace {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="num_nodes")
        int num_nodes;
        @JsonProperty(value="nodes_per_rack")
        int nodes_per_rack;
        @JsonProperty(value="num_jobs")
        int num_jobs;
        @JsonProperty(value="rand_seed")
        long rand_seed;
        @JsonProperty(value="workloads")
        List<Workload> workloads;
        List<Double> workload_weights;
        JDKRandomGenerator rand;

        public void init(JDKRandomGenerator random) {
            this.rand = random;
            for (Workload w : this.workloads) {
                w.init(this.rand);
            }
            this.workload_weights = new ArrayList<Double>();
            for (Workload w : this.workloads) {
                this.workload_weights.add(w.workload_weight);
            }
        }

        Workload generateWorkload() {
            return this.workloads.get(SynthUtils.getWeighted(this.workload_weights, (Random)this.rand));
        }
    }

    static class StoryParams {
        private long actualSubmissionTime;
        private String queue;
        private JobDefinition jobDef;

        StoryParams(long actualSubmissionTime, String queue, JobDefinition jobDef) {
            this.actualSubmissionTime = actualSubmissionTime;
            this.queue = queue;
            this.jobDef = jobDef;
        }
    }
}

