/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.MapTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ReduceTaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;

public class SynthJob
implements JobStory {
    private static Log LOG = LogFactory.getLog(SynthJob.class);
    private static final long MIN_MEMORY = 1024L;
    private static final long MIN_VCORES = 1L;
    private final Configuration conf;
    private final int id;
    private static final AtomicInteger sequence = new AtomicInteger(0);
    private final String name;
    private final String queueName;
    private final SynthTraceJobProducer.JobDefinition jobDef;
    private String type;
    private final long submitTime;
    private final long duration;
    private final long deadline;
    private Map<String, String> params;
    private long totalSlotTime = 0L;
    private List<SynthTask> tasks = new ArrayList<SynthTask>();
    private Map<String, List<SynthTask>> taskByType = new HashMap<String, List<SynthTask>>();
    private Map<String, Integer> taskCounts = new HashMap<String, Integer>();
    private Map<String, Long> taskMemory = new HashMap<String, Long>();
    private Map<String, Long> taskVcores = new HashMap<String, Long>();

    protected SynthJob(JDKRandomGenerator rand, Configuration conf, SynthTraceJobProducer.JobDefinition jobDef, String queue, long actualSubmissionTime) {
        this.conf = conf;
        this.jobDef = jobDef;
        this.queueName = queue;
        this.duration = TimeUnit.MILLISECONDS.convert(jobDef.duration.getInt(), TimeUnit.SECONDS);
        boolean hasDeadline = rand.nextDouble() <= jobDef.reservation.getDouble();
        double deadlineFactorSample = jobDef.deadline_factor.getDouble();
        this.type = jobDef.type;
        this.submitTime = TimeUnit.MILLISECONDS.convert(actualSubmissionTime, TimeUnit.SECONDS);
        this.deadline = hasDeadline ? TimeUnit.MILLISECONDS.convert(actualSubmissionTime, TimeUnit.SECONDS) + (long)Math.ceil(deadlineFactorSample * (double)this.duration) : -1L;
        this.params = jobDef.params;
        conf.set("mapreduce.job.queuename", this.queueName);
        long seed = rand.nextLong();
        rand.setSeed(seed);
        this.id = sequence.getAndIncrement();
        this.name = String.format(jobDef.class_name + "_%06d", this.id);
        LOG.debug((Object)(this.name + " (" + seed + ")"));
        LOG.info((Object)("JOB TIMING`: job: " + this.name + " submission:" + this.submitTime + " deadline:" + this.deadline + " duration:" + this.duration + " deadline-submission: " + (this.deadline - this.submitTime)));
        for (SynthTraceJobProducer.TaskDefinition task : jobDef.tasks) {
            int num = task.count.getInt();
            String taskType = task.type;
            long memory = task.max_memory.getLong();
            memory = memory < 1024L ? 1024L : memory;
            long vcores = task.max_vcores.getLong();
            vcores = vcores < 1L ? 1L : vcores;
            int priority = task.priority;
            ExecutionType executionType = task.executionType == null ? ExecutionType.GUARANTEED : ExecutionType.valueOf((String)task.executionType);
            this.taskByType.put(taskType, new ArrayList());
            this.taskCounts.put(taskType, num);
            this.taskMemory.put(taskType, memory);
            this.taskVcores.put(taskType, vcores);
            for (int i = 0; i < num; ++i) {
                long time = task.time.getLong();
                this.totalSlotTime += time;
                SynthTask t = new SynthTask(taskType, time, memory, vcores, priority, executionType);
                this.tasks.add(t);
                this.taskByType.get(taskType).add(t);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public List<SynthTask> getTasks() {
        return this.tasks;
    }

    public boolean hasDeadline() {
        return this.deadline > 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.jobDef.user_name;
    }

    public JobID getJobID() {
        return new JobID("job_mock_" + this.name, this.id);
    }

    public long getSubmissionTime() {
        return this.submitTime;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String res = "\nSynthJob [" + this.jobDef.class_name + "]: \n\tname: " + this.getName() + "\n\ttype: " + this.getType() + "\n\tid: " + this.id + "\n\tqueue: " + this.getQueueName() + "\n\tsubmission: " + this.getSubmissionTime() + "\n\tduration: " + this.getDuration() + "\n\tdeadline: " + this.getDeadline() + "\n";
        sb.append(res);
        int taskno = 0;
        for (SynthTask t : this.getTasks()) {
            sb.append("\t");
            sb.append(taskno);
            sb.append(": \t");
            sb.append(t.toString());
            ++taskno;
        }
        return sb.toString();
    }

    public long getTotalSlotTime() {
        return this.totalSlotTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SynthJob)) {
            return false;
        }
        SynthJob o = (SynthJob)other;
        return this.tasks.equals(o.tasks) && this.submitTime == o.submitTime && this.type.equals(o.type) && this.queueName.equals(o.queueName) && this.jobDef.class_name.equals(o.jobDef.class_name);
    }

    public int hashCode() {
        return this.jobDef.class_name.hashCode() * (int)this.submitTime * (int)this.duration;
    }

    public JobConf getJobConf() {
        return new JobConf(this.conf);
    }

    public int getNumberMaps() {
        return this.taskCounts.get("map");
    }

    public int getNumberReduces() {
        return this.taskCounts.get("reduce");
    }

    public InputSplit[] getInputSplits() {
        throw new UnsupportedOperationException();
    }

    public TaskInfo getTaskInfo(TaskType taskType, int taskNumber) {
        switch (taskType) {
            case MAP: {
                return new TaskInfo(-1L, -1, -1L, -1, this.taskMemory.get("map").longValue(), this.taskVcores.get("map").longValue());
            }
            case REDUCE: {
                return new TaskInfo(-1L, -1, -1L, -1, this.taskMemory.get("reduce").longValue(), this.taskVcores.get("reduce").longValue());
            }
        }
        throw new UnsupportedOperationException();
    }

    public TaskAttemptInfo getTaskAttemptInfo(TaskType taskType, int taskNumber, int taskAttemptNumber) {
        switch (taskType) {
            case MAP: {
                return new MapTaskAttemptInfo(TaskStatus.State.SUCCEEDED, this.getTaskInfo(taskType, taskNumber), this.taskByType.get("map").get(taskNumber).time, null);
            }
            case REDUCE: {
                return new ReduceTaskAttemptInfo(TaskStatus.State.SUCCEEDED, this.getTaskInfo(taskType, taskNumber), this.taskByType.get("map").get(taskNumber).time / 3L, this.taskByType.get("map").get(taskNumber).time / 3L, this.taskByType.get("map").get(taskNumber).time / 3L, null);
            }
        }
        throw new UnsupportedOperationException();
    }

    public TaskAttemptInfo getMapTaskAttemptInfoAdjusted(int taskNumber, int taskAttemptNumber, int locality) {
        throw new UnsupportedOperationException();
    }

    public Pre21JobHistoryConstants.Values getOutcome() {
        return Pre21JobHistoryConstants.Values.SUCCESS;
    }

    public static final class SynthTask {
        private String type;
        private long time;
        private long maxMemory;
        private long maxVcores;
        private int priority;
        private ExecutionType executionType;

        private SynthTask(String type, long time, long maxMemory, long maxVcores, int priority, ExecutionType executionType) {
            this.type = type;
            this.time = time;
            this.maxMemory = maxMemory;
            this.maxVcores = maxVcores;
            this.priority = priority;
            this.executionType = executionType;
        }

        public String getType() {
            return this.type;
        }

        public long getTime() {
            return this.time;
        }

        public long getMemory() {
            return this.maxMemory;
        }

        public long getVcores() {
            return this.maxVcores;
        }

        public int getPriority() {
            return this.priority;
        }

        public ExecutionType getExecutionType() {
            return this.executionType;
        }

        public String toString() {
            return String.format("[task]\ttype: %1$-10s\ttime: %2$3s\tmemory: %3$4s\tvcores: %4$2s\texecution_type: %5$-10s%n", this.getType(), this.getTime(), this.getMemory(), this.getVcores(), this.getExecutionType().toString());
        }
    }
}

