/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes.util;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.tools.rumen.datatypes.ClassName;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.datatypes.DefaultDataType;
import org.apache.hadoop.tools.rumen.datatypes.FileName;
import org.apache.hadoop.tools.rumen.datatypes.JobName;
import org.apache.hadoop.tools.rumen.datatypes.QueueName;
import org.apache.hadoop.tools.rumen.datatypes.UserName;
import org.apache.hadoop.tools.rumen.datatypes.util.JobPropertyParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapReduceJobPropertiesParser
implements JobPropertyParser {
    private Field[] mrFields = MRJobConfig.class.getFields();
    private DecimalFormat format = new DecimalFormat();
    private JobConf configuration = new JobConf(false);
    private static final Pattern MAX_HEAP_PATTERN = Pattern.compile("-Xmx[0-9]+[kKmMgGtT]?+");
    private static final Pattern MIN_HEAP_PATTERN = Pattern.compile("-Xms[0-9]+[kKmMgGtT]?+");

    private boolean accept(String key) {
        return this.getLatestKeyName(key) != null;
    }

    private String getLatestKeyName(String key) {
        this.configuration.set(key, key);
        try {
            for (Field f : this.mrFields) {
                String mrKey = f.get(f.getName()).toString();
                if (this.configuration.get(mrKey) == null) continue;
                String string = mrKey;
                return string;
            }
            Field[] arr$ = null;
            return arr$;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        finally {
            this.configuration.clear();
        }
    }

    public DataType<?> parseJobProperty(String key, String value) {
        if (this.accept(key)) {
            return this.fromString(key, value);
        }
        return null;
    }

    public static void extractMaxHeapOpts(String javaOptions, List<String> heapOpts, List<String> others) {
        for (String opt : javaOptions.split(" ")) {
            Matcher matcher = MAX_HEAP_PATTERN.matcher(opt);
            if (matcher.find()) {
                heapOpts.add(opt);
                continue;
            }
            others.add(opt);
        }
    }

    public static void extractMinHeapOpts(String javaOptions, List<String> heapOpts, List<String> others) {
        for (String opt : javaOptions.split(" ")) {
            Matcher matcher = MIN_HEAP_PATTERN.matcher(opt);
            if (matcher.find()) {
                heapOpts.add(opt);
                continue;
            }
            others.add(opt);
        }
    }

    private DataType<?> fromString(String key, String value) {
        block12: {
            if (value != null) {
                String latestKey = this.getLatestKeyName(key);
                if ("mapreduce.job.name".equals(latestKey)) {
                    return new JobName(value);
                }
                if ("mapreduce.job.user.name".equals(latestKey)) {
                    return new UserName(value);
                }
                if ("mapreduce.job.queuename".equals(latestKey)) {
                    return new QueueName(value);
                }
                if ("mapreduce.map.java.opts".equals(latestKey) || "mapreduce.reduce.java.opts".equals(latestKey)) {
                    ArrayList heapOptions = new ArrayList();
                    MapReduceJobPropertiesParser.extractMaxHeapOpts((String)value, heapOptions, new ArrayList());
                    MapReduceJobPropertiesParser.extractMinHeapOpts((String)value, heapOptions, new ArrayList());
                    return new DefaultDataType(StringUtils.join(heapOptions, (char)' '));
                }
                try {
                    this.format.parse(value);
                    return new DefaultDataType(value);
                }
                catch (ParseException pe) {
                    if ("true".equals(value) || "false".equals(value)) {
                        Boolean.parseBoolean(value);
                        return new DefaultDataType(value);
                    }
                    if (latestKey.endsWith(".class") || latestKey.endsWith(".codec")) {
                        return new ClassName(value);
                    }
                    if (latestKey.endsWith("sizes") || latestKey.endsWith(".timestamps")) {
                        new DefaultDataType(value);
                    }
                    if (!latestKey.endsWith(".dir") && !latestKey.endsWith(".location") && !latestKey.endsWith(".jar") && !latestKey.endsWith(".path") && !latestKey.endsWith(".logfile") && !latestKey.endsWith(".file") && !latestKey.endsWith(".files") && !latestKey.endsWith(".archives")) break block12;
                    try {
                        return new FileName(value);
                    }
                    catch (Exception ioe) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    static {
        Logger.getLogger(Configuration.class).setLevel(Level.OFF);
    }
}

