/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.ozone.BasicOzoneFileSystem;
import org.apache.hadoop.fs.ozone.CapableOzoneFSInputStream;
import org.apache.hadoop.fs.ozone.OzoneClientAdapter;
import org.apache.hadoop.fs.ozone.OzoneClientAdapterImpl;
import org.apache.hadoop.fs.ozone.OzoneFSStorageStatistics;
import org.apache.hadoop.fs.ozone.Statistic;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.security.token.DelegationTokenIssuer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OzoneFileSystem
extends BasicOzoneFileSystem
implements KeyProviderTokenIssuer {
    private OzoneFSStorageStatistics storageStatistics = new OzoneFSStorageStatistics();

    public KeyProvider getKeyProvider() throws IOException {
        return this.getAdapter().getKeyProvider();
    }

    public URI getKeyProviderUri() throws IOException {
        return this.getAdapter().getKeyProviderUri();
    }

    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        KeyProvider keyProvider;
        try {
            keyProvider = this.getKeyProvider();
        }
        catch (IOException ioe) {
            LOG.debug("Error retrieving KeyProvider.", (Throwable)ioe);
            return null;
        }
        if (keyProvider instanceof DelegationTokenIssuer) {
            return new DelegationTokenIssuer[]{(DelegationTokenIssuer)keyProvider};
        }
        return null;
    }

    StorageStatistics getOzoneFSOpsCountStatistics() {
        return this.storageStatistics;
    }

    protected void incrementCounter(Statistic statistic, long count) {
        if (this.storageStatistics != null) {
            this.storageStatistics.incrementCounter(statistic, count);
        }
    }

    protected OzoneClientAdapter createAdapter(ConfigurationSource conf, String bucketStr, String volumeStr, String omHost, int omPort) throws IOException {
        return new OzoneClientAdapterImpl(omHost, omPort, conf, volumeStr, bucketStr, this.storageStatistics);
    }

    protected InputStream createFSInputStream(InputStream inputStream) {
        return new CapableOzoneFSInputStream(inputStream, this.statistics);
    }
}

