/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public final class OzoneObjInfo
extends OzoneObj {
    private final String volumeName;
    private final String bucketName;
    private final String name;

    private OzoneObjInfo(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, String volumeName, String bucketName, String name) {
        super(resType, storeType);
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = name;
    }

    @Override
    public String getPath() {
        switch (this.getResourceType()) {
            case VOLUME: {
                return "/" + this.getVolumeName();
            }
            case BUCKET: {
                return "/" + this.getVolumeName() + "/" + this.getBucketName();
            }
            case KEY: {
                return "/" + this.getVolumeName() + "/" + this.getBucketName() + "/" + this.getKeyName();
            }
            case PREFIX: {
                return "/" + this.getVolumeName() + "/" + this.getBucketName() + "/" + this.getPrefixName();
            }
        }
        throw new IllegalArgumentException("Unknown resource type" + (Object)((Object)this.getResourceType()));
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public String getKeyName() {
        return this.name;
    }

    @Override
    public String getPrefixName() {
        return this.name;
    }

    public static OzoneObjInfo fromProtobuf(OzoneManagerProtocolProtos.OzoneObj proto) {
        Builder builder = new Builder().setResType(OzoneObj.ResourceType.valueOf(proto.getResType().name())).setStoreType(OzoneObj.StoreType.valueOf(proto.getStoreType().name()));
        String[] tokens = StringUtils.split((String)proto.getPath(), (String)"/", (int)3);
        if (tokens == null) {
            throw new IllegalArgumentException("Unexpected path:" + proto.getPath());
        }
        switch (proto.getResType()) {
            case VOLUME: {
                builder.setVolumeName(tokens[0]);
                break;
            }
            case BUCKET: {
                if (tokens.length < 2) {
                    throw new IllegalArgumentException("Unexpected argument for Ozone bucket. Path:" + proto.getPath());
                }
                builder.setVolumeName(tokens[0]);
                builder.setBucketName(tokens[1]);
                break;
            }
            case KEY: {
                if (tokens.length < 3) {
                    throw new IllegalArgumentException("Unexpected argument for Ozone key. Path:" + proto.getPath());
                }
                builder.setVolumeName(tokens[0]);
                builder.setBucketName(tokens[1]);
                builder.setKeyName(tokens[2]);
                break;
            }
            case PREFIX: {
                if (tokens.length < 3) {
                    throw new IllegalArgumentException("Unexpected argument for Ozone Prefix. Path:" + proto.getPath());
                }
                builder.setVolumeName(tokens[0]);
                builder.setBucketName(tokens[1]);
                builder.setPrefixName(tokens[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type for Ozone key. Type:" + proto.getResType());
            }
        }
        return builder.build();
    }

    public static class Builder {
        private OzoneObj.ResourceType resType;
        private OzoneObj.StoreType storeType;
        private String volumeName;
        private String bucketName;
        private String name;

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder getBuilder(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, String vol, String bucket, String key) {
            return Builder.newBuilder().setResType(resType).setStoreType(storeType).setVolumeName(vol).setBucketName(bucket).setKeyName(key);
        }

        public static Builder fromKeyArgs(OmKeyArgs args) {
            return new Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setResType(OzoneObj.ResourceType.KEY);
        }

        public Builder setResType(OzoneObj.ResourceType res) {
            this.resType = res;
            return this;
        }

        public Builder setStoreType(OzoneObj.StoreType store) {
            this.storeType = store;
            return this;
        }

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.name = key;
            return this;
        }

        public Builder setPrefixName(String prefix) {
            this.name = prefix;
            return this;
        }

        public OzoneObjInfo build() {
            return new OzoneObjInfo(this.resType, this.storeType, this.volumeName, this.bucketName, this.name);
        }
    }
}

