/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.ByteString;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

public final class OMPBHelper {
    private OMPBHelper() {
    }

    public static SecurityProtos.TokenProto convertToTokenProto(Token<?> tok) {
        if (tok == null) {
            throw new IllegalArgumentException("Invalid argument: token is null");
        }
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(OMPBHelper.getByteString(tok.getIdentifier())).setPassword(OMPBHelper.getByteString(tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static Token<OzoneTokenIdentifier> convertToDelegationToken(SecurityProtos.TokenProto tokenProto) {
        return new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
    }

    public static BucketEncryptionKeyInfo convert(OzoneManagerProtocolProtos.BucketEncryptionInfoProto beInfo) {
        if (beInfo == null) {
            throw new IllegalArgumentException("Invalid argument: bucket encryption info is null");
        }
        return new BucketEncryptionKeyInfo(beInfo.hasCryptoProtocolVersion() ? OMPBHelper.convert(beInfo.getCryptoProtocolVersion()) : null, beInfo.hasSuite() ? OMPBHelper.convert(beInfo.getSuite()) : null, beInfo.getKeyName());
    }

    public static OzoneManagerProtocolProtos.BucketEncryptionInfoProto convert(BucketEncryptionKeyInfo beInfo) {
        if (beInfo == null || beInfo.getKeyName() == null) {
            throw new IllegalArgumentException("Invalid argument: bucket encryption info is null");
        }
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(beInfo.getKeyName());
        if (beInfo.getSuite() != null) {
            bb.setSuite(OMPBHelper.convert(beInfo.getSuite()));
        }
        if (beInfo.getVersion() != null) {
            bb.setCryptoProtocolVersion(OMPBHelper.convert(beInfo.getVersion()));
        }
        return bb.build();
    }

    public static OzoneManagerProtocolProtos.FileEncryptionInfoProto convert(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return OzoneManagerProtocolProtos.FileEncryptionInfoProto.newBuilder().setSuite(OMPBHelper.convert(info.getCipherSuite())).setCryptoProtocolVersion(OMPBHelper.convert(info.getCryptoProtocolVersion())).setKey(OMPBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(OMPBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).setKeyName(info.getKeyName()).build();
    }

    public static FileEncryptionInfo convert(OzoneManagerProtocolProtos.FileEncryptionInfoProto proto) {
        if (proto == null) {
            return null;
        }
        CipherSuite suite = OMPBHelper.convert(proto.getSuite());
        CryptoProtocolVersion version = OMPBHelper.convert(proto.getCryptoProtocolVersion());
        byte[] key = proto.getKey().toByteArray();
        byte[] iv = proto.getIv().toByteArray();
        String ezKeyVersionName = proto.getEzKeyVersionName();
        String keyName = proto.getKeyName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static CipherSuite convert(OzoneManagerProtocolProtos.CipherSuiteProto proto) {
        switch (proto) {
            case AES_CTR_NOPADDING: {
                return CipherSuite.AES_CTR_NOPADDING;
            }
        }
        CipherSuite suite = CipherSuite.UNKNOWN;
        suite.setUnknownValue(proto.getNumber());
        return suite;
    }

    public static OzoneManagerProtocolProtos.CipherSuiteProto convert(CipherSuite suite) {
        switch (suite) {
            case UNKNOWN: {
                return OzoneManagerProtocolProtos.CipherSuiteProto.UNKNOWN;
            }
            case AES_CTR_NOPADDING: {
                return OzoneManagerProtocolProtos.CipherSuiteProto.AES_CTR_NOPADDING;
            }
        }
        return null;
    }

    public static OzoneManagerProtocolProtos.CryptoProtocolVersionProto convert(CryptoProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                return OzoneManagerProtocolProtos.CryptoProtocolVersionProto.UNKNOWN_PROTOCOL_VERSION;
            }
            case ENCRYPTION_ZONES: {
                return OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES;
            }
        }
        return null;
    }

    public static CryptoProtocolVersion convert(OzoneManagerProtocolProtos.CryptoProtocolVersionProto proto) {
        switch (proto) {
            case ENCRYPTION_ZONES: {
                return CryptoProtocolVersion.ENCRYPTION_ZONES;
            }
        }
        CryptoProtocolVersion version = CryptoProtocolVersion.UNKNOWN;
        version.setUnknownValue(proto.getNumber());
        return version;
    }
}

