/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDeleteKeys;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public final class OzoneManagerProtocolClientSideTranslatorPB
implements OzoneManagerProtocol {
    private final String clientID;
    private OmTransport transport;

    public OzoneManagerProtocolClientSideTranslatorPB(OmTransport omTransport, String clientId) {
        this.clientID = clientId;
        this.transport = omTransport;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    private OzoneManagerProtocolProtos.OMRequest.Builder createOMRequest(OzoneManagerProtocolProtos.Type cmdType) {
        return OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(cmdType).setVersion(1).setClientId(this.clientID);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws IOException {
        OzoneManagerProtocolProtos.OMRequest payload = OzoneManagerProtocolProtos.OMRequest.newBuilder((OzoneManagerProtocolProtos.OMRequest)omRequest).setTraceID(TracingUtil.exportCurrentSpan()).build();
        return this.transport.submitRequest(payload);
    }

    @Override
    public void createVolume(OmVolumeArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateVolumeRequest.Builder req = OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder();
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = args.getProtobuf();
        req.setVolumeInfo(volumeInfo);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateVolume).setCreateVolumeRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public boolean setOwner(String volume, String owner) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setOwnerName(owner);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        OzoneManagerProtocolProtos.SetVolumePropertyResponse response = this.handleError(omResponse).getSetVolumePropertyResponse();
        return response.getResponse();
    }

    @Override
    public void setQuota(String volume, long quotaInNamespace, long quotaInBytes) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setQuotaInBytes(quotaInBytes).setQuotaInNamespace(quotaInNamespace);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessRequest.Builder req = OzoneManagerProtocolProtos.CheckVolumeAccessRequest.newBuilder();
        req.setVolumeName(volume).setUserAcl(userAcl);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CheckVolumeAccess).setCheckVolumeAccessRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.ACCESS_DENIED) {
            return false;
        }
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return true;
        }
        this.handleError(omResponse);
        return false;
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeRequest.Builder req = OzoneManagerProtocolProtos.InfoVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoVolume).setInfoVolumeRequest(req).build();
        OzoneManagerProtocolProtos.InfoVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoVolumeResponse();
        return OmVolumeArgs.getFromProtobuf(resp.getVolumeInfo());
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        OzoneManagerProtocolProtos.DeleteVolumeRequest.Builder req = OzoneManagerProtocolProtos.DeleteVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteVolume).setDeleteVolumeRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setUserName(userName);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER);
        return this.listVolume(builder.build());
    }

    @Override
    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER);
        return this.listVolume(builder.build());
    }

    private List<OmVolumeArgs> listVolume(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListVolume).setListVolumeRequest(request).build();
        OzoneManagerProtocolProtos.ListVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getListVolumeResponse();
        ArrayList<OmVolumeArgs> list = new ArrayList<OmVolumeArgs>(resp.getVolumeInfoList().size());
        for (OzoneManagerProtocolProtos.VolumeInfo info : resp.getVolumeInfoList()) {
            list.add(OmVolumeArgs.getFromProtobuf(info));
        }
        return list;
    }

    @Override
    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder req = OzoneManagerProtocolProtos.CreateBucketRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketInfo bucketInfoProtobuf = bucketInfo.getProtobuf();
        req.setBucketInfo(bucketInfoProtobuf);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateBucket).setCreateBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketRequest.Builder req = OzoneManagerProtocolProtos.InfoBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoBucket).setInfoBucketRequest(req).build();
        OzoneManagerProtocolProtos.InfoBucketResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoBucketResponse();
        return OmBucketInfo.getFromProtobuf(resp.getBucketInfo());
    }

    @Override
    public void setBucketProperty(OmBucketArgs args) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder req = OzoneManagerProtocolProtos.SetBucketPropertyRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = args.getProtobuf();
        req.setBucketArgs(bucketArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetBucketProperty).setSetBucketPropertyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int count) throws IOException {
        ArrayList<OmBucketInfo> buckets = new ArrayList<OmBucketInfo>();
        OzoneManagerProtocolProtos.ListBucketsRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListBucketsRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setCount(count);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListBucketsRequest request = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListBuckets).setListBucketsRequest(request).build();
        OzoneManagerProtocolProtos.ListBucketsResponse resp = this.handleError(this.submitRequest(omRequest)).getListBucketsResponse();
        buckets.addAll(resp.getBucketInfoList().stream().map(OmBucketInfo::getFromProtobuf).collect(Collectors.toList()));
        return buckets;
    }

    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder req = OzoneManagerProtocolProtos.CreateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName());
        if (args.getAcls() != null) {
            keyArgs.addAllAcls((Iterable)args.getAcls().stream().distinct().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        if (args.getFactor() != null) {
            keyArgs.setFactor(args.getFactor());
        }
        if (args.getType() != null) {
            keyArgs.setType(args.getType());
        }
        if (args.getDataSize() > 0L) {
            keyArgs.setDataSize(args.getDataSize());
        }
        if (args.getMetadata() != null && args.getMetadata().size() > 0) {
            keyArgs.addAllMetadata(KeyValueUtil.toProtobuf(args.getMetadata()));
        }
        req.setKeyArgs(keyArgs.build());
        if (args.getMultipartUploadID() != null) {
            keyArgs.setMultipartUploadID(args.getMultipartUploadID());
        }
        if (args.getMultipartUploadPartNumber() > 0) {
            keyArgs.setMultipartNumber(args.getMultipartUploadPartNumber());
        }
        keyArgs.setIsMultipartKey(args.getIsMultipartKey());
        req.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateKey).setCreateKeyRequest(req).build();
        OzoneManagerProtocolProtos.CreateKeyResponse keyResponse = this.handleError(this.submitRequest(omRequest)).getCreateKeyResponse();
        return new OpenKeySession(keyResponse.getID(), OmKeyInfo.getFromProtobuf(keyResponse.getKeyInfo()), keyResponse.getOpenVersion());
    }

    private OzoneManagerProtocolProtos.OMResponse handleError(OzoneManagerProtocolProtos.OMResponse resp) throws OMException {
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new OMException(resp.getMessage(), OMException.ResultCodes.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientId, ExcludeList excludeList) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder req = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize());
        if (args.getFactor() != null) {
            keyArgs.setFactor(args.getFactor());
        }
        if (args.getType() != null) {
            keyArgs.setType(args.getType());
        }
        req.setKeyArgs(keyArgs);
        req.setClientID(clientId);
        req.setExcludeList(excludeList.getProtoBuf());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AllocateBlock).setAllocateBlockRequest(req).build();
        OzoneManagerProtocolProtos.AllocateBlockResponse resp = this.handleError(this.submitRequest(omRequest)).getAllocateBlockResponse();
        return OmKeyLocationInfo.getFromProtobuf(resp.getKeyLocation());
    }

    @Override
    public void commitKey(OmKeyArgs args, long clientId) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyRequest.Builder req = OzoneManagerProtocolProtos.CommitKeyRequest.newBuilder();
        List<OmKeyLocationInfo> locationInfoList = args.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setType(args.getType()).setFactor(args.getFactor()).addAllKeyLocations((Iterable)locationInfoList.stream().map(info -> info.getProtobuf(1)).collect(Collectors.toList())).build();
        req.setKeyArgs(keyArgs);
        req.setClientID(clientId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitKey).setCommitKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyRequest.Builder req = OzoneManagerProtocolProtos.LookupKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setSortDatanodes(args.getSortDatanodes()).build();
        req.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupKey).setLookupKeyRequest(req).build();
        OzoneManagerProtocolProtos.LookupKeyResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupKeyResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public void renameKeys(OmRenameKeys omRenameKeys) throws IOException {
        ArrayList<OzoneManagerProtocolProtos.RenameKeysMap> renameKeyList = new ArrayList<OzoneManagerProtocolProtos.RenameKeysMap>();
        for (Map.Entry<String, String> entry : omRenameKeys.getFromAndToKey().entrySet()) {
            OzoneManagerProtocolProtos.RenameKeysMap.Builder renameKey = OzoneManagerProtocolProtos.RenameKeysMap.newBuilder().setFromKeyName(entry.getKey()).setToKeyName(entry.getValue());
            renameKeyList.add(renameKey.build());
        }
        OzoneManagerProtocolProtos.RenameKeysArgs.Builder renameKeyArgs = OzoneManagerProtocolProtos.RenameKeysArgs.newBuilder().setVolumeName(omRenameKeys.getVolume()).setBucketName(omRenameKeys.getBucket()).addAllRenameKeysMap(renameKeyList);
        OzoneManagerProtocolProtos.RenameKeysRequest.Builder reqKeys = OzoneManagerProtocolProtos.RenameKeysRequest.newBuilder().setRenameKeysArgs(renameKeyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKeys).setRenameKeysRequest(reqKeys.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyRequest.Builder req = OzoneManagerProtocolProtos.RenameKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        req.setToKeyName(toKeyName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKey).setRenameKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyRequest.Builder req = OzoneManagerProtocolProtos.DeleteKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        req.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKey).setDeleteKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteKeys(OmDeleteKeys deleteKeys) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeysRequest.Builder req = OzoneManagerProtocolProtos.DeleteKeysRequest.newBuilder();
        OzoneManagerProtocolProtos.DeleteKeyArgs deletedKeys = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setBucketName(deleteKeys.getBucket()).setVolumeName(deleteKeys.getVolume()).addAllKeys(deleteKeys.getKeyNames()).build();
        req.setDeleteKeys(deletedKeys);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKeys).setDeleteKeysRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteBucket(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketRequest.Builder req = OzoneManagerProtocolProtos.DeleteBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteBucket).setDeleteBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String prefix, int maxKeys) throws IOException {
        ArrayList<OmKeyInfo> keys = new ArrayList<OmKeyInfo>();
        OzoneManagerProtocolProtos.ListKeysRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListKeysRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setBucketName(bucketName);
        reqBuilder.setCount(maxKeys);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListKeysRequest req = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListKeys).setListKeysRequest(req).build();
        OzoneManagerProtocolProtos.ListKeysResponse resp = this.handleError(this.submitRequest(omRequest)).getListKeysResponse();
        keys.addAll(resp.getKeyInfoList().stream().map(OmKeyInfo::getFromProtobuf).collect(Collectors.toList()));
        return keys;
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        OzoneManagerProtocolProtos.GetS3SecretRequest request = OzoneManagerProtocolProtos.GetS3SecretRequest.newBuilder().setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetS3Secret).setGetS3SecretRequest(request).build();
        OzoneManagerProtocolProtos.GetS3SecretResponse resp = this.handleError(this.submitRequest(omRequest)).getGetS3SecretResponse();
        return S3SecretValue.fromProtobuf(resp.getS3Secret());
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.Builder multipartInfoInitiateRequest = OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setFactor(omKeyArgs.getFactor()).addAllAcls((Iterable)omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).setType(omKeyArgs.getType());
        multipartInfoInitiateRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartInfoInitiateResponse resp = this.handleError(this.submitRequest(omRequest)).getInitiateMultiPartUploadResponse();
        return new OmMultipartInfo(resp.getVolumeName(), resp.getBucketName(), resp.getKeyName(), resp.getMultipartUploadID());
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientId) throws IOException {
        List<OmKeyLocationInfo> locationInfoList = omKeyArgs.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.Builder multipartCommitUploadPartRequest = OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID()).setIsMultipartKey(omKeyArgs.getIsMultipartKey()).setMultipartNumber(omKeyArgs.getMultipartUploadPartNumber()).setDataSize(omKeyArgs.getDataSize()).addAllKeyLocations((Iterable)locationInfoList.stream().map(info -> info.getProtobuf(1)).collect(Collectors.toList()));
        multipartCommitUploadPartRequest.setClientID(clientId);
        multipartCommitUploadPartRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse response = this.handleError(this.submitRequest(omRequest)).getCommitMultiPartUploadResponse();
        OmMultipartCommitUploadPartInfo info2 = new OmMultipartCommitUploadPartInfo(response.getPartName());
        return info2;
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.Builder multipartUploadCompleteRequest = OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).addAllAcls((Iterable)omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        multipartUploadCompleteRequest.setKeyArgs(keyArgs.build());
        multipartUploadCompleteRequest.addAllPartsList(multipartUploadList.getPartsList());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload).setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadCompleteResponse response = this.handleError(this.submitRequest(omRequest)).getCompleteMultiPartUploadResponse();
        OmMultipartUploadCompleteInfo info = new OmMultipartUploadCompleteInfo(response.getVolume(), response.getBucket(), response.getKey(), response.getHash());
        return info;
    }

    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        OzoneManagerProtocolProtos.MultipartUploadAbortRequest.Builder multipartUploadAbortRequest = OzoneManagerProtocolProtos.MultipartUploadAbortRequest.newBuilder();
        multipartUploadAbortRequest.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload).setAbortMultiPartUploadRequest(multipartUploadAbortRequest.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.Builder multipartUploadListPartsRequest = OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.newBuilder();
        multipartUploadListPartsRequest.setVolume(volumeName).setBucket(bucketName).setKey(keyName).setUploadID(uploadID).setPartNumbermarker(partNumberMarker).setMaxParts(maxParts);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultiPartUploadParts).setListMultipartUploadPartsRequest(multipartUploadListPartsRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse response = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadPartsResponse();
        OmMultipartUploadListParts omMultipartUploadListParts = new OmMultipartUploadListParts(response.getType(), response.getFactor(), response.getNextPartNumberMarker(), response.getIsTruncated());
        omMultipartUploadListParts.addProtoPartList(response.getPartsListList());
        return omMultipartUploadListParts;
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws IOException {
        OzoneManagerProtocolProtos.ListMultipartUploadsRequest request = OzoneManagerProtocolProtos.ListMultipartUploadsRequest.newBuilder().setVolume(volumeName).setBucket(bucketName).setPrefix(prefix == null ? "" : prefix).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultipartUploads).setListMultipartUploadsRequest(request).build();
        OzoneManagerProtocolProtos.ListMultipartUploadsResponse listMultipartUploadsResponse = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadsResponse();
        List<OmMultipartUpload> uploadList = listMultipartUploadsResponse.getUploadsListList().stream().map(proto -> new OmMultipartUpload(proto.getVolumeName(), proto.getBucketName(), proto.getKeyName(), proto.getUploadId(), Instant.ofEpochMilli(proto.getCreationTime()), proto.getType(), proto.getFactor())).collect(Collectors.toList());
        OmMultipartUploadList response = new OmMultipartUploadList(uploadList);
        return response;
    }

    @Override
    public List<ServiceInfo> getServiceList() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList());
    }

    @Override
    public ServiceInfoEx getServiceInfo() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return new ServiceInfoEx(resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList()), resp.getCaCertificate());
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer == null ? "" : renewer.toString()).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetDelegationToken).setGetDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.GetDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getGetDelegationTokenResponse();
            return resp.getResponse().hasToken() ? OMPBHelper.convertToDelegationToken(resp.getResponse().getToken()) : null;
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Get delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenewDelegationToken).setRenewDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getRenewDelegationTokenResponse();
            return resp.getResponse().getNewExpiryTime();
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Renew delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CancelDelegationToken).setCancelDelegationTokenRequest(req).build();
        try {
            this.handleError(this.submitRequest(omRequest));
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Cancel delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).build();
        OzoneManagerProtocolProtos.GetFileStatusRequest req = OzoneManagerProtocolProtos.GetFileStatusRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetFileStatus).setGetFileStatusRequest(req).build();
        OzoneManagerProtocolProtos.GetFileStatusResponse resp = this.handleError(this.submitRequest(omRequest)).getGetFileStatusResponse();
        return OzoneFileStatus.getFromProtobuf(resp.getStatus());
    }

    @Override
    public void createDirectory(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).addAllAcls((Iterable)args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).build();
        OzoneManagerProtocolProtos.CreateDirectoryRequest request = OzoneManagerProtocolProtos.CreateDirectoryRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateDirectory).setCreateDirectoryRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (!omResponse.getStatus().equals((Object)OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS)) {
            this.handleError(omResponse);
        }
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).build();
        OzoneManagerProtocolProtos.LookupFileRequest lookupFileRequest = OzoneManagerProtocolProtos.LookupFileRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupFile).setLookupFileRequest(lookupFileRequest).build();
        OzoneManagerProtocolProtos.LookupFileResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupFileResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.AddAclRequest req = OzoneManagerProtocolProtos.AddAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AddAcl).setAddAclRequest(req).build();
        OzoneManagerProtocolProtos.AddAclResponse addAclResponse = this.handleError(this.submitRequest(omRequest)).getAddAclResponse();
        return addAclResponse.getResponse();
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.RemoveAclRequest req = OzoneManagerProtocolProtos.RemoveAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RemoveAcl).setRemoveAclRequest(req).build();
        OzoneManagerProtocolProtos.RemoveAclResponse response = this.handleError(this.submitRequest(omRequest)).getRemoveAclResponse();
        return response.getResponse();
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        OzoneManagerProtocolProtos.SetAclRequest.Builder builder = OzoneManagerProtocolProtos.SetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj));
        acls.forEach(a -> builder.addAcl(OzoneAcl.toProtobuf(a)));
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetAcl).setSetAclRequest(builder.build()).build();
        OzoneManagerProtocolProtos.SetAclResponse response = this.handleError(this.submitRequest(omRequest)).getSetAclResponse();
        return response.getResponse();
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        OzoneManagerProtocolProtos.GetAclRequest req = OzoneManagerProtocolProtos.GetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetAcl).setGetAclRequest(req).build();
        OzoneManagerProtocolProtos.GetAclResponse response = this.handleError(this.submitRequest(omRequest)).getGetAclResponse();
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        response.getAclsList().stream().forEach(a -> acls.add(OzoneAcl.fromProtobuf(a)));
        return acls;
    }

    @Override
    public DBUpdates getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DBUpdates).setDbUpdatesRequest(dbUpdatesRequest).build();
        OzoneManagerProtocolProtos.DBUpdatesResponse dbUpdatesResponse = this.handleError(this.submitRequest(omRequest)).getDbUpdatesResponse();
        DBUpdates dbUpdatesWrapper = new DBUpdates();
        for (ByteString byteString : dbUpdatesResponse.getDataList()) {
            dbUpdatesWrapper.addWriteBatch(byteString.toByteArray(), 0L);
        }
        dbUpdatesWrapper.setCurrentSequenceNumber(dbUpdatesResponse.getSequenceNumber());
        return dbUpdatesWrapper;
    }

    @Override
    public OpenKeySession createFile(OmKeyArgs args, boolean overWrite, boolean recursive) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setType(args.getType()).setFactor(args.getFactor()).addAllAcls((Iterable)args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).build();
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = OzoneManagerProtocolProtos.CreateFileRequest.newBuilder().setKeyArgs(keyArgs).setIsOverwrite(overWrite).setIsRecursive(recursive).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateFile).setCreateFileRequest(createFileRequest).build();
        OzoneManagerProtocolProtos.CreateFileResponse resp = this.handleError(this.submitRequest(omRequest)).getCreateFileResponse();
        return new OpenKeySession(resp.getID(), OmKeyInfo.getFromProtobuf(resp.getKeyInfo()), resp.getOpenVersion());
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).build();
        OzoneManagerProtocolProtos.ListStatusRequest listStatusRequest = OzoneManagerProtocolProtos.ListStatusRequest.newBuilder().setKeyArgs(keyArgs).setRecursive(recursive).setStartKey(startKey).setNumEntries(numEntries).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListStatus).setListStatusRequest(listStatusRequest).build();
        OzoneManagerProtocolProtos.ListStatusResponse listStatusResponse = this.handleError(this.submitRequest(omRequest)).getListStatusResponse();
        ArrayList<OzoneFileStatus> statusList = new ArrayList<OzoneFileStatus>(listStatusResponse.getStatusesCount());
        for (OzoneManagerProtocolProtos.OzoneFileStatusProto fileStatus : listStatusResponse.getStatusesList()) {
            statusList.add(OzoneFileStatus.getFromProtobuf(fileStatus));
        }
        return statusList;
    }

    @Override
    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)volumeName), (Object)"The volume name cannot be null or empty.  Please enter a valid volume name or use '*' as a wild card");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)bucketName), (Object)"The bucket name cannot be null or empty.  Please enter a valid bucket name or use '*' as a wild card");
        OzoneManagerProtocolProtos.ListTrashRequest trashRequest = OzoneManagerProtocolProtos.ListTrashRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setStartKeyName(startKeyName).setKeyPrefix(keyPrefix).setMaxKeys(maxKeys).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListTrash).setListTrashRequest(trashRequest).build();
        OzoneManagerProtocolProtos.ListTrashResponse trashResponse = this.handleError(this.submitRequest(omRequest)).getListTrashResponse();
        ArrayList<RepeatedOmKeyInfo> deletedKeyList = new ArrayList<RepeatedOmKeyInfo>(trashResponse.getDeletedKeysCount());
        deletedKeyList.addAll(trashResponse.getDeletedKeysList().stream().map(RepeatedOmKeyInfo::getFromProto).collect(Collectors.toList()));
        return deletedKeyList;
    }

    @Override
    public boolean recoverTrash(String volumeName, String bucketName, String keyName, String destinationBucket) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)volumeName), (Object)"The volume name cannot be null or empty. Please enter a valid volume name.");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)bucketName), (Object)"The bucket name cannot be null or empty. Please enter a valid bucket name.");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)keyName), (Object)"The key name cannot be null or empty. Please enter a valid key name.");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)destinationBucket), (Object)"The destination bucket name cannot be null or empty. Please enter a valid destination bucket name.");
        OzoneManagerProtocolProtos.RecoverTrashRequest.Builder req = OzoneManagerProtocolProtos.RecoverTrashRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDestinationBucket(destinationBucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RecoverTrash).setRecoverTrashRequest(req).build();
        OzoneManagerProtocolProtos.RecoverTrashResponse recoverResponse = this.handleError(this.submitRequest(omRequest)).getRecoverTrashResponse();
        return recoverResponse.getResponse();
    }

    @VisibleForTesting
    public OmTransport getTransport() {
        return this.transport;
    }
}

