/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.RequestContext;

public final class OzoneAclUtil {
    private OzoneAclUtil() {
    }

    public static List<OzoneAcl> getAclList(String userName, String[] userGroups, IAccessAuthorizer.ACLType userRights, IAccessAuthorizer.ACLType groupRights) {
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, userName, userRights, OzoneAcl.AclScope.ACCESS));
        if (userGroups != null) {
            Arrays.asList(userGroups).forEach(group -> listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.GROUP, (String)group, groupRights, OzoneAcl.AclScope.ACCESS)));
        }
        return listOfAcls;
    }

    public static boolean checkAclRight(List<OzoneAcl> acls, RequestContext context) throws OMException {
        String[] userGroups = context.getClientUgi().getGroupNames();
        String userName = context.getClientUgi().getUserName();
        IAccessAuthorizer.ACLType aclToCheck = context.getAclRights();
        for (OzoneAcl a : acls) {
            if (!OzoneAclUtil.checkAccessInAcl(a, userGroups, userName, aclToCheck)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAccessInAcl(OzoneAcl a, String[] groups, String username, IAccessAuthorizer.ACLType aclToCheck) {
        BitSet rights = a.getAclBitSet();
        switch (a.getType()) {
            case USER: {
                if (!a.getName().equals(username)) break;
                return OzoneAclUtil.checkIfAclBitIsSet(aclToCheck, rights);
            }
            case GROUP: {
                for (String grp : groups) {
                    if (!a.getName().equals(grp)) continue;
                    return OzoneAclUtil.checkIfAclBitIsSet(aclToCheck, rights);
                }
                break;
            }
            default: {
                return OzoneAclUtil.checkIfAclBitIsSet(aclToCheck, rights);
            }
        }
        return false;
    }

    public static boolean checkAclRights(List<OzoneAcl> acls, RequestContext context) throws OMException {
        String[] userGroups = context.getClientUgi().getGroupNames();
        String userName = context.getClientUgi().getUserName();
        IAccessAuthorizer.ACLType aclToCheck = context.getAclRights();
        for (OzoneAcl acl : acls) {
            if (!OzoneAclUtil.checkAccessInAcl(acl, userGroups, userName, aclToCheck)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfAclBitIsSet(IAccessAuthorizer.ACLType acl, BitSet bitset) {
        if (bitset == null) {
            return false;
        }
        return (bitset.get(acl.ordinal()) || bitset.get(IAccessAuthorizer.ACLType.ALL.ordinal())) && !bitset.get(IAccessAuthorizer.ACLType.NONE.ordinal());
    }

    public static boolean inheritDefaultAcls(List<OzoneAcl> acls, List<OzoneAcl> parentAcls) {
        List inheritedAcls = null;
        if (parentAcls != null && !parentAcls.isEmpty()) {
            inheritedAcls = parentAcls.stream().filter(a -> a.getAclScope() == OzoneAcl.AclScope.DEFAULT).map(acl -> new OzoneAcl(acl.getType(), acl.getName(), acl.getAclBitSet(), OzoneAcl.AclScope.ACCESS)).collect(Collectors.toList());
        }
        if (inheritedAcls != null && !inheritedAcls.isEmpty()) {
            inheritedAcls.stream().forEach(acl -> OzoneAclUtil.addAcl(acls, acl));
            return true;
        }
        return false;
    }

    public static List<OzoneAcl> fromProtobuf(List<OzoneManagerProtocolProtos.OzoneAclInfo> protoAcls) {
        ArrayList<OzoneAcl> ozoneAcls = new ArrayList<OzoneAcl>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo aclInfo : protoAcls) {
            ozoneAcls.add(OzoneAcl.fromProtobuf(aclInfo));
        }
        return ozoneAcls;
    }

    public static List<OzoneManagerProtocolProtos.OzoneAclInfo> toProtobuf(List<OzoneAcl> protoAcls) {
        ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo> ozoneAclInfos = new ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        for (OzoneAcl acl : protoAcls) {
            ozoneAclInfos.add(OzoneAcl.toProtobuf(acl));
        }
        return ozoneAclInfos;
    }

    public static boolean addAcl(List<OzoneAcl> existingAcls, OzoneAcl acl) {
        if (existingAcls == null || acl == null) {
            return false;
        }
        for (OzoneAcl a : existingAcls) {
            if (!a.getName().equals(acl.getName()) || !a.getType().equals((Object)acl.getType()) || !a.getAclScope().equals((Object)acl.getAclScope())) continue;
            BitSet current = a.getAclBitSet();
            BitSet original = (BitSet)current.clone();
            current.or(acl.getAclBitSet());
            return !current.equals(original);
        }
        existingAcls.add(acl);
        return true;
    }

    public static boolean removeAcl(List<OzoneAcl> existingAcls, OzoneAcl acl) {
        if (existingAcls == null || existingAcls.isEmpty() || acl == null) {
            return false;
        }
        for (OzoneAcl a : existingAcls) {
            if (!a.getName().equals(acl.getName()) || !a.getType().equals((Object)acl.getType()) || !a.getAclScope().equals((Object)acl.getAclScope())) continue;
            BitSet current = a.getAclBitSet();
            BitSet original = (BitSet)current.clone();
            current.andNot(acl.getAclBitSet());
            if (current.equals(original)) {
                return false;
            }
            if (current.isEmpty()) {
                existingAcls.remove(a);
            }
            return true;
        }
        return false;
    }

    public static boolean setAcl(List<OzoneAcl> existingAcls, List<OzoneAcl> newAcls) {
        if (existingAcls == null) {
            return false;
        }
        existingAcls.clear();
        if (newAcls != null) {
            existingAcls.addAll(newAcls);
        }
        return true;
    }
}

