/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmMultipartKeyInfo
extends WithObjectID {
    private final String uploadID;
    private final long creationTime;
    private final HddsProtos.ReplicationType replicationType;
    private final HddsProtos.ReplicationFactor replicationFactor;
    private TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoList;

    public OmMultipartKeyInfo(String id, long creationTime, HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor replicationFactor, Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list, long objectID, long updateID) {
        this.uploadID = id;
        this.creationTime = creationTime;
        this.replicationType = replicationType;
        this.replicationFactor = replicationFactor;
        this.partKeyInfoList = new TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>(list);
        this.objectID = objectID;
        this.updateID = updateID;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> getPartKeyInfoMap() {
        return this.partKeyInfoList;
    }

    public void addPartKeyInfo(int partNumber, OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
        this.partKeyInfoList.put(partNumber, partKeyInfo);
    }

    public OzoneManagerProtocolProtos.PartKeyInfo getPartKeyInfo(int partNumber) {
        return this.partKeyInfoList.get(partNumber);
    }

    public HddsProtos.ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public static OmMultipartKeyInfo getFromProto(OzoneManagerProtocolProtos.MultipartKeyInfo multipartKeyInfo) {
        HashMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list = new HashMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>();
        multipartKeyInfo.getPartKeyInfoListList().forEach(partKeyInfo -> list.put(partKeyInfo.getPartNumber(), (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfo));
        return new OmMultipartKeyInfo(multipartKeyInfo.getUploadID(), multipartKeyInfo.getCreationTime(), multipartKeyInfo.getType(), multipartKeyInfo.getFactor(), list, multipartKeyInfo.getObjectID(), multipartKeyInfo.getUpdateID());
    }

    public OzoneManagerProtocolProtos.MultipartKeyInfo getProto() {
        OzoneManagerProtocolProtos.MultipartKeyInfo.Builder builder = OzoneManagerProtocolProtos.MultipartKeyInfo.newBuilder().setUploadID(this.uploadID).setCreationTime(this.creationTime).setType(this.replicationType).setFactor(this.replicationFactor).setObjectID(this.objectID).setUpdateID(this.updateID);
        this.partKeyInfoList.forEach((key, value) -> builder.addPartKeyInfoList(value));
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return this.getProto().toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OmMultipartKeyInfo && this.uploadID.equals(((OmMultipartKeyInfo)other).getUploadID());
    }

    public int hashCode() {
        return this.uploadID.hashCode();
    }

    public OmMultipartKeyInfo copyObject() {
        return new OmMultipartKeyInfo(this.uploadID, this.creationTime, this.replicationType, this.replicationFactor, new TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>((SortedMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>)this.partKeyInfoList), this.objectID, this.updateID);
    }

    public static class Builder {
        private String uploadID;
        private long creationTime;
        private HddsProtos.ReplicationType replicationType;
        private HddsProtos.ReplicationFactor replicationFactor;
        private TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoList = new TreeMap();
        private long objectID;
        private long updateID;

        public Builder setUploadID(String uploadId) {
            this.uploadID = uploadId;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setReplicationType(HddsProtos.ReplicationType replType) {
            this.replicationType = replType;
            return this;
        }

        public Builder setReplicationFactor(HddsProtos.ReplicationFactor replFactor) {
            this.replicationFactor = replFactor;
            return this;
        }

        public Builder setPartKeyInfoList(Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfos) {
            if (partKeyInfos != null) {
                this.partKeyInfoList.putAll(partKeyInfos);
            }
            return this;
        }

        public Builder addPartKeyInfoList(int partNum, OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
            if (partKeyInfo != null) {
                this.partKeyInfoList.put(partNum, partKeyInfo);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public OmMultipartKeyInfo build() {
            return new OmMultipartKeyInfo(this.uploadID, this.creationTime, this.replicationType, this.replicationFactor, this.partKeyInfoList, this.objectID, this.updateID);
        }
    }
}

