/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.examples.pi.Combinable;
import org.apache.hadoop.examples.pi.Container;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.ArithmeticProgression;
import org.apache.hadoop.examples.pi.math.Modular;
import org.apache.hadoop.examples.pi.math.Montgomery;

public class Summation
implements Container<Summation>,
Combinable<Summation> {
    public final ArithmeticProgression N;
    public final ArithmeticProgression E;
    private Double value = null;
    private static final long MAX_MODULAR = 0x100000000L;
    final Montgomery montgomery = new Montgomery();

    public Summation(ArithmeticProgression N, ArithmeticProgression E) {
        if (N.getSteps() != E.getSteps()) {
            throw new IllegalArgumentException("N.getSteps() != E.getSteps(),\n  N.getSteps()=" + N.getSteps() + ", N=" + N + "\n  E.getSteps()=" + E.getSteps() + ", E=" + E);
        }
        this.N = N;
        this.E = E;
    }

    Summation(long valueN, long deltaN, long valueE, long deltaE, long limitE) {
        this(valueN, deltaN, valueN - deltaN * ((valueE - limitE) / deltaE), valueE, deltaE, limitE);
    }

    Summation(long valueN, long deltaN, long limitN, long valueE, long deltaE, long limitE) {
        this(new ArithmeticProgression('n', valueN, deltaN, limitN), new ArithmeticProgression('e', valueE, deltaE, limitE));
    }

    @Override
    public Summation getElement() {
        return this;
    }

    long getSteps() {
        return this.E.getSteps();
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }

    public String toString() {
        return "[" + this.N + "; " + this.E + (this.value == null ? "]" : "]value=" + Double.doubleToLongBits(this.value));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof Summation) {
            Summation that = (Summation)obj;
            return this.N.equals(that.N) && this.E.equals(that.E);
        }
        throw new IllegalArgumentException(obj == null ? "obj == null" : "obj.getClass()=" + obj.getClass());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public static Summation valueOf(String s) {
        int i = 1;
        int j = s.indexOf("; ", i);
        if (j < 0) {
            throw new IllegalArgumentException("i=" + i + ", j=" + j + " < 0, s=" + s);
        }
        ArithmeticProgression N = ArithmeticProgression.valueOf(s.substring(i, j));
        i = j + 2;
        if ((j = s.indexOf("]", i)) < 0) {
            throw new IllegalArgumentException("i=" + i + ", j=" + j + " < 0, s=" + s);
        }
        ArithmeticProgression E = ArithmeticProgression.valueOf(s.substring(i, j));
        Summation sigma = new Summation(N, E);
        i = j + 1;
        if (s.length() > i) {
            String value = Util.parseStringVariable("value", s.substring(i));
            sigma.setValue(value.indexOf(46) < 0 ? Double.longBitsToDouble(Long.parseLong(value)) : Double.parseDouble(value));
        }
        return sigma;
    }

    public double compute() {
        if (this.value == null) {
            this.value = this.N.limit <= 0x100000000L ? this.compute_modular() : this.compute_montgomery();
        }
        return this.value;
    }

    double compute_modular() {
        long n = this.N.value;
        double s = 0.0;
        for (long e = this.E.value; e > this.E.limit; e += this.E.delta) {
            s = Modular.addMod(s, (double)Modular.mod(e, n) / (double)n);
            n += this.N.delta;
        }
        return s;
    }

    double compute_montgomery() {
        long n = this.N.value;
        double s = 0.0;
        for (long e = this.E.value; e > this.E.limit; e += this.E.delta) {
            s = Modular.addMod(s, (double)this.montgomery.set(n).mod(e) / (double)n);
            n += this.N.delta;
        }
        return s;
    }

    @Override
    public int compareTo(Summation that) {
        int de = this.E.compareTo(that.E);
        if (de != 0) {
            return de;
        }
        return this.N.compareTo(that.N);
    }

    @Override
    public Summation combine(Summation that) {
        if (this.N.delta != that.N.delta || this.E.delta != that.E.delta) {
            throw new IllegalArgumentException("this.N.delta != that.N.delta || this.E.delta != that.E.delta,\n  this=" + this + ",\n  that=" + that);
        }
        if (this.E.limit == that.E.value && this.N.limit == that.N.value) {
            double v = Modular.addMod(this.value, that.value);
            Summation s = new Summation(new ArithmeticProgression(this.N.symbol, this.N.value, this.N.delta, that.N.limit), new ArithmeticProgression(this.E.symbol, this.E.value, this.E.delta, that.E.limit));
            s.setValue(v);
            return s;
        }
        return null;
    }

    public <T extends Container<Summation>> List<Summation> remainingTerms(List<T> sorted) {
        ArrayList<Summation> results = new ArrayList<Summation>();
        Summation remaining = this;
        if (sorted != null) {
            for (Container c : sorted) {
                Summation sigma = (Summation)c.getElement();
                if (!remaining.contains(sigma)) {
                    throw new IllegalArgumentException("!remaining.contains(s),\n  remaining = " + remaining + "\n  s         = " + sigma + "\n  this      = " + this + "\n  sorted    = " + sorted);
                }
                Summation s = new Summation(sigma.N.limit, this.N.delta, remaining.N.limit, sigma.E.limit, this.E.delta, remaining.E.limit);
                if (s.getSteps() > 0L) {
                    results.add(s);
                }
                remaining = new Summation(remaining.N.value, this.N.delta, sigma.N.value, remaining.E.value, this.E.delta, sigma.E.value);
            }
        }
        if (remaining.getSteps() > 0L) {
            results.add(remaining);
        }
        return results;
    }

    public boolean contains(Summation that) {
        return this.N.contains(that.N) && this.E.contains(that.E);
    }

    public Summation[] partition(int nParts) {
        Summation[] parts = new Summation[nParts];
        long steps = (this.E.limit - this.E.value) / this.E.delta + 1L;
        long prevN = this.N.value;
        long prevE = this.E.value;
        for (int i = 1; i < parts.length; ++i) {
            long k = (long)i * steps / (long)parts.length;
            long currN = this.N.skip(k);
            long currE = this.E.skip(k);
            parts[i - 1] = new Summation(new ArithmeticProgression(this.N.symbol, prevN, this.N.delta, currN), new ArithmeticProgression(this.E.symbol, prevE, this.E.delta, currE));
            prevN = currN;
            prevE = currE;
        }
        parts[parts.length - 1] = new Summation(new ArithmeticProgression(this.N.symbol, prevN, this.N.delta, this.N.limit), new ArithmeticProgression(this.E.symbol, prevE, this.E.delta, this.E.limit));
        return parts;
    }
}

