/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.math.BigInteger;

class LongLong {
    static final int BITS_PER_LONG = 62;
    static final int MID = 31;
    static final int SIZE = 124;
    static final long FULL_MASK = 0x3FFFFFFFFFFFFFFFL;
    static final long LOWER_MASK = Integer.MAX_VALUE;
    static final long UPPER_MASK = 4611686016279904256L;
    private long d0;
    private long d1;

    LongLong() {
    }

    LongLong set(long d0, long d1) {
        this.d0 = d0;
        this.d1 = d1;
        return this;
    }

    long and(long mask) {
        return this.d0 & mask;
    }

    long shiftRight(int n) {
        return (this.d1 << 62 - n) + (this.d0 >>> n);
    }

    LongLong plusEqual(LongLong that) {
        this.d0 += that.d0;
        this.d1 += that.d1;
        return this;
    }

    BigInteger toBigInteger() {
        return BigInteger.valueOf(this.d1).shiftLeft(62).add(BigInteger.valueOf(this.d0));
    }

    public String toString() {
        int remainder = 2;
        return String.format("%x*2^%d + %016x", this.d1 << 2, 60, this.d0);
    }

    static LongLong multiplication(LongLong r, long a, long b) {
        long a_lower = a & Integer.MAX_VALUE;
        long a_upper = (a & 0x3FFFFFFF80000000L) >> 31;
        long b_lower = b & Integer.MAX_VALUE;
        long b_upper = (b & 0x3FFFFFFF80000000L) >> 31;
        long tmp = a_lower * b_upper + a_upper * b_lower;
        r.d0 = a_lower * b_lower + (tmp << 31 & 0x3FFFFFFFFFFFFFFFL);
        r.d1 = a_upper * b_upper + (tmp >> 31);
        return r;
    }
}

