/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.EntityWriterV2;
import org.apache.hadoop.mapreduce.JobHistoryFileParser;
import org.apache.hadoop.mapreduce.JobHistoryFileReplayHelper;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TimelineEntityConverterV2;
import org.apache.hadoop.mapreduce.TimelineServicePerformance;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorManager;

class JobHistoryFileReplayMapperV2
extends EntityWriterV2 {
    private static final Log LOG = LogFactory.getLog(JobHistoryFileReplayMapperV2.class);

    JobHistoryFileReplayMapperV2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeEntities(Configuration tlConf, TimelineCollectorManager manager, Mapper.Context context) throws IOException {
        JobHistoryFileReplayHelper helper = new JobHistoryFileReplayHelper(context);
        int replayMode = helper.getReplayMode();
        JobHistoryFileParser parser = helper.getParser();
        TimelineEntityConverterV2 converter = new TimelineEntityConverterV2();
        Collection<JobHistoryFileReplayHelper.JobFiles> jobs = helper.getJobFiles();
        if (jobs.isEmpty()) {
            LOG.info((Object)(context.getTaskAttemptID().getTaskID() + " will process no jobs"));
        } else {
            LOG.info((Object)(context.getTaskAttemptID().getTaskID() + " will process " + jobs.size() + " jobs"));
        }
        for (JobHistoryFileReplayHelper.JobFiles job : jobs) {
            String jobIdStr = job.getJobId();
            if (job.getJobConfFilePath() == null || job.getJobHistoryFilePath() == null) {
                LOG.info((Object)(jobIdStr + " missing either the job history file or the configuration file. Skipping."));
                continue;
            }
            LOG.info((Object)("processing " + jobIdStr + "..."));
            JobId jobId = TypeConverter.toYarn((org.apache.hadoop.mapreduce.JobID)JobID.forName((String)jobIdStr));
            ApplicationId appId = jobId.getAppId();
            AppLevelTimelineCollector collector = new AppLevelTimelineCollector(appId);
            manager.putIfAbsent(appId, (TimelineCollector)collector);
            try {
                JobHistoryParser.JobInfo jobInfo = parser.parseHistoryFile(job.getJobHistoryFilePath());
                Configuration jobConf = parser.parseConfiguration(job.getJobConfFilePath());
                LOG.info((Object)("parsed the job history file and the configuration file for job " + jobIdStr));
                TimelineCollectorContext tlContext = collector.getTimelineEntityContext();
                tlContext.setFlowName(jobInfo.getJobname());
                tlContext.setFlowRunId(jobInfo.getSubmitTime());
                tlContext.setUserId(jobInfo.getUsername());
                long totalTime = 0L;
                List<TimelineEntity> entitySet = converter.createTimelineEntities(jobInfo, jobConf);
                LOG.info((Object)("converted them into timeline entities for job " + jobIdStr));
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                long startWrite = System.nanoTime();
                try {
                    switch (replayMode) {
                        case 1: {
                            this.writeAllEntities(collector, entitySet, ugi);
                            break;
                        }
                        case 2: {
                            this.writePerEntity(collector, entitySet, ugi);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_FAILURES).increment(1L);
                    LOG.error((Object)"writing to the timeline service failed", (Throwable)e);
                }
                long endWrite = System.nanoTime();
                int numEntities = entitySet.size();
                LOG.info((Object)("wrote " + numEntities + " entities in " + (totalTime += TimeUnit.NANOSECONDS.toMillis(endWrite - startWrite)) + " ms"));
                context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_TIME).increment(totalTime);
                context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).increment((long)numEntities);
            }
            finally {
                manager.remove(appId);
                context.progress();
            }
        }
    }

    private void writeAllEntities(AppLevelTimelineCollector collector, List<TimelineEntity> entitySet, UserGroupInformation ugi) throws IOException {
        TimelineEntities entities = new TimelineEntities();
        entities.setEntities(entitySet);
        collector.putEntities(entities, ugi);
    }

    private void writePerEntity(AppLevelTimelineCollector collector, List<TimelineEntity> entitySet, UserGroupInformation ugi) throws IOException {
        for (TimelineEntity entity : entitySet) {
            TimelineEntities entities = new TimelineEntities();
            entities.addEntity(entity);
            collector.putEntities(entities, ugi);
            LOG.info((Object)("wrote entity " + entity.getId()));
        }
    }
}

