/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TimelineServicePerformance;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;

class SimpleEntityWriterV1
extends Mapper<IntWritable, IntWritable, Writable, Writable> {
    private static final Log LOG = LogFactory.getLog(SimpleEntityWriterV1.class);
    static final String KBS_SENT = "kbs sent";
    static final int KBS_SENT_DEFAULT = 1;
    static final String TEST_TIMES = "testtimes";
    static final int TEST_TIMES_DEFAULT = 100;
    static final String TIMELINE_SERVICE_PERFORMANCE_RUN_ID = "timeline.server.performance.run.id";
    private static char[] ALPHA_NUMS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', ' '};

    SimpleEntityWriterV1() {
    }

    public void map(IntWritable key, IntWritable val, Mapper.Context context) throws IOException {
        TimelineClientImpl tlc = new TimelineClientImpl();
        Configuration conf = context.getConfiguration();
        int kbs = conf.getInt(KBS_SENT, 1);
        long totalTime = 0L;
        int testtimes = conf.getInt(TEST_TIMES, 100);
        Random rand = new Random();
        TaskAttemptID taskAttemptId = context.getTaskAttemptID();
        char[] payLoad = new char[kbs * 1024];
        for (int i = 0; i < testtimes; ++i) {
            for (int xx = 0; xx < kbs * 1024; ++xx) {
                int alphaNumIdx = rand.nextInt(ALPHA_NUMS.length);
                payLoad[xx] = ALPHA_NUMS[alphaNumIdx];
            }
            String entId = taskAttemptId + "_" + Integer.toString(i);
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId(entId);
            entity.setEntityType("FOO_ATTEMPT");
            entity.addOtherInfo("PERF_TEST", (Object)payLoad);
            TimelineEvent event = new TimelineEvent();
            event.setTimestamp(System.currentTimeMillis());
            event.setEventType("foo_event");
            entity.addEvent(event);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            long startWrite = System.nanoTime();
            try {
                tlc.putEntities(new TimelineEntity[]{entity});
            }
            catch (Exception e) {
                context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_FAILURES).increment(1L);
                LOG.error((Object)"writing to the timeline service failed", (Throwable)e);
            }
            long endWrite = System.nanoTime();
            totalTime += TimeUnit.NANOSECONDS.toMillis(endWrite - startWrite);
        }
        LOG.info((Object)("wrote " + testtimes + " entities (" + kbs * testtimes + " kB) in " + totalTime + " ms"));
        context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_TIME).increment(totalTime);
        context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).increment((long)testtimes);
        context.getCounter((Enum)TimelineServicePerformance.PerfCounters.TIMELINE_SERVICE_WRITE_KBS).increment((long)(kbs * testtimes));
    }
}

