/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.security.TestJHSSecurity;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestJHSSecurity {
    private static final Log LOG = LogFactory.getLog(TestJHSSecurity.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationToken() throws IOException, InterruptedException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
        conf.set("mapreduce.jobhistory.principal", "RandomOrc/localhost@apache.org");
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        long initialInterval = 10000L;
        long maxLifetime = 20000L;
        long renewInterval = 10000L;
        1 jobHistoryServer = null;
        MRClientProtocol clientUsingDT = null;
        try {
            jobHistoryServer = new /* Unavailable Anonymous Inner Class!! */;
            jobHistoryServer.init((Configuration)conf);
            jobHistoryServer.start();
            MRClientProtocol hsService = jobHistoryServer.getClientService().getClientHandler();
            UserGroupInformation loggedInUser = UserGroupInformation.createRemoteUser((String)"testrenewer@APACHE.ORG");
            Assert.assertEquals((Object)"testrenewer", (Object)loggedInUser.getShortUserName());
            loggedInUser.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
            Token token = this.getDelegationToken(loggedInUser, hsService, loggedInUser.getShortUserName());
            long tokenFetchTime = System.currentTimeMillis();
            LOG.info((Object)("Got delegation token at: " + tokenFetchTime));
            clientUsingDT = this.getMRClientProtocol(token, jobHistoryServer.getClientService().getBindAddress(), "TheDarkLord", (Configuration)conf);
            GetJobReportRequest jobReportRequest = (GetJobReportRequest)Records.newRecord(GetJobReportRequest.class);
            jobReportRequest.setJobId(MRBuilderUtils.newJobId((long)123456L, (int)1, (int)1));
            try {
                clientUsingDT.getJobReport(jobReportRequest);
            }
            catch (IOException e) {
                Assert.assertEquals((Object)"Unknown job job_123456_0001", (Object)e.getMessage());
            }
            while (System.currentTimeMillis() < tokenFetchTime + 5000L) {
                Thread.sleep(500L);
            }
            long nextExpTime = this.renewDelegationToken(loggedInUser, hsService, token);
            long renewalTime = System.currentTimeMillis();
            LOG.info((Object)("Renewed token at: " + renewalTime + ", NextExpiryTime: " + nextExpTime));
            while (System.currentTimeMillis() > tokenFetchTime + 10000L && System.currentTimeMillis() < nextExpTime) {
                Thread.sleep(500L);
            }
            Thread.sleep(50L);
            try {
                clientUsingDT.getJobReport(jobReportRequest);
            }
            catch (IOException e) {
                Assert.assertEquals((Object)"Unknown job job_123456_0001", (Object)e.getMessage());
            }
            while (System.currentTimeMillis() < renewalTime + 10000L) {
                Thread.sleep(500L);
            }
            Thread.sleep(50L);
            LOG.info((Object)("At time: " + System.currentTimeMillis() + ", token should be invalid"));
            try {
                clientUsingDT.getJobReport(jobReportRequest);
                Assert.fail((String)"Should not have succeeded with an expired token");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("is expired"));
            }
            if (clientUsingDT != null) {
                clientUsingDT = null;
            }
            token = this.getDelegationToken(loggedInUser, hsService, loggedInUser.getShortUserName());
            tokenFetchTime = System.currentTimeMillis();
            LOG.info((Object)("Got delegation token at: " + tokenFetchTime));
            clientUsingDT = this.getMRClientProtocol(token, jobHistoryServer.getClientService().getBindAddress(), "loginuser2", (Configuration)conf);
            try {
                clientUsingDT.getJobReport(jobReportRequest);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception" + e));
            }
            this.cancelDelegationToken(loggedInUser, hsService, token);
            Token tokenWithDifferentRenewer = this.getDelegationToken(loggedInUser, hsService, "yarn");
            this.cancelDelegationToken(loggedInUser, hsService, tokenWithDifferentRenewer);
            if (clientUsingDT != null) {
                clientUsingDT = null;
            }
            clientUsingDT = this.getMRClientProtocol(token, jobHistoryServer.getClientService().getBindAddress(), "loginuser2", (Configuration)conf);
            LOG.info((Object)("Cancelled delegation token at: " + System.currentTimeMillis()));
            try {
                clientUsingDT.getJobReport(jobReportRequest);
                Assert.fail((String)"Should not have succeeded with a cancelled delegation token");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            jobHistoryServer.stop();
        }
    }

    private Token getDelegationToken(UserGroupInformation loggedInUser, MRClientProtocol hsService, String renewerString) throws IOException, InterruptedException {
        Token token = (Token)loggedInUser.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        return token;
    }

    private long renewDelegationToken(UserGroupInformation loggedInUser, MRClientProtocol hsService, Token dToken) throws IOException, InterruptedException {
        long nextExpTime = (Long)loggedInUser.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        return nextExpTime;
    }

    private void cancelDelegationToken(UserGroupInformation loggedInUser, MRClientProtocol hsService, Token dToken) throws IOException, InterruptedException {
        loggedInUser.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private MRClientProtocol getMRClientProtocol(Token token, InetSocketAddress hsAddress, String user, Configuration conf) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        ugi.addToken(ConverterUtils.convertFromYarn((Token)token, (InetSocketAddress)hsAddress));
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        MRClientProtocol hsWithDT = (MRClientProtocol)ugi.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
        return hsWithDT;
    }
}

