/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TestChild;
import org.apache.log4j.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestChild
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";

    public TestChild() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(JobConf conf, int numMaps, int numReds, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        conf.setBoolean("test.old.configs", oldConfigs);
        if (oldConfigs) {
            conf.set("mapred.child.java.opts", "-Xmx200m");
        } else {
            conf.set("mapreduce.map.java.opts", "-Xmx200m");
            conf.set("mapreduce.reduce.java.opts", "-Xmx300m");
        }
        conf.set("mapreduce.map.log.level", Level.OFF.toString());
        conf.set("mapreduce.reduce.log.level", Level.OFF.toString());
        Job job = MapReduceTestUtil.createJob((Configuration)conf, (Path)this.inDir, (Path)this.outDir, (int)numMaps, (int)numReds);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        TestChild.assertFalse((String)"Job already has a job tracker connection, before it's submitted", (boolean)job.isConnected());
        job.submit();
        TestChild.assertTrue((String)"Job doesn't have a job tracker connection, even though it's been submitted", (boolean)job.isConnected());
        job.waitForCompletion(true);
        TestChild.assertTrue((boolean)job.isSuccessful());
        FileSystem fs = FileSystem.get((Configuration)conf);
        TestChild.assertTrue((String)"Job output directory doesn't exit!", (boolean)fs.exists(this.outDir));
        FileStatus[] list = fs.listStatus(this.outDir, (PathFilter)new OutputFilter(null));
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        TestChild.assertTrue((String)("Number of part-files is " + list.length + " and not " + numPartFiles), (list.length == numPartFiles ? 1 : 0) != 0);
        return job;
    }

    public void testChild() throws Exception {
        try {
            this.submitAndValidateJob(this.createJobConf(), 1, 1, true);
            this.submitAndValidateJob(this.createJobConf(), 1, 1, false);
        }
        finally {
            this.tearDown();
        }
    }
}

