/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.fs.slive.ArgumentParser;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.util.StringUtils;

class ArgumentParser {
    private Options optList = this.getOptions();
    private String[] argumentList;
    private ParsedOutput parsed;

    ArgumentParser(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        this.argumentList = args;
        this.parsed = null;
    }

    private Options getOptionList() {
        return this.optList;
    }

    ParsedOutput parse() throws Exception {
        if (this.parsed == null) {
            PosixParser parser = new PosixParser();
            CommandLine popts = parser.parse(this.getOptionList(), this.argumentList, true);
            this.parsed = popts.hasOption(ConfigOption.HELP.getOpt()) ? new ParsedOutput(null, this, true) : new ParsedOutput(popts, this, false);
        }
        return this.parsed;
    }

    private Options getOptions() {
        Options cliopt = new Options();
        cliopt.addOption((Option)ConfigOption.MAPS);
        cliopt.addOption((Option)ConfigOption.REDUCES);
        cliopt.addOption((Option)ConfigOption.PACKET_SIZE);
        cliopt.addOption((Option)ConfigOption.OPS);
        cliopt.addOption((Option)ConfigOption.DURATION);
        cliopt.addOption((Option)ConfigOption.EXIT_ON_ERROR);
        cliopt.addOption((Option)ConfigOption.SLEEP_TIME);
        cliopt.addOption((Option)ConfigOption.TRUNCATE_WAIT);
        cliopt.addOption((Option)ConfigOption.FILES);
        cliopt.addOption((Option)ConfigOption.DIR_SIZE);
        cliopt.addOption((Option)ConfigOption.BASE_DIR);
        cliopt.addOption((Option)ConfigOption.RESULT_FILE);
        cliopt.addOption(ConfigOption.CLEANUP);
        String[] distStrs = new String[Constants.Distribution.values().length];
        Constants.Distribution[] distValues = Constants.Distribution.values();
        for (int i = 0; i < distValues.length; ++i) {
            distStrs[i] = distValues[i].lowerName();
        }
        String opdesc = String.format("pct,distribution where distribution is one of %s", StringUtils.arrayToString((String[])distStrs));
        for (Constants.OperationType type : Constants.OperationType.values()) {
            String opname = type.lowerName();
            cliopt.addOption(new Option(opname, true, opdesc));
        }
        cliopt.addOption((Option)ConfigOption.REPLICATION_AM);
        cliopt.addOption((Option)ConfigOption.BLOCK_SIZE);
        cliopt.addOption((Option)ConfigOption.READ_SIZE);
        cliopt.addOption((Option)ConfigOption.WRITE_SIZE);
        cliopt.addOption((Option)ConfigOption.APPEND_SIZE);
        cliopt.addOption((Option)ConfigOption.TRUNCATE_SIZE);
        cliopt.addOption((Option)ConfigOption.RANDOM_SEED);
        cliopt.addOption((Option)ConfigOption.QUEUE_NAME);
        cliopt.addOption(ConfigOption.HELP);
        return cliopt;
    }

    static /* synthetic */ Options access$000(ArgumentParser x0) {
        return x0.getOptionList();
    }
}

