/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TestClientRedirect;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.CounterGroup;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestClientRedirect {
    private static final Log LOG;
    private static final String RMADDRESS = "0.0.0.0:8054";
    private static final RecordFactory recordFactory;
    private static final String AMHOSTADDRESS = "0.0.0.0:10020";
    private static final String HSHOSTADDRESS = "0.0.0.0:10021";
    private volatile boolean amContact = false;
    private volatile boolean hsContact = false;
    private volatile boolean amRunning = false;
    private volatile boolean amRestarting = false;

    @Test
    public void testRedirect() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.set("yarn.resourcemanager.address", RMADDRESS);
        conf.set("mapreduce.jobhistory.address", HSHOSTADDRESS);
        RMService rmService = new RMService(this, "test");
        rmService.init((Configuration)conf);
        rmService.start();
        AMService amService = new AMService(this);
        amService.init((Configuration)conf);
        amService.start((Configuration)conf);
        HistoryService historyService = new HistoryService(this);
        historyService.init((Configuration)conf);
        historyService.start((Configuration)conf);
        LOG.info((Object)"services started");
        Cluster cluster = new Cluster((Configuration)conf);
        JobID jobID = new JobID("201103121733", 1);
        Counters counters = cluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.amContact);
        LOG.info((Object)"Sleeping for 5 seconds before stop for the client socket to not get EOF immediately..");
        Thread.sleep(5000L);
        amService.stop();
        LOG.info((Object)"Sleeping for 5 seconds after stop for the server to exit cleanly..");
        Thread.sleep(5000L);
        this.amRestarting = true;
        counters = cluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID).getCounters();
        Assert.assertEquals((long)0L, (long)counters.countCounters());
        Job job = cluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobID, TaskType.MAP, 0);
        TaskAttemptID tId = new TaskAttemptID(taskId, 0);
        job.killJob();
        job.killTask(tId);
        job.failTask(tId);
        job.getTaskCompletionEvents(0, 100);
        job.getStatus();
        job.getTaskDiagnostics(tId);
        job.getTaskReports(TaskType.MAP);
        job.getTrackingURL();
        this.amRestarting = false;
        amService = new AMService(this);
        amService.init((Configuration)conf);
        amService.start((Configuration)conf);
        this.amContact = false;
        counters = cluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.amContact);
        amService.stop();
        counters = cluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.hsContact);
        rmService.stop();
        historyService.stop();
    }

    private void validateCounters(Counters counters) {
        for (org.apache.hadoop.mapreduce.CounterGroup group : counters) {
            LOG.info((Object)("Group " + group.getDisplayName()));
            Iterator itc = group.iterator();
            while (itc.hasNext()) {
                LOG.info((Object)("Counter is " + ((Counter)itc.next()).getDisplayName()));
            }
        }
        Assert.assertEquals((long)1L, (long)counters.countCounters());
    }

    static org.apache.hadoop.mapreduce.v2.api.records.Counters getMyCounters() {
        org.apache.hadoop.mapreduce.v2.api.records.Counter counter = (org.apache.hadoop.mapreduce.v2.api.records.Counter)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counter.class);
        counter.setName("Mycounter");
        counter.setDisplayName("My counter display name");
        counter.setValue(12345L);
        CounterGroup group = (CounterGroup)recordFactory.newRecordInstance(CounterGroup.class);
        group.setName("MyGroup");
        group.setDisplayName("My groupd display name");
        group.setCounter("myCounter", counter);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = (org.apache.hadoop.mapreduce.v2.api.records.Counters)recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counters.class);
        counters.setCounterGroup("myGroupd", group);
        return counters;
    }

    static /* synthetic */ RecordFactory access$000() {
        return recordFactory;
    }

    static /* synthetic */ boolean access$100(TestClientRedirect x0) {
        return x0.amRunning;
    }

    static /* synthetic */ boolean access$200(TestClientRedirect x0) {
        return x0.amRestarting;
    }

    static /* synthetic */ boolean access$302(TestClientRedirect x0, boolean x1) {
        x0.hsContact = x1;
        return x0.hsContact;
    }

    static /* synthetic */ boolean access$102(TestClientRedirect x0, boolean x1) {
        x0.amRunning = x1;
        return x0.amRunning;
    }

    static /* synthetic */ boolean access$402(TestClientRedirect x0, boolean x1) {
        x0.amContact = x1;
        return x0.amContact;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        LOG = LogFactory.getLog(TestClientRedirect.class);
        recordFactory = RecordFactoryProvider.getRecordFactory(null);
    }
}

