/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClientCache;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.YARNRunner;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestYARNRunner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestYARNRunner.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private YARNRunner yarnRunner;
    private ResourceMgrDelegate resourceMgrDelegate;
    private YarnConfiguration conf;
    private ClientCache clientCache;
    private ApplicationId appId;
    private JobID jobId;
    private File testWorkDir = new File("target", TestYARNRunner.class.getName());
    private ApplicationSubmissionContext submissionContext;
    private ClientServiceDelegate clientDelegate;
    private static final String failString = "Rejected job";

    @Before
    public void setUp() throws Exception {
        this.resourceMgrDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        this.conf = new YarnConfiguration();
        this.clientCache = new ClientCache((Configuration)this.conf, this.resourceMgrDelegate);
        this.clientCache = (ClientCache)Mockito.spy((Object)this.clientCache);
        this.yarnRunner = new YARNRunner((Configuration)this.conf, this.resourceMgrDelegate, this.clientCache);
        this.yarnRunner = (YARNRunner)Mockito.spy((Object)this.yarnRunner);
        this.submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        ((YARNRunner)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)this.yarnRunner)).createApplicationSubmissionContext((Configuration)Matchers.any(Configuration.class), (String)Matchers.any(String.class), (Credentials)Matchers.any(Credentials.class));
        this.appId = (ApplicationId)recordFactory.newRecordInstance(ApplicationId.class);
        this.appId.setClusterTimestamp(System.currentTimeMillis());
        this.appId.setId(1);
        this.jobId = TypeConverter.fromYarn((ApplicationId)this.appId);
        if (this.testWorkDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(this.testWorkDir.toString()), true);
        }
        this.testWorkDir.mkdirs();
    }

    @Test
    public void testJobKill() throws Exception {
        this.clientDelegate = (ClientServiceDelegate)Mockito.mock(ClientServiceDelegate.class);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)Matchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.PREP, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        Mockito.when((Object)this.clientDelegate.killJob((JobID)Matchers.any(JobID.class))).thenReturn((Object)true);
        ((ClientCache)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)this.clientCache)).getClient((JobID)Matchers.any(JobID.class));
        this.yarnRunner.killJob(this.jobId);
        ((ResourceMgrDelegate)Mockito.verify((Object)this.resourceMgrDelegate)).killApplication(this.appId);
        Mockito.when((Object)this.clientDelegate.getJobStatus((JobID)Matchers.any(JobID.class))).thenReturn((Object)new JobStatus(this.jobId, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp", "tmp", "tmp", "tmp"));
        this.yarnRunner.killJob(this.jobId);
        ((ClientServiceDelegate)Mockito.verify((Object)this.clientDelegate)).killJob(this.jobId);
    }

    @Test
    public void testJobSubmissionFailure() throws Exception {
        Mockito.when((Object)this.resourceMgrDelegate.submitApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class))).thenReturn((Object)this.appId);
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getApplicationId()).thenReturn((Object)this.appId);
        Mockito.when((Object)report.getDiagnostics()).thenReturn((Object)"Rejected job");
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        Mockito.when((Object)this.resourceMgrDelegate.getApplicationReport(this.appId)).thenReturn((Object)report);
        Credentials credentials = new Credentials();
        File jobxml = new File(this.testWorkDir, "job.xml");
        FileOutputStream out = new FileOutputStream(jobxml);
        this.conf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        try {
            this.yarnRunner.submitJob(this.jobId, this.testWorkDir.getAbsolutePath().toString(), credentials);
        }
        catch (IOException io) {
            LOG.info((Object)"Logging exception:", (Throwable)io);
            TestYARNRunner.assertTrue((boolean)io.getLocalizedMessage().contains("Rejected job"));
        }
    }

    @Test
    public void testResourceMgrDelegate() throws Exception {
        ClientRMProtocol clientRMProtocol = (ClientRMProtocol)Mockito.mock(ClientRMProtocol.class);
        ResourceMgrDelegate delegate = new ResourceMgrDelegate(this.conf, clientRMProtocol);
        Mockito.when((Object)clientRMProtocol.forceKillApplication((KillApplicationRequest)Matchers.any(KillApplicationRequest.class))).thenReturn(null);
        delegate.killApplication(this.appId);
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).forceKillApplication((KillApplicationRequest)Matchers.any(KillApplicationRequest.class));
        Mockito.when((Object)clientRMProtocol.getAllApplications((GetAllApplicationsRequest)Matchers.any(GetAllApplicationsRequest.class))).thenReturn(recordFactory.newRecordInstance(GetAllApplicationsResponse.class));
        delegate.getAllJobs();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getAllApplications((GetAllApplicationsRequest)Matchers.any(GetAllApplicationsRequest.class));
        Mockito.when((Object)clientRMProtocol.getApplicationReport((GetApplicationReportRequest)Matchers.any(GetApplicationReportRequest.class))).thenReturn(recordFactory.newRecordInstance(GetApplicationReportResponse.class));
        delegate.getApplicationReport(this.appId);
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getApplicationReport((GetApplicationReportRequest)Matchers.any(GetApplicationReportRequest.class));
        GetClusterMetricsResponse clusterMetricsResponse = (GetClusterMetricsResponse)recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        clusterMetricsResponse.setClusterMetrics((YarnClusterMetrics)recordFactory.newRecordInstance(YarnClusterMetrics.class));
        Mockito.when((Object)clientRMProtocol.getClusterMetrics((GetClusterMetricsRequest)Matchers.any(GetClusterMetricsRequest.class))).thenReturn((Object)clusterMetricsResponse);
        delegate.getClusterMetrics();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterMetrics((GetClusterMetricsRequest)Matchers.any(GetClusterMetricsRequest.class));
        Mockito.when((Object)clientRMProtocol.getClusterNodes((GetClusterNodesRequest)Matchers.any(GetClusterNodesRequest.class))).thenReturn(recordFactory.newRecordInstance(GetClusterNodesResponse.class));
        delegate.getActiveTrackers();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getClusterNodes((GetClusterNodesRequest)Matchers.any(GetClusterNodesRequest.class));
        GetNewApplicationResponse newAppResponse = (GetNewApplicationResponse)recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        newAppResponse.setApplicationId(this.appId);
        Mockito.when((Object)clientRMProtocol.getNewApplication((GetNewApplicationRequest)Matchers.any(GetNewApplicationRequest.class))).thenReturn((Object)newAppResponse);
        delegate.getNewJobID();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getNewApplication((GetNewApplicationRequest)Matchers.any(GetNewApplicationRequest.class));
        GetQueueInfoResponse queueInfoResponse = (GetQueueInfoResponse)recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        queueInfoResponse.setQueueInfo((QueueInfo)recordFactory.newRecordInstance(QueueInfo.class));
        Mockito.when((Object)clientRMProtocol.getQueueInfo((GetQueueInfoRequest)Matchers.any(GetQueueInfoRequest.class))).thenReturn((Object)queueInfoResponse);
        delegate.getQueues();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueInfo((GetQueueInfoRequest)Matchers.any(GetQueueInfoRequest.class));
        GetQueueUserAclsInfoResponse aclResponse = (GetQueueUserAclsInfoResponse)recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        Mockito.when((Object)clientRMProtocol.getQueueUserAcls((GetQueueUserAclsInfoRequest)Matchers.any(GetQueueUserAclsInfoRequest.class))).thenReturn((Object)aclResponse);
        delegate.getQueueAclsForCurrentUser();
        ((ClientRMProtocol)Mockito.verify((Object)clientRMProtocol)).getQueueUserAcls((GetQueueUserAclsInfoRequest)Matchers.any(GetQueueUserAclsInfoRequest.class));
    }

    static /* synthetic */ ApplicationSubmissionContext access$000(TestYARNRunner x0) {
        return x0.submissionContext;
    }

    static /* synthetic */ ClientServiceDelegate access$100(TestYARNRunner x0) {
        return x0.clientDelegate;
    }
}

