/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.FailingMapper;
import org.apache.hadoop.RandomTextWriterJob;
import org.apache.hadoop.SleepJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRJobs {
    private static final Log LOG = LogFactory.getLog(TestMRJobs.class);
    protected static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    @BeforeClass
    public static void setup() throws IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(TestMRJobs.class.getName(), 3);
            Configuration conf = new Configuration();
            mrCluster.init(conf);
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
    }

    @Test
    public void testSleepJob() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testSleepJob().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrCluster.getConfig());
        sleepConf.set("mapreduce.jobtracker.address", "local");
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf(sleepConf);
        int numReduces = sleepConf.getInt("TestMRJobs.testSleepJob.reduces", 2);
        Job job = sleepJob.createJob(3, numReduces, 10000L, 1, 5000L, 1);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(SleepJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        this.verifySleepJobCounters(job);
        this.verifyTaskProgress(job);
    }

    protected void verifySleepJobCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_REDUCES).getValue());
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    protected void verifyTaskProgress(Job job) throws InterruptedException, IOException {
        for (TaskReport taskReport : job.getTaskReports(TaskType.MAP)) {
            Assert.assertTrue((0.9999f < taskReport.getProgress() && 1.0001f > taskReport.getProgress() ? 1 : 0) != 0);
        }
        for (TaskReport taskReport : job.getTaskReports(TaskType.REDUCE)) {
            Assert.assertTrue((0.9999f < taskReport.getProgress() && 1.0001f > taskReport.getProgress() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRandomWriter() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testRandomWriter().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        RandomTextWriterJob randomWriterJob = new RandomTextWriterJob();
        mrCluster.getConfig().set("mapreduce.randomtextwriter.totalbytes", "3072");
        mrCluster.getConfig().set("mapreduce.randomtextwriter.bytespermap", "1024");
        Job job = randomWriterJob.createJob(mrCluster.getConfig());
        Path outputDir = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "random-output");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(RandomTextWriterJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        RemoteIterator iterator = FileContext.getFileContext((Configuration)mrCluster.getConfig()).listStatus(outputDir);
        int count = 0;
        while (iterator.hasNext()) {
            FileStatus file = (FileStatus)iterator.next();
            if (file.getPath().getName().equals("_SUCCESS")) continue;
            ++count;
        }
        Assert.assertEquals((String)"Number of part files is wrong!", (long)3L, (long)count);
        this.verifyRandomWriterCounters(job);
    }

    protected void verifyRandomWriterCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    @Test
    public void testFailingMapper() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testFailingMapper().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Job job = this.runFailingMapperJob();
        TaskID taskID = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID aId = new TaskAttemptID(taskID, 0);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        aId = new TaskAttemptID(taskID, 1);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        TaskCompletionEvent[] events = job.getTaskCompletionEvents(0, 2);
        Assert.assertEquals((Object)TaskCompletionEvent.Status.FAILED, (Object)events[0].getStatus());
        Assert.assertEquals((Object)TaskCompletionEvent.Status.TIPFAILED, (Object)events[1].getStatus());
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)job.getJobState());
        this.verifyFailingMapperCounters(job);
    }

    protected void verifyFailingMapperCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_FAILED_MAPS).getValue());
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    protected Job runFailingMapperJob() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration myConf = new Configuration(mrCluster.getConfig());
        myConf.setInt("mapreduce.job.maps", 1);
        myConf.setInt("mapreduce.map.maxattempts", 2);
        Job job = new Job(myConf);
        job.setJarByClass(FailingMapper.class);
        job.setJobName("failmapper");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RandomTextWriterJob.RandomInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(FailingMapper.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "failmapper-output"));
        job.addFileToClassPath(APP_JAR);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertFalse((boolean)succeeded);
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        return job;
    }

    public void testSleepJobWithSecurityOn() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testSleepJobWithSecurityOn().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            return;
        }
        mrCluster.getConfig().set("hadoop.security.authentication", "kerberos");
        mrCluster.getConfig().set("yarn.resourcemanager.keytab", "/etc/krb5.keytab");
        mrCluster.getConfig().set("yarn.nodemanager.keytab", "/etc/krb5.keytab");
        mrCluster.getConfig().set("yarn.resourcemanager.principal", "rm/sightbusy-lx@LOCALHOST");
        mrCluster.getConfig().set("yarn.nodemanager.principal", "nm/sightbusy-lx@LOCALHOST");
        UserGroupInformation.setConfiguration((Configuration)mrCluster.getConfig());
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        LOG.info((Object)("User name is " + user.getUserName()));
        for (Token str : user.getTokens()) {
            LOG.info((Object)("Token is " + str.encodeToUrlString()));
        }
        user.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testDistributedCache() throws Exception {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Path first = this.createTempFile("distributed.first", "x");
        Path second = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.second.jar"), 2);
        Path third = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.third.jar"), 3);
        Path fourth = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.fourth.jar"), 4);
        Job job = Job.getInstance((Configuration)mrCluster.getConfig());
        job.setJarByClass(DistributedCacheChecker.class);
        job.setMapperClass(DistributedCacheChecker.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{first});
        job.addCacheFile(new URI(first.toUri().toString() + "#distributed.first.symlink"));
        job.addFileToClassPath(second);
        job.addFileToClassPath(APP_JAR);
        job.addArchiveToClassPath(third);
        job.addCacheArchive(fourth.toUri());
        job.createSymlink();
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
    }

    private Path createTempFile(String filename, String contents) throws IOException {
        Path path = new Path(TEST_ROOT_DIR, filename);
        FSDataOutputStream os = localFs.create(path);
        os.writeBytes(contents);
        os.close();
        localFs.setPermission(path, new FsPermission("700"));
        return path;
    }

    private Path makeJar(Path p, int index) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(new File(p.toUri().getPath()));
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("distributed.jar.inside" + index);
        jos.putNextEntry(ze);
        jos.write(("inside the jar!" + index).getBytes());
        jos.closeEntry();
        jos.close();
        localFs.setPermission(p, new FsPermission("700"));
        return p;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMRJobs.class.getName() + "-tmpDir").makeQualified(localFs);
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

