/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.security.TestBinaryTokenFile;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestBinaryTokenFile {
    private static MiniMRCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static final Path TEST_DIR;
    private static final Path binaryTokenFileName;
    private static int numSlaves;
    private static JobConf jConf;
    private static Path p1;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        dfsCluster = new MiniDFSCluster(conf, numSlaves, true, null);
        jConf = new JobConf(conf);
        mrCluster = new MiniMRCluster(0, 0, numSlaves, dfsCluster.getFileSystem().getUri().toString(), 1, null, null, null, jConf);
        NameNodeAdapter.getDtSecretManager((FSNamesystem)dfsCluster.getNamesystem()).startThreads();
        DistributedFileSystem fs = dfsCluster.getFileSystem();
        p1 = new Path("file1");
        p1 = fs.makeQualified(p1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.shutdown();
        }
        mrCluster = null;
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
        dfsCluster = null;
    }

    @Test
    public void testBinaryTokenFile() throws IOException {
        System.out.println("running dist job");
        jConf = mrCluster.createJobConf();
        String nnUri = dfsCluster.getURI(0).toString();
        jConf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri);
        jConf.set("mapreduce.jobtracker.kerberos.principal", "jt_id");
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jConf, (Tool)new MySleepJob(this), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0", (long)res, (long)0L);
    }

    static /* synthetic */ Path access$000() {
        return p1;
    }

    static /* synthetic */ Path access$100() {
        return binaryTokenFileName;
    }

    static {
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
        binaryTokenFileName = new Path(TEST_DIR, "tokenFile.binary");
        numSlaves = 1;
    }
}

