/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.DelegatingInputFormat;
import org.apache.hadoop.mapred.lib.MultipleInputs;
import org.apache.hadoop.mapred.lib.TaggedInputSplit;
import org.apache.hadoop.mapred.lib.TestDelegatingInputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDelegatingInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitting() throws Exception {
        JobConf conf = new JobConf();
        MiniDFSCluster dfs = null;
        try {
            dfs = new MiniDFSCluster((Configuration)conf, 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
            DistributedFileSystem fs = dfs.getFileSystem();
            Path path = TestDelegatingInputFormat.getPath((String)"/foo/bar", (FileSystem)fs);
            Path path2 = TestDelegatingInputFormat.getPath((String)"/foo/baz", (FileSystem)fs);
            Path path3 = TestDelegatingInputFormat.getPath((String)"/bar/bar", (FileSystem)fs);
            Path path4 = TestDelegatingInputFormat.getPath((String)"/bar/baz", (FileSystem)fs);
            int numSplits = 100;
            MultipleInputs.addInputPath((JobConf)conf, (Path)path, TextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path2, TextInputFormat.class, MapClass2.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path3, KeyValueTextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path4, TextInputFormat.class, MapClass2.class);
            DelegatingInputFormat inFormat = new DelegatingInputFormat();
            InputSplit[] splits = inFormat.getSplits(conf, 100);
            int[] bins = new int[3];
            for (InputSplit split : splits) {
                TestDelegatingInputFormat.assertTrue((boolean)(split instanceof TaggedInputSplit));
                TaggedInputSplit tis = (TaggedInputSplit)split;
                int index = -1;
                index = tis.getInputFormatClass().equals(KeyValueTextInputFormat.class) ? 0 : (tis.getMapperClass().equals(MapClass.class) ? 1 : 2);
                int n = index;
                bins[n] = bins[n] + 1;
            }
            for (int count : bins) {
                TestDelegatingInputFormat.assertEquals((int)100, (int)count);
            }
            TestDelegatingInputFormat.assertTrue((boolean)true);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static Path getPath(String location, FileSystem fs) throws IOException {
        Path path = new Path(location);
        FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        return path;
    }
}

