/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestResourceMgrDelegate {
    @Test
    public void testGetRootQueues() throws IOException, InterruptedException {
        ClientRMProtocol applicationsManager = (ClientRMProtocol)Mockito.mock(ClientRMProtocol.class);
        GetQueueInfoResponse response = (GetQueueInfoResponse)Mockito.mock(GetQueueInfoResponse.class);
        QueueInfo queueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)response.getQueueInfo()).thenReturn((Object)queueInfo);
        Mockito.when((Object)applicationsManager.getQueueInfo((GetQueueInfoRequest)Mockito.any(GetQueueInfoRequest.class))).thenReturn((Object)response);
        ResourceMgrDelegate delegate = new ResourceMgrDelegate(new YarnConfiguration(), applicationsManager);
        delegate.getRootQueues();
        ArgumentCaptor argument = ArgumentCaptor.forClass(GetQueueInfoRequest.class);
        ((ClientRMProtocol)Mockito.verify((Object)delegate.applicationsManager)).getQueueInfo((GetQueueInfoRequest)argument.capture());
        Assert.assertTrue((String)"Children of root queue not requested", (boolean)((GetQueueInfoRequest)argument.getValue()).getIncludeChildQueues());
        Assert.assertTrue((String)"Request wasn't to recurse through children", (boolean)((GetQueueInfoRequest)argument.getValue()).getRecursive());
    }
}

