/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRYarnClusterAdapter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.util.JarFinder;

public class MiniMRClientClusterFactory {
    public static MiniMRClientCluster create(Class<?> caller, int noOfNMs, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testRootDir = new Path("target", caller.getName() + "-tmpDir").makeQualified(fs);
        Path appJar = new Path(testRootDir, "MRAppJar.jar");
        Path appMasterJar = new Path(MiniMRYarnCluster.APPJAR);
        fs.copyFromLocalFile(appMasterJar, appJar);
        fs.setPermission(appJar, new FsPermission("744"));
        Job job = Job.getInstance((Configuration)conf);
        job.addFileToClassPath(appJar);
        String callerJar = JarFinder.getJar(caller);
        job.setJar(callerJar);
        MiniMRYarnCluster miniMRYarnCluster = new MiniMRYarnCluster(caller.getName(), noOfNMs);
        miniMRYarnCluster.init(job.getConfiguration());
        miniMRYarnCluster.start();
        return new MiniMRYarnClusterAdapter(miniMRYarnCluster);
    }
}

