/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

public class LocalContainerAllocator
extends RMCommunicator
implements ContainerAllocator {
    private static final Log LOG = LogFactory.getLog(LocalContainerAllocator.class);
    private final EventHandler eventHandler;
    private AtomicInteger containerCount = new AtomicInteger();
    private long retryInterval;
    private long retrystartTime;
    private String nmHost;
    private int nmPort;
    private int nmHttpPort;
    private ContainerId containerId;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public LocalContainerAllocator(ClientService clientService, AppContext context, String nmHost, int nmPort, int nmHttpPort, ContainerId cId) {
        super(clientService, context);
        this.eventHandler = context.getEventHandler();
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.containerId = cId;
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    protected synchronized void heartbeat() throws Exception {
        AMResponse response;
        AllocateRequest allocateRequest = BuilderUtils.newAllocateRequest((ApplicationAttemptId)this.applicationAttemptId, (int)this.lastResponseID, (float)super.getApplicationProgress(), new ArrayList(), new ArrayList());
        AllocateResponse allocateResponse = this.scheduler.allocate(allocateRequest);
        try {
            response = allocateResponse.getAMResponse();
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                throw new YarnException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        if (response.getReboot()) {
            LOG.info((Object)"Event from RM: shutting down Application Master");
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
            throw new YarnException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationID());
        }
    }

    public void handle(ContainerAllocatorEvent event) {
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            LOG.info((Object)("Processing the event " + event.toString()));
            ContainerId cID = (ContainerId)this.recordFactory.newRecordInstance(ContainerId.class);
            cID.setApplicationAttemptId(this.applicationAttemptId);
            cID.setId(this.containerId.getId());
            Container container = (Container)this.recordFactory.newRecordInstance(Container.class);
            container.setId(cID);
            NodeId nodeId = (NodeId)Records.newRecord(NodeId.class);
            nodeId.setHost(this.nmHost);
            nodeId.setPort(this.nmPort);
            container.setNodeId(nodeId);
            container.setContainerToken(null);
            container.setNodeHttpAddress(this.nmHost + ":" + this.nmHttpPort);
            if (event.getAttemptID().getTaskId().getTaskType() == TaskType.MAP) {
                JobCounterUpdateEvent jce = new JobCounterUpdateEvent(event.getAttemptID().getTaskId().getJobId());
                jce.addCounterUpdate((Enum)JobCounter.OTHER_LOCAL_MAPS, 1L);
                this.eventHandler.handle((Event)jce);
            }
            this.eventHandler.handle((Event)new TaskAttemptContainerAssignedEvent(event.getAttemptID(), container, this.applicationACLs));
        }
    }
}

