/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.AbstractService;

public class TaskHeartbeatHandler
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(TaskHeartbeatHandler.class);
    private static final int PING_TIMEOUT = 300000;
    private Thread lostTaskCheckerThread;
    private volatile boolean stopped;
    private int taskTimeOut = 300000;
    private int taskTimeOutCheckInterval = 30000;
    private final EventHandler eventHandler;
    private final Clock clock;
    private ConcurrentMap<TaskAttemptId, ReportTime> runningAttempts;

    public TaskHeartbeatHandler(EventHandler eventHandler, Clock clock, int numThreads) {
        super("TaskHeartbeatHandler");
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.runningAttempts = new ConcurrentHashMap(16, 0.75f, numThreads);
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.taskTimeOut = conf.getInt("mapreduce.task.timeout", 300000);
        this.taskTimeOutCheckInterval = conf.getInt("mapreduce.task.timeout.check-interval-ms", 30000);
    }

    public void start() {
        this.lostTaskCheckerThread = new Thread((Runnable)new PingChecker(this, null));
        this.lostTaskCheckerThread.setName("TaskHeartbeatHandler PingChecker");
        this.lostTaskCheckerThread.start();
        super.start();
    }

    public void stop() {
        this.stopped = true;
        this.lostTaskCheckerThread.interrupt();
        super.stop();
    }

    public void progressing(TaskAttemptId attemptID) {
        ReportTime time = (ReportTime)this.runningAttempts.get(attemptID);
        if (time != null) {
            time.setLastProgress(this.clock.getTime());
        }
    }

    public void pinged(TaskAttemptId attemptID) {
        ReportTime time = (ReportTime)this.runningAttempts.get(attemptID);
        if (time != null) {
            time.setLastPing(this.clock.getTime());
        }
    }

    public void register(TaskAttemptId attemptID) {
        this.runningAttempts.put(attemptID, new ReportTime(this.clock.getTime()));
    }

    public void unregister(TaskAttemptId attemptID) {
        this.runningAttempts.remove(attemptID);
    }

    static /* synthetic */ boolean access$100(TaskHeartbeatHandler x0) {
        return x0.stopped;
    }

    static /* synthetic */ ConcurrentMap access$200(TaskHeartbeatHandler x0) {
        return x0.runningAttempts;
    }

    static /* synthetic */ Clock access$300(TaskHeartbeatHandler x0) {
        return x0.clock;
    }

    static /* synthetic */ int access$400(TaskHeartbeatHandler x0) {
        return x0.taskTimeOut;
    }

    static /* synthetic */ EventHandler access$500(TaskHeartbeatHandler x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ int access$600(TaskHeartbeatHandler x0) {
        return x0.taskTimeOutCheckInterval;
    }

    static /* synthetic */ Log access$700() {
        return LOG;
    }
}

