/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TestTaskAttemptListenerImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskAttemptListenerImpl {
    @Test
    public void testGetTask() throws IOException {
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        JobTokenSecretManager secret = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        TaskHeartbeatHandler hbHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptListenerImpl listener = new MockTaskAttemptListenerImpl(appCtx, secret, hbHandler);
        Configuration conf = new Configuration();
        listener.init(conf);
        listener.start();
        JVMId id = new JVMId("foo", 1, true, 1);
        WrappedJvmID wid = new WrappedJvmID(id.getJobId(), id.isMap, id.getId());
        JvmContext context = new JvmContext();
        context.jvmId = id;
        JvmTask result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        TaskAttemptId attemptID = (TaskAttemptId)Mockito.mock(TaskAttemptId.class);
        Task task = (Task)Mockito.mock(Task.class);
        listener.registerPendingTask(task, wid);
        result = listener.getTask(context);
        Assert.assertNull((Object)result);
        listener.unregister(attemptID, wid);
        listener.registerPendingTask(task, wid);
        listener.registerLaunchedTask(attemptID, wid);
        ((TaskHeartbeatHandler)Mockito.verify((Object)hbHandler)).register(attemptID);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.shouldDie);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        listener.unregister(attemptID, wid);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        listener.stop();
    }
}

