/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.AsyncDiskService;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRAsyncDiskService {
    public static final Log LOG = LogFactory.getLog(MRAsyncDiskService.class);
    AsyncDiskService asyncDiskService;
    public static final String TOBEDELETED = "toBeDeleted";
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
    private FileSystem localFileSystem;
    private String[] volumes;
    private static AtomicLong uniqueId = new AtomicLong(0L);

    public MRAsyncDiskService(FileSystem localFileSystem, String ... nonCanonicalVols) throws IOException {
        Path absoluteSubdir;
        int v;
        this.localFileSystem = localFileSystem;
        this.volumes = new String[nonCanonicalVols.length];
        for (v = 0; v < nonCanonicalVols.length; ++v) {
            this.volumes[v] = this.normalizePath(nonCanonicalVols[v]);
            LOG.debug((Object)("Normalized volume: " + nonCanonicalVols[v] + " -> " + this.volumes[v]));
        }
        this.asyncDiskService = new AsyncDiskService(this.volumes);
        for (v = 0; v < this.volumes.length; ++v) {
            absoluteSubdir = new Path(this.volumes[v], TOBEDELETED);
            if (localFileSystem.mkdirs(absoluteSubdir)) continue;
            throw new IOException("Cannot create toBeDeleted in " + this.volumes[v]);
        }
        for (v = 0; v < this.volumes.length; ++v) {
            absoluteSubdir = new Path(this.volumes[v], TOBEDELETED);
            FileStatus[] files = localFileSystem.listStatus(absoluteSubdir);
            for (int f = 0; f < files.length; ++f) {
                String absoluteFilename = files[f].getPath().toUri().getPath();
                String relative = this.getRelativePathName(absoluteFilename, this.volumes[v]);
                if (relative == null) {
                    throw new IOException("Cannot delete " + absoluteFilename + " because it's outside of " + this.volumes[v]);
                }
                DeleteTask task = new DeleteTask(this.volumes[v], absoluteFilename, relative);
                this.execute(this.volumes[v], task);
            }
        }
    }

    public MRAsyncDiskService(JobConf conf) throws IOException {
        this((FileSystem)FileSystem.getLocal((Configuration)conf), conf.getLocalDirs());
    }

    synchronized void execute(String root, Runnable task) {
        this.asyncDiskService.execute(root, task);
    }

    public synchronized void shutdown() {
        this.asyncDiskService.shutdown();
    }

    public synchronized List<Runnable> shutdownNow() {
        return this.asyncDiskService.shutdownNow();
    }

    public synchronized boolean awaitTermination(long milliseconds) throws InterruptedException {
        return this.asyncDiskService.awaitTermination(milliseconds);
    }

    public boolean moveAndDeleteRelativePath(String volume, String pathName) throws IOException {
        volume = this.normalizePath(volume);
        String newPathName = this.format.format(new Date()) + "_" + uniqueId.getAndIncrement();
        newPathName = "toBeDeleted/" + newPathName;
        Path source = new Path(volume, pathName);
        Path target = new Path(volume, newPathName);
        try {
            if (!this.localFileSystem.rename(source, target)) {
                if (!this.localFileSystem.mkdirs(new Path(volume, TOBEDELETED))) {
                    throw new IOException("Cannot create toBeDeleted under " + volume);
                }
                if (!this.localFileSystem.rename(source, target)) {
                    throw new IOException("Cannot rename " + source + " to " + target);
                }
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        DeleteTask task = new DeleteTask(volume, pathName, newPathName);
        this.execute(volume, task);
        return true;
    }

    public boolean moveAndDeleteFromEachVolume(String pathName) throws IOException {
        boolean result = true;
        for (int i = 0; i < this.volumes.length; ++i) {
            result = result && this.moveAndDeleteRelativePath(this.volumes[i], pathName);
        }
        return result;
    }

    public void cleanupAllVolumes() throws IOException {
        for (int v = 0; v < this.volumes.length; ++v) {
            FileStatus[] files = this.localFileSystem.listStatus(new Path(this.volumes[v]));
            for (int f = 0; f < files.length; ++f) {
                String absoluteFilename = files[f].getPath().toUri().getPath();
                String relative = this.getRelativePathName(absoluteFilename, this.volumes[v]);
                if (relative == null) {
                    throw new IOException("Cannot delete " + absoluteFilename + " because it's outside of " + this.volumes[v]);
                }
                if (TOBEDELETED.equals(relative)) continue;
                this.moveAndDeleteRelativePath(this.volumes[v], relative);
            }
        }
    }

    private String normalizePath(String path) {
        return new Path(path).makeQualified(this.localFileSystem).toUri().getPath();
    }

    private String getRelativePathName(String absolutePathName, String volume) {
        if (!(absolutePathName = this.normalizePath(absolutePathName)).startsWith(volume)) {
            return null;
        }
        String fileName = absolutePathName.substring(volume.length());
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    public boolean moveAndDeleteAbsolutePath(String absolutePathName) throws IOException {
        for (int v = 0; v < this.volumes.length; ++v) {
            String relative = this.getRelativePathName(absolutePathName, this.volumes[v]);
            if (relative == null) continue;
            return this.moveAndDeleteRelativePath(this.volumes[v], relative);
        }
        throw new IOException("Cannot delete " + absolutePathName + " because it's outside of all volumes.");
    }

    class DeleteTask
    implements Runnable {
        String volume;
        String originalPath;
        String pathToBeDeleted;

        DeleteTask(String volume, String originalPath, String pathToBeDeleted) {
            this.volume = volume;
            this.originalPath = originalPath;
            this.pathToBeDeleted = pathToBeDeleted;
        }

        public String toString() {
            return "deletion of " + this.pathToBeDeleted + " on " + this.volume + " with original name " + this.originalPath;
        }

        @Override
        public void run() {
            boolean success = false;
            Exception e = null;
            try {
                Path absolutePathToBeDeleted = new Path(this.volume, this.pathToBeDeleted);
                success = MRAsyncDiskService.this.localFileSystem.delete(absolutePathToBeDeleted, true);
            }
            catch (Exception ex) {
                e = ex;
            }
            if (!success) {
                if (e != null) {
                    LOG.warn((Object)("Failure in " + this + " with exception " + StringUtils.stringifyException((Throwable)e)));
                } else {
                    LOG.warn((Object)("Failure in " + this));
                }
            } else {
                LOG.debug((Object)("Successfully did " + this.toString()));
            }
        }
    }
}

