/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class jobtracker_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat percentFormat = new DecimalFormat("##0.00");
    private static List _jspx_dependants;

    public void generateSummaryTable(JspWriter out, ClusterMetrics metrics, JobTracker tracker) throws IOException {
        String tasksPerNode = metrics.getTaskTrackerCount() > 0 ? percentFormat.format((double)(metrics.getMapSlotCapacity() + metrics.getReduceSlotCapacity()) / (double)metrics.getTaskTrackerCount()) : "-";
        out.print("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n<tr><th>Queues</th><th>Running Map Tasks</th><th>Running Reduce Tasks</th><th>Total Submissions</th><th>Nodes</th><th>Occupied Map Slots</th><th>Occupied Reduce Slots</th><th>Reserved Map Slots</th><th>Reserved Reduce Slots</th><th>Map Slot Capacity</th><th>Reduce Slot Capacity</th><th>Avg. Slots/Node</th><th>Blacklisted Nodes</th><th>Excluded Nodes</th></tr>\n");
        out.print("<tr><td><a href=\"queueinfo.jsp\">" + tracker.getRootQueues().length + "</a></td><td>" + metrics.getRunningMaps() + "</td><td>" + metrics.getRunningReduces() + "</td><td>" + metrics.getTotalJobSubmissions() + "</td><td><a href=\"machines.jsp?type=active\">" + metrics.getTaskTrackerCount() + "</a></td><td>" + metrics.getOccupiedMapSlots() + "</td><td>" + metrics.getOccupiedReduceSlots() + "</td><td>" + metrics.getReservedMapSlots() + "</td><td>" + metrics.getReservedReduceSlots() + "</td><td>" + metrics.getMapSlotCapacity() + "</td><td>" + metrics.getReduceSlotCapacity() + "</td><td>" + tasksPerNode + "</td><td><a href=\"machines.jsp?type=blacklisted\">" + metrics.getBlackListedTaskTrackerCount() + "</a>" + "</td><td><a href=\"machines.jsp?type=excluded\">" + metrics.getDecommissionedTaskTrackerCount() + "</a>" + "</td></tr></table>\n");
        out.print("<br>");
        if (tracker.recoveryManager.shouldRecover()) {
            out.print("<span class=\"small\"><i>");
            if (tracker.hasRecovered()) {
                out.print("The JobTracker got restarted and recovered back in ");
                out.print(StringUtils.formatTime((long)tracker.getRecoveryDuration()));
            } else {
                out.print("The JobTracker got restarted and is still recovering");
            }
            out.print("</i></span>");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<JobInProgress> failedJobs;
        List<JobInProgress> completedJobs;
        List<JobInProgress> runningJobs;
        String trackerName;
        ClusterMetrics metrics;
        MemoryMXBean mem;
        ClusterStatus status;
        JobTracker tracker;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block10: {
            _jspxFactory = null;
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            out = null;
            jobtracker_jsp page = this;
            _jspx_out = null;
            _jspx_page_context = null;
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write(10);
            tracker = (JobTracker)application.getAttribute("job.tracker");
            status = tracker.getClusterStatus();
            mem = ManagementFactory.getMemoryMXBean();
            metrics = tracker.getClusterMetrics();
            trackerName = StringUtils.simpleHostname((String)tracker.getJobTrackerMachine());
            JobQueueInfo[] queues = tracker.getJobQueues();
            runningJobs = tracker.getRunningJobs();
            completedJobs = tracker.getCompletedJobs();
            failedJobs = tracker.getFailedJobs();
            out.write(10);
            out.write("\n\n\n<html>\n<head>\n<title>");
            out.print(trackerName);
            out.write(" Hadoop Map/Reduce Administration</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<script type=\"text/javascript\" src=\"/static/jobtracker.js\"></script>\n</head>\n<body>\n\n");
            if (JSPUtil.processButtons(request, response, tracker)) break block10;
            if (_jspxFactory == null) return;
            _jspxFactory.releasePageContext(_jspx_page_context);
            return;
        }
        try {
            out.write("\n\n<h1>");
            out.print(trackerName);
            out.write(" Hadoop Map/Reduce Administration</h1>\n\n<div id=\"quicklinks\">\n  <a href=\"#quicklinks\" onclick=\"toggle('quicklinks-list'); return false;\">Quick Links</a>\n  <ul id=\"quicklinks-list\">\n    <li><a href=\"#running_jobs\">Running Jobs</a></li>\n    <li><a href=\"#retired_jobs\">Retired Jobs</a></li>\n    <li><a href=\"#local_logs\">Local Logs</a></li>\n  </ul>\n</div>\n\n<b>State:</b> ");
            out.print((Object)status.getJobTrackerState());
            out.write("<br>\n<b>Started:</b> ");
            out.print((Object)new Date(tracker.getStartTime()));
            out.write("<br>\n<b>Version:</b> ");
            out.print(VersionInfo.getVersion());
            out.write(",\n                ");
            out.print(VersionInfo.getRevision());
            out.write("<br>\n<b>Compiled:</b> ");
            out.print(VersionInfo.getDate());
            out.write(" by \n                 ");
            out.print(VersionInfo.getUser());
            out.write(" from\n                 ");
            out.print(VersionInfo.getBranch());
            out.write("<br>\n<b>Identifier:</b> ");
            out.print(tracker.getTrackerIdentifier());
            out.write("<br>                 \n                   \n<hr>\n<h2>Cluster Summary (Heap Size is\n    ");
            MemoryUsage heap = mem.getHeapMemoryUsage();
            out.print(StringUtils.byteDesc((long)heap.getUsed()) + "/");
            out.print(StringUtils.byteDesc((long)heap.getCommitted()) + "/");
            out.print(StringUtils.byteDesc((long)heap.getMax()) + ")");
            out.write(10);
            this.generateSummaryTable(out, metrics, tracker);
            out.write("\n<hr>\n<b>Filter (Jobid, Priority, User, Name)</b> <input type=\"text\" id=\"filter\" onkeyup=\"applyfilter()\"> <br>\n<span class=\"small\">Example: 'user:smith 3200' will filter by 'smith' only in the user field and '3200' in all fields</span>\n<hr>\n\n<h2 id=\"running_jobs\">Running Jobs</h2>\n");
            out.print(JSPUtil.generateJobTable("Running", runningJobs, 30, 0, tracker.conf));
            out.write("\n<hr>\n\n");
            if (completedJobs.size() > 0) {
                out.print("<h2 id=\"completed_jobs\">Completed Jobs</h2>");
                out.print(JSPUtil.generateJobTable("Completed", completedJobs, 0, runningJobs.size(), tracker.conf));
                out.print("<hr>");
            }
            out.write(10);
            out.write(10);
            if (failedJobs.size() > 0) {
                out.print("<h2 id=\"failed_jobs\">Failed Jobs</h2>");
                out.print(JSPUtil.generateJobTable("Failed", failedJobs, 0, runningJobs.size() + completedJobs.size(), tracker.conf));
                out.print("<hr>");
            }
            out.write("\n\n<h2 id=\"retired_jobs\">Retired Jobs</h2>\n");
            out.print(JSPUtil.generateRetiredJobTable(tracker, runningJobs.size() + completedJobs.size() + failedJobs.size()));
            out.write("\n<hr>\n\n<h2 id=\"local_logs\">Local Logs</h2>\n<a href=\"logs/\">Log</a> directory, <a href=\"jobhistory.jsp\">\nJob Tracker History</a>\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

