/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class TaskController
implements Configurable {
    private Configuration conf;
    public static final Log LOG = LogFactory.getLog(TaskController.class);
    protected String[] mapredLocalDirs;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.mapredLocalDirs = conf.getTrimmedStrings("mapreduce.cluster.local.dir");
    }

    public void setup() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        for (String localDir : this.mapredLocalDirs) {
            File mapredlocalDir = new File(localDir);
            if (!mapredlocalDir.isDirectory() && !mapredlocalDir.mkdirs()) {
                LOG.warn((Object)("Unable to create mapreduce.cluster.local.directory : " + mapredlocalDir.getPath()));
                continue;
            }
            localFs.setPermission(new Path(mapredlocalDir.getCanonicalPath()), new FsPermission(493));
        }
        File taskLog = TaskLog.getUserLogDir();
        if (!taskLog.isDirectory() && !taskLog.mkdirs()) {
            LOG.warn((Object)("Unable to create taskLog directory : " + taskLog.getPath()));
        } else {
            localFs.setPermission(new Path(taskLog.getCanonicalPath()), new FsPermission(493));
        }
        DiskChecker.checkDir((File)TaskLog.getUserLogDir());
    }

    abstract void initializeJob(JobInitializationContext var1) throws IOException;

    public abstract void initializeDistributedCacheFile(DistributedCacheFileContext var1) throws IOException;

    abstract void launchTaskJVM(TaskControllerContext var1) throws IOException;

    final void destroyTaskJVM(TaskControllerContext context) {
        this.terminateTask(context);
        try {
            Thread.sleep(context.sleeptimeBeforeSigkill);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Sleep interrupted : " + StringUtils.stringifyException((Throwable)e)));
        }
        this.killTask(context);
    }

    abstract void initializeTask(TaskControllerContext var1) throws IOException;

    abstract void terminateTask(TaskControllerContext var1);

    abstract void killTask(TaskControllerContext var1);

    abstract void dumpTaskStack(TaskControllerContext var1);

    public abstract void initializeUser(InitializationContext var1) throws IOException;

    abstract void runDebugScript(DebugScriptContext var1) throws IOException;

    abstract void enableTaskForCleanup(CleanupQueue.PathDeletionContext var1) throws IOException;

    abstract void enableJobForCleanup(CleanupQueue.PathDeletionContext var1) throws IOException;

    String getRunAsUser(JobConf conf) {
        return System.getProperty("user.name");
    }

    static class DebugScriptContext
    extends TaskExecContext {
        List<String> args;
        File workDir;
        File stdout;

        DebugScriptContext() {
        }
    }

    static class JobInitializationContext
    extends InitializationContext {
        JobID jobid;

        JobInitializationContext() {
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class DistributedCacheFileContext
    extends InitializationContext {
        Path localizedBaseDir;
        String uniqueString;

        public DistributedCacheFileContext(String user, File workDir, Path localizedBaseDir, String uniqueString) {
            super(user, workDir);
            this.localizedBaseDir = localizedBaseDir;
            this.uniqueString = uniqueString;
        }

        public Path getLocalizedUniqueDir() {
            return new Path(this.localizedBaseDir, new Path(TaskTracker.getPrivateDistributedCacheDir(this.user), this.uniqueString));
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class InitializationContext {
        public File workDir;
        public String user;

        public InitializationContext() {
        }

        public InitializationContext(String user, File workDir) {
            this.user = user;
            this.workDir = workDir;
        }
    }

    static class TaskControllerJobPathDeletionContext
    extends TaskControllerPathDeletionContext {
        final JobID jobId;

        public TaskControllerJobPathDeletionContext(FileSystem fs, Path mapredLocalDir, JobID id, String user, TaskController taskController) {
            super(fs, mapredLocalDir, taskController, user);
            this.jobId = id;
        }

        @Override
        protected String getPath() {
            return TaskTracker.getLocalJobDir(this.user, this.jobId.toString());
        }

        @Override
        protected void enablePathForCleanup() throws IOException {
            this.getPathForCleanup();
            if (this.fs.exists(new Path(this.fullPath))) {
                this.taskController.enableJobForCleanup(this);
            }
        }
    }

    static class TaskControllerTaskPathDeletionContext
    extends TaskControllerPathDeletionContext {
        final Task task;
        final boolean isWorkDir;

        public TaskControllerTaskPathDeletionContext(FileSystem fs, Path mapredLocalDir, Task task, boolean isWorkDir, TaskController taskController) {
            super(fs, mapredLocalDir, taskController, task.getUser());
            this.task = task;
            this.isWorkDir = isWorkDir;
        }

        @Override
        protected String getPath() {
            String subDir = this.isWorkDir ? TaskTracker.getTaskWorkDir(this.task.getUser(), this.task.getJobID().toString(), this.task.getTaskID().toString(), this.task.isTaskCleanupTask()) : TaskTracker.getLocalTaskDir(this.task.getUser(), this.task.getJobID().toString(), this.task.getTaskID().toString(), this.task.isTaskCleanupTask());
            return subDir;
        }

        @Override
        protected void enablePathForCleanup() throws IOException {
            this.getPathForCleanup();
            if (this.fs.exists(new Path(this.fullPath))) {
                this.taskController.enableTaskForCleanup(this);
            }
        }
    }

    static abstract class TaskControllerPathDeletionContext
    extends CleanupQueue.PathDeletionContext {
        TaskController taskController;
        String user;
        Path mapredLocalDir;

        public TaskControllerPathDeletionContext(FileSystem fs, Path mapredLocalDir, TaskController taskController, String user) {
            super(fs, null);
            this.taskController = taskController;
            this.mapredLocalDir = mapredLocalDir;
            this.user = user;
        }

        @Override
        protected String getPathForCleanup() {
            if (this.fullPath == null) {
                this.fullPath = this.buildPathForDeletion();
            }
            return this.fullPath;
        }

        protected abstract String getPath();

        String buildPathForDeletion() {
            return this.mapredLocalDir.toUri().getPath() + "/" + this.getPath();
        }
    }

    static class TaskControllerContext
    extends TaskExecContext {
        Shell.ShellCommandExecutor shExec;
        JvmManager.JvmEnv env;
        String pid;
        long sleeptimeBeforeSigkill;

        TaskControllerContext() {
        }
    }

    static class TaskExecContext {
        Task task;

        TaskExecContext() {
        }
    }
}

