/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMetricsInst;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.mapreduce.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.server.jobtracker.State;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalJobRunner
implements ClientProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private int reduce_tasks = 0;
    final Random rand = new Random();
    private JobTrackerInstrumentation myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static final org.apache.hadoop.mapred.Counters EMPTY_COUNTERS = new org.apache.hadoop.mapred.Counters();
    private static int jobid = 0;

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 36L;
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal((Configuration)conf);
        this.conf = conf;
        this.myMetrics = new JobTrackerMetricsInst(null, new JobConf(conf));
    }

    @Override
    public synchronized org.apache.hadoop.mapreduce.JobID getNewJobID() {
        return new org.apache.hadoop.mapreduce.JobID("local", ++jobid);
    }

    @Override
    public JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(JobID.downgrade(jobid), jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    @Override
    public void killJob(org.apache.hadoop.mapreduce.JobID id) {
        this.jobs.get((Object)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).killed = true;
        this.jobs.get(JobID.downgrade(id)).interrupt();
    }

    @Override
    public void setJobPriority(org.apache.hadoop.mapreduce.JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(org.apache.hadoop.mapreduce.TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID id, TaskType type) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade(id));
        if (job != null) {
            return job.status;
        }
        return null;
    }

    @Override
    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade(id));
        return new Counters(job.getCurrentCounters());
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterMetrics getClusterMetrics() {
        int numMapTasks = this.map_tasks.get();
        return new ClusterMetrics(numMapTasks, this.reduce_tasks, numMapTasks, this.reduce_tasks, 0, 0, 1, 1, this.jobs.size(), 1, 0, 0);
    }

    @Override
    @Deprecated
    public State getJobTrackerState() throws IOException, InterruptedException {
        return State.RUNNING;
    }

    @Override
    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    @Override
    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return null;
    }

    @Override
    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return null;
    }

    @Override
    public org.apache.hadoop.mapreduce.TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return org.apache.hadoop.mapreduce.TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(org.apache.hadoop.mapreduce.TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi != null ? ugi.getShortUserName() + this.rand.nextInt() : "dummy" + this.rand.nextInt();
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    @Override
    public String getJobHistoryDir() {
        return null;
    }

    @Override
    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getRootQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo getQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(JobContext job, int maxMaps) {
        job.getConfiguration().setInt(LOCAL_MAX_MAPS, maxMaps);
    }

    public static int getLocalMaxRunningMaps(JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_MAPS, 1);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private int numMapTasks;
        private float[] partialMapProgress;
        private org.apache.hadoop.mapred.Counters[] mapCounters;
        private org.apache.hadoop.mapred.Counters reduceCounters;
        private org.apache.hadoop.mapred.JobStatus status;
        private List<TaskAttemptID> mapIds = Collections.synchronizedList(new ArrayList());
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private TrackerDistributedCacheManager trackerDistributerdCacheManager;
        private TaskDistributedCacheManager taskDistributedCacheManager;

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            JobConf conf = new JobConf(this.systemJobFile);
            this.localFs = FileSystem.getLocal((Configuration)conf);
            this.localJobDir = this.localFs.makeQualified(conf.getLocalPath(LocalJobRunner.jobDir));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.trackerDistributerdCacheManager = new TrackerDistributedCacheManager(conf, new DefaultTaskController());
            this.taskDistributedCacheManager = this.trackerDistributerdCacheManager.newTaskDistributedCacheManager(conf);
            this.taskDistributedCacheManager.setup(new LocalDirAllocator("mapreduce.cluster.local.dir"), new File(this.systemJobDir.toString()), "archive", "archive");
            if (DistributedCache.getSymlink(conf)) {
                LOG.warn((Object)"LocalJobRunner does not support symlinking into current working dir.");
            }
            TaskRunner.setupWorkDir(conf, new File(this.localJobDir.toUri()).getAbsoluteFile());
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                conf.writeXml((OutputStream)out);
            }
            finally {
                out.close();
            }
            this.job = new JobConf(this.localJobFile);
            if (!this.taskDistributedCacheManager.getClassPaths().isEmpty()) {
                this.setContextClassLoader(this.taskDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new org.apache.hadoop.mapred.JobStatus(this.id, 0.0f, 0.0f, org.apache.hadoop.mapred.JobStatus.RUNNING, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), this.profile.getURL().toString());
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        protected List<MapTaskRunnable> getMapTaskRunnables(JobSplit.TaskSplitMetaInfo[] taskInfo, JobID jobId, Map<TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int numTasks = 0;
            ArrayList<MapTaskRunnable> list = new ArrayList<MapTaskRunnable>();
            for (JobSplit.TaskSplitMetaInfo task : taskInfo) {
                list.add(new MapTaskRunnable(task, numTasks++, jobId, mapOutputFiles));
            }
            return list;
        }

        private synchronized void initCounters(int numMaps) {
            this.partialMapProgress = new float[numMaps];
            this.mapCounters = new org.apache.hadoop.mapred.Counters[numMaps];
            for (int i = 0; i < numMaps; ++i) {
                this.mapCounters[i] = EMPTY_COUNTERS;
            }
            this.reduceCounters = EMPTY_COUNTERS;
        }

        protected ExecutorService createMapExecutor(int numMapTasks) {
            int maxMapThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_MAPS, 1);
            if (maxMapThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.map.tasks.maximum must be >= 1");
            }
            this.numMapTasks = numMapTasks;
            maxMapThreads = Math.min(maxMapThreads, this.numMapTasks);
            maxMapThreads = Math.max(maxMapThreads, 1);
            this.initCounters(this.numMapTasks);
            LOG.debug((Object)"Starting thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxMapThreads));
            LOG.debug((Object)("Map tasks to process: " + this.numMapTasks));
            ExecutorService executor = Executors.newFixedThreadPool(maxMapThreads);
            return executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContextImpl jContext = new JobContextImpl(this.job, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = this.job.getOutputCommitter();
            try {
                block30: {
                    JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.localFs, LocalJobRunner.this.conf, this.systemJobDir);
                    int numReduceTasks = this.job.getNumReduceTasks();
                    if (numReduceTasks > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob(jContext);
                    this.status.setSetupProgress(1.0f);
                    Map<TaskAttemptID, MapOutputFile> mapOutputFiles = Collections.synchronizedMap(new HashMap());
                    List<MapTaskRunnable> taskRunnables = this.getMapTaskRunnables(taskSplitMetaInfos, jobId, mapOutputFiles);
                    ExecutorService mapService = this.createMapExecutor(taskRunnables.size());
                    for (MapTaskRunnable r : taskRunnables) {
                        mapService.submit(r);
                    }
                    try {
                        mapService.shutdown();
                        LOG.info((Object)"Waiting for map tasks");
                        mapService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ie) {
                        mapService.shutdownNow();
                        throw ie;
                    }
                    LOG.info((Object)"Map task executor complete.");
                    for (MapTaskRunnable r : taskRunnables) {
                        if (r.storedException == null) continue;
                        throw new Exception(r.storedException);
                    }
                    TaskAttemptID reduceId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.REDUCE, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block30;
                        ReduceTask reduce = new ReduceTask(this.systemJobFile.toString(), reduceId, 0, this.mapIds.size(), 1);
                        reduce.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf(this.job);
                        localConf.set("mapreduce.jobtracker.address", "local");
                        TaskRunner.setupChildMapredLocalDirs(reduce, localConf);
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = mapOutputFiles.get(mapId).getOutputFile();
                                MapOutputFile localOutputFile = new MapOutputFile();
                                localOutputFile.setConf(localConf);
                                Path reduceIn = localOutputFile.getInputFileForWrite(mapId.getTaskID(), this.localFs.getFileStatus(mapOut).getLen());
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            reduce.setJobFile(this.localJobFile.toString());
                            localConf.setUser(reduce.getUser());
                            reduce.localizeConfiguration(localConf);
                            reduce.setConf(localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduce.getTaskID());
                            reduce.run(localConf, this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            break block30;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (MapOutputFile output : mapOutputFiles.values()) {
                            output.removeAll();
                        }
                    }
                }
                outputCommitter.commitJob(jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.SUCCEEDED);
                }
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob((JobContext)jContext, JobStatus.State.FAILED);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.FAILED);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.taskDistributedCacheManager.release();
                    this.trackerDistributerdCacheManager.purgeCache();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        @Override
        public JvmTask getTask(JvmContext context) {
            return null;
        }

        @Override
        public synchronized boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            LOG.info((Object)taskStatus.getStateString());
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                float numTasks = this.numMapTasks;
                this.partialMapProgress[taskIndex] = taskStatus.getProgress();
                this.mapCounters[taskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialMapProgress) {
                    partialProgress += f;
                }
                this.status.setMapProgress(partialProgress / numTasks);
            } else {
                this.reduceCounters = taskStatus.getCounters();
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            return true;
        }

        public synchronized org.apache.hadoop.mapred.Counters getCurrentCounters() {
            if (null == this.mapCounters) {
                return EMPTY_COUNTERS;
            }
            org.apache.hadoop.mapred.Counters current = EMPTY_COUNTERS;
            for (org.apache.hadoop.mapred.Counters c : this.mapCounters) {
                current = org.apache.hadoop.mapred.Counters.sum(current, c);
            }
            current = org.apache.hadoop.mapred.Counters.sum(current, this.reduceCounters);
            return current;
        }

        @Override
        public void commitPending(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) {
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void done(TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        @Override
        public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        @Override
        public synchronized void fatalError(TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        protected class MapTaskRunnable
        implements Runnable {
            private final int taskId;
            private final JobSplit.TaskSplitMetaInfo info;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<TaskAttemptID, MapOutputFile> mapOutputFiles;
            public volatile Throwable storedException;

            public MapTaskRunnable(JobSplit.TaskSplitMetaInfo info, int taskId, JobID jobId, Map<TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.info = info;
                this.taskId = taskId;
                this.mapOutputFiles = mapOutputFiles;
                this.jobId = jobId;
                this.localConf = new JobConf(Job.this.job);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TaskAttemptID mapId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jobId, TaskType.MAP, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + mapId));
                    Job.this.mapIds.add(mapId);
                    MapTask map = new MapTask(Job.this.systemJobFile.toString(), mapId, this.taskId, this.info.getSplitIndex(), 1);
                    map.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    TaskRunner.setupChildMapredLocalDirs(map, this.localConf);
                    MapOutputFile mapOutput = new MapOutputFile();
                    mapOutput.setConf(this.localConf);
                    this.mapOutputFiles.put(mapId, mapOutput);
                    map.setJobFile(Job.this.localJobFile.toString());
                    this.localConf.setUser(map.getUser());
                    map.localizeConfiguration(this.localConf);
                    map.setConf(this.localConf);
                    try {
                        LocalJobRunner.this.map_tasks.getAndIncrement();
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(this.localConf, Job.this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                    }
                    finally {
                        LocalJobRunner.this.map_tasks.getAndDecrement();
                    }
                    LOG.info((Object)("Finishing task: " + mapId));
                }
                catch (Throwable e) {
                    this.storedException = e;
                }
            }
        }
    }
}

