/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.CompletedJobStatusStore;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMetricsInst;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.QueueACL;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskGraphServlet;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistory;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.server.jobtracker.JTConfig;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.mapreduce.util.MRAsyncDiskService;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobTracker
implements MRConstants,
InterTrackerProtocol,
ClientProtocol,
TaskTrackerManager,
RefreshUserMappingsProtocol,
RefreshAuthorizationPolicyProtocol,
AdminOperationsProtocol,
JTConfig {
    private final long tasktrackerExpiryInterval;
    private final long DELEGATION_TOKEN_GC_INTERVAL = 3600000L;
    private final DelegationTokenSecretManager secretManager;
    private static long UPDATE_FAULTY_TRACKER_INTERVAL;
    private static double MAX_BLACKLIST_PERCENT;
    private double AVERAGE_BLACKLIST_THRESHOLD = 0.5;
    private int MAX_BLACKLISTS_PER_TRACKER = 4;
    private int NUM_HEARTBEATS_IN_SECOND;
    private final int DEFAULT_NUM_HEARTBEATS_IN_SECOND = 100;
    private final int MIN_NUM_HEARTBEATS_IN_SECOND = 1;
    private float HEARTBEATS_SCALING_FACTOR;
    private final float MIN_HEARTBEATS_SCALING_FACTOR = 0.01f;
    private final float DEFAULT_HEARTBEATS_SCALING_FACTOR = 1.0f;
    State state = State.INITIALIZING;
    private static final int FS_ACCESS_RETRY_PERIOD = 10000;
    static final String JOB_INFO_FILE = "job-info";
    private DNSToSwitchMapping dnsToSwitchMapping;
    NetworkTopology clusterMap = new NetworkTopology();
    private int numTaskCacheLevels;
    private Set<Node> nodesAtMaxLevel = Collections.newSetFromMap(new ConcurrentHashMap());
    final TaskScheduler taskScheduler;
    private final List<JobInProgressListener> jobInProgressListeners = new CopyOnWriteArrayList<JobInProgressListener>();
    static final FsPermission SYSTEM_DIR_PERMISSION;
    static final FsPermission SYSTEM_FILE_PERMISSION;
    private static Clock clock;
    static final Clock DEFAULT_CLOCK;
    private final JobHistory jobHistory;
    private final JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private MRAsyncDiskService asyncDiskService;
    private final AtomicInteger nextJobId = new AtomicInteger(1);
    public static final Log LOG;
    private final JobTrackerInstrumentation myInstrumentation;
    int port;
    String localMachine;
    private final String trackerIdentifier;
    long startTime;
    int totalSubmissions = 0;
    private int totalMapTaskCapacity;
    private int totalReduceTaskCapacity;
    private final HostsFileReader hostsReader;
    private volatile boolean hasRecovered = false;
    private volatile long recoveryDuration;
    Map<JobID, JobInProgress> jobs = Collections.synchronizedMap(new TreeMap());
    Map<String, Set<JobID>> trackerToJobsToCleanup = new HashMap<String, Set<JobID>>();
    Map<String, Set<org.apache.hadoop.mapred.TaskAttemptID>> trackerToTasksToCleanup = new HashMap<String, Set<org.apache.hadoop.mapred.TaskAttemptID>>();
    Map<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> taskidToTIPMap = new TreeMap<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress>();
    TreeMap<org.apache.hadoop.mapred.TaskAttemptID, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<org.apache.hadoop.mapred.TaskAttemptID>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<org.apache.hadoop.mapred.TaskAttemptID>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    Map<String, Node> hostnameToNodeMap = Collections.synchronizedMap(new TreeMap());
    Map<String, Set<TaskTracker>> hostnameToTaskTracker = Collections.synchronizedMap(new TreeMap());
    int numResolved;
    private FaultyTrackersInfo faultyTrackers = new FaultyTrackersInfo();
    private JobTrackerStatistics statistics = new JobTrackerStatistics();
    int totalMaps = 0;
    int totalReduces = 0;
    private int occupiedMapSlots = 0;
    private int occupiedReduceSlots = 0;
    private int reservedMapSlots = 0;
    private int reservedReduceSlots = 0;
    private HashMap<String, TaskTracker> taskTrackers = new HashMap();
    Map<String, Integer> uniqueHostsMap = new ConcurrentHashMap<String, Integer>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    final int retiredJobsCacheSize;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    final CompletedJobStatusStore completedJobStatusStore;
    Thread completedJobsStoreThread = null;
    final RecoveryManager recoveryManager;
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    final HttpServer infoServer;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    final LocalFileSystem localFs;
    FileSystem fs = null;
    Path systemDir = null;
    JobConf conf;
    private final ACLsManager aclsManager;
    long limitMaxMemForMapTasks;
    long limitMaxMemForReduceTasks;
    long memSizeForMapSlotOnJT;
    long memSizeForReduceSlotOnJT;
    private final QueueManager queueManager;
    private static final Counters EMPTY_COUNTERS;
    private static final TaskReport[] EMPTY_TASK_REPORTS;
    private static final String[] EMPTY_TASK_DIAGNOSTICS;

    JobTokenSecretManager getJobTokenSecretManager() {
        return this.jobTokenSecretManager;
    }

    public DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.secretManager;
    }

    static Clock getClock() {
        return clock == null ? DEFAULT_CLOCK : clock;
    }

    JobHistory getJobHistory() {
        return this.jobHistory;
    }

    public static JobTracker startTracker(JobConf conf) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, DEFAULT_CLOCK);
    }

    static JobTracker startTracker(JobConf conf, Clock clock) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, clock, JobTracker.generateNewIdentifier());
    }

    static JobTracker startTracker(JobConf conf, Clock clock, String identifier) throws IOException, InterruptedException {
        JobTracker result = null;
        while (true) {
            try {
                result = new JobTracker(conf, clock, identifier);
                result.taskScheduler.setTaskTrackerManager(result);
            }
            catch (RPC.VersionMismatch e) {
                throw e;
            }
            catch (BindException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error starting tracker: " + StringUtils.stringifyException((Throwable)e)));
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        if (result != null) {
            JobEndNotifier.startNotifier();
        }
        return result;
    }

    public void stopTracker() throws IOException {
        JobEndNotifier.stopNotifier();
        this.close();
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 30L;
        }
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 36L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(AdminOperationsProtocol.class.getName())) {
            return 3L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkExpiredTrackers() {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            HashMap<String, TaskTracker> hashMap = this.taskTrackers;
            synchronized (hashMap) {
                TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
                synchronized (treeSet) {
                    long now = clock.getTime();
                    TaskTrackerStatus leastRecent = null;
                    while (this.trackerExpiryQueue.size() > 0 && (leastRecent = this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > this.tasktrackerExpiryInterval) {
                        this.trackerExpiryQueue.remove(leastRecent);
                        String trackerName = leastRecent.getTrackerName();
                        TaskTracker current = this.getTaskTracker(trackerName);
                        TaskTrackerStatus newProfile = current == null ? null : current.getStatus();
                        if (newProfile == null) continue;
                        if (now - newProfile.getLastSeen() > this.tasktrackerExpiryInterval) {
                            this.removeTracker(current);
                            String hostname = newProfile.getHost();
                            this.hostnameToTaskTracker.get(hostname).remove(trackerName);
                            continue;
                        }
                        this.trackerExpiryQueue.add(newProfile);
                    }
                }
            }
        }
    }

    private void removeTracker(TaskTracker tracker) {
        this.lostTaskTracker(tracker);
        String trackerName = tracker.getStatus().getTrackerName();
        if (this.isBlacklisted(trackerName)) {
            this.faultyTrackers.decrBlackListedTrackers(1);
        }
        this.updateTaskTrackerStatus(trackerName, null);
        this.statistics.taskTrackerRemoved(trackerName);
        this.getInstrumentation().decTrackers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void retireJob(JobID jobid, String historyFile) {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                org.apache.hadoop.mapred.JobStatus status = job.getStatus();
                if (historyFile != null) {
                    status.setHistoryFile(historyFile);
                }
                job.cleanupLocalizedJobConf(job.getProfile().getJobID());
                boolean retireJob = this.conf.getBoolean("mapreduce.jobtracker.retirejobs", true);
                if (retireJob) {
                    this.removeJobTasks(job);
                    this.jobs.remove(job.getProfile().getJobID());
                    for (JobInProgressListener l : this.jobInProgressListeners) {
                        l.jobRemoved(job);
                    }
                    String jobUser = job.getProfile().getUser();
                    LOG.info((Object)("Retired job with id: '" + job.getProfile().getJobID() + "' of user '" + jobUser + "'"));
                    this.retireJobs.addToCache(job.getStatus());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerStatus> getStatusesOnHost(String hostName) {
        ArrayList<TaskTrackerStatus> statuses = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!hostName.equals(status.getHost())) continue;
                statuses.add(status);
            }
        }
        return statuses;
    }

    JobTracker() {
        this.hostsReader = null;
        this.retiredJobsCacheSize = 0;
        this.infoServer = null;
        this.queueManager = null;
        this.aclsManager = null;
        this.taskScheduler = null;
        this.trackerIdentifier = null;
        this.recoveryManager = null;
        this.jobHistory = null;
        this.completedJobStatusStore = null;
        this.tasktrackerExpiryInterval = 0L;
        this.myInstrumentation = new JobTrackerMetricsInst(this, new JobConf());
        this.secretManager = null;
        this.localFs = null;
    }

    JobTracker(JobConf conf) throws IOException, InterruptedException {
        this(conf, new Clock());
    }

    JobTracker(JobConf conf, Clock clock) throws IOException, InterruptedException {
        this(conf, clock, JobTracker.generateNewIdentifier());
    }

    JobTracker(final JobConf conf, Clock newClock, String jobtrackerIndentifier) throws IOException, InterruptedException {
        JobTrackerInstrumentation tmp;
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobtracker.keytab.file", (String)"mapreduce.jobtracker.kerberos.principal", (String)this.localMachine);
        clock = newClock;
        long secretKeyInterval = conf.getLong("mapreduce.cluster.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("mapreduce.cluster.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("mapreduce.cluster.delegation.token.renew-interval", 86400000L);
        this.secretManager = new DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
        this.secretManager.startThreads();
        this.tasktrackerExpiryInterval = conf.getLong("mapreduce.jobtracker.expire.trackers.interval", 600000L);
        this.retiredJobsCacheSize = conf.getInt("mapreduce.jobtracker.retiredjobs.cache.size", 1000);
        this.MAX_BLACKLISTS_PER_TRACKER = conf.getInt("mapreduce.jobtracker.tasktracker.maxblacklists", 4);
        this.NUM_HEARTBEATS_IN_SECOND = conf.getInt("mapreduce.jobtracker.heartbeats.in.second", 100);
        if (this.NUM_HEARTBEATS_IN_SECOND < 1) {
            this.NUM_HEARTBEATS_IN_SECOND = 100;
        }
        this.HEARTBEATS_SCALING_FACTOR = conf.getFloat("mapreduce.jobtracker.heartbeats.scaling.factor", 1.0f);
        if (this.HEARTBEATS_SCALING_FACTOR < 0.01f) {
            this.HEARTBEATS_SCALING_FACTOR = 1.0f;
        }
        this.AVERAGE_BLACKLIST_THRESHOLD = conf.getFloat("mapreduce.jobtracker.blacklist.average.threshold", 0.5f);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.initializeTaskMemoryRelatedConfig();
        this.hostsReader = new HostsFileReader(conf.get("mapreduce.jobtracker.hosts.filename", ""), conf.get("mapreduce.jobtracker.hosts.exclude.filename", ""));
        Configuration clusterConf = new Configuration((Configuration)this.conf);
        this.queueManager = new QueueManager(clusterConf);
        this.aclsManager = new ACLsManager(conf, new JobACLsManager(conf), this.queueManager);
        LOG.info((Object)("Starting jobtracker with owner as " + this.getMROwner().getShortUserName()));
        Class schedulerClass = conf.getClass("mapreduce.jobtracker.taskscheduler", JobQueueTaskScheduler.class, TaskScheduler.class);
        this.taskScheduler = (TaskScheduler)ReflectionUtils.newInstance((Class)schedulerClass, (Configuration)conf);
        int handlerCount = conf.getInt("mapreduce.jobtracker.handler.count", 10);
        this.interTrackerServer = RPC.getServer(ClientProtocol.class, (Object)this, (String)addr.getHostName(), (int)addr.getPort(), (int)handlerCount, (boolean)false, (Configuration)conf, (SecretManager)this.secretManager);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.interTrackerServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)new MapReducePolicyProvider());
        }
        if (LOG.isDebugEnabled()) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Property '" + string + "' is " + val));
            }
        }
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)conf.get("mapreduce.jobtracker.http.address", "0.0.0.0:50030"));
        String infoBindAddress = infoSocAddr.getHostName();
        int n = infoSocAddr.getPort();
        this.startTime = clock.getTime();
        this.infoServer = new HttpServer("job", infoBindAddress, n, n == 0, (Configuration)conf, this.aclsManager.getAdminsAcl());
        this.infoServer.setAttribute("job.tracker", (Object)this);
        this.jobHistory = new JobHistory();
        this.jobHistory.init(this, conf, this.localMachine, this.startTime);
        this.infoServer.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.infoServer.start();
        this.trackerIdentifier = jobtrackerIndentifier;
        Class<? extends JobTrackerInstrumentation> metricsInst = JobTracker.getInstrumentationClass(jobConf);
        try {
            Constructor<? extends JobTrackerInstrumentation> c = metricsInst.getConstructor(JobTracker.class, JobConf.class);
            tmp = c.newInstance(new Object[]{this, jobConf});
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize job tracker metrics", (Throwable)e);
            tmp = new JobTrackerMetricsInst(this, jobConf);
        }
        this.myInstrumentation = tmp;
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapreduce.jobtracker.address", this.localMachine + ":" + this.port);
        this.localFs = FileSystem.getLocal((Configuration)conf);
        LOG.info((Object)("JobTracker up at: " + this.port));
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapreduce.jobtracker.http.address", infoBindAddress + ":" + this.infoPort);
        LOG.info((Object)("JobTracker webserver: " + this.infoServer.getPort()));
        this.recoveryManager = new RecoveryManager();
        while (!Thread.currentThread().isInterrupted()) {
            block25: {
                try {
                    FileStatus[] jobDirData;
                    if (this.fs == null) {
                        this.fs = (FileSystem)this.getMROwner().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                            @Override
                            public FileSystem run() throws IOException {
                                return FileSystem.get((Configuration)conf);
                            }
                        });
                    }
                    if (this.systemDir == null) {
                        this.systemDir = new Path(this.getSystemDir());
                    }
                    try {
                        FileStatus systemDirStatus = this.fs.getFileStatus(this.systemDir);
                        if (!systemDirStatus.getOwner().equals(this.getMROwner().getShortUserName())) {
                            throw new AccessControlException("The systemdir " + this.systemDir + " is not owned by " + this.getMROwner().getShortUserName());
                        }
                        if (!systemDirStatus.getPermission().equals((Object)SYSTEM_DIR_PERMISSION)) {
                            LOG.warn((Object)("Incorrect permissions on " + this.systemDir + ". Setting it to " + SYSTEM_DIR_PERMISSION));
                            this.fs.setPermission(this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                        }
                    }
                    catch (FileNotFoundException fnf) {
                        // empty catch block
                    }
                    try {
                        jobDirData = this.getJobFilesForRecovery(this.fs, this.systemDir);
                    }
                    catch (FileNotFoundException fnfe) {
                        jobDirData = null;
                    }
                    if (conf.getBoolean("mapreduce.jobtracker.restart.recover", false) && jobDirData != null) {
                        for (FileStatus status : jobDirData) {
                            try {
                                this.recoveryManager.addJobForRecovery(status);
                            }
                            catch (Throwable t) {
                                LOG.warn((Object)("Failed to add the job " + status.getPath().getName()), t);
                            }
                        }
                        if (this.recoveryManager.shouldRecover()) break;
                    }
                    if (!this.fs.exists(this.systemDir)) {
                        LOG.info((Object)"Creating the system directory");
                        if (FileSystem.mkdirs((FileSystem)this.fs, (Path)this.systemDir, (FsPermission)new FsPermission(SYSTEM_DIR_PERMISSION))) break;
                        LOG.error((Object)("Mkdirs failed to create " + this.systemDir));
                        break block25;
                    }
                    LOG.info((Object)"Cleaning up the system directory");
                    this.fs.setPermission(this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                    this.deleteContents(this.fs, this.systemDir);
                    break;
                }
                catch (AccessControlException ace) {
                    LOG.warn((Object)("Failed to operate on mapreduce.jobtracker.system.dir(" + this.systemDir.makeQualified(this.fs) + ") because of permissions."));
                    LOG.warn((Object)("This directory should exist and be owned by the user '" + UserGroupInformation.getCurrentUser() + "'"));
                    LOG.warn((Object)"Bailing out ... ");
                    throw ace;
                }
                catch (IOException ie) {
                    LOG.info((Object)("problem cleaning system directory: " + this.systemDir.makeQualified(this.fs)), (Throwable)ie);
                }
            }
            Thread.sleep(10000L);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        this.asyncDiskService = new MRAsyncDiskService((FileSystem)FileSystem.getLocal((Configuration)conf), conf.getLocalDirs());
        this.asyncDiskService.moveAndDeleteFromEachVolume(SUBDIR);
        this.jobHistory.initDone(conf, this.fs);
        final String historyLogDir = this.jobHistory.getCompletedJobHistoryLocation().toString();
        this.infoServer.setAttribute("historyLogDir", (Object)historyLogDir);
        FileSystem historyFS = (FileSystem)this.getMROwner().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return new Path(historyLogDir).getFileSystem((Configuration)conf);
            }
        });
        this.infoServer.setAttribute("fileSys", (Object)historyFS);
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)conf);
        this.numTaskCacheLevels = conf.getInt("mapreduce.jobtracker.taskcache.levels", 2);
        this.completedJobStatusStore = new CompletedJobStatusStore(conf, this.aclsManager);
    }

    FileStatus[] getJobFilesForRecovery(FileSystem fs, Path jobFolderPath) throws IOException {
        return fs.listStatus(jobFolderPath, new PathFilter(){

            public boolean accept(Path path) {
                return !path.getName().startsWith(JobTracker.this.recoveryManager.getRestartCountFile().getName());
            }
        });
    }

    private void deleteContents(FileSystem fs, Path dir) throws IOException {
        for (FileStatus stat : fs.listStatus(dir)) {
            if (fs.delete(stat.getPath(), true)) continue;
            throw new IOException("Unable to delete " + stat.getPath());
        }
    }

    private static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmm");
    }

    private static String generateNewIdentifier() {
        return JobTracker.getDateFormat().format(new Date());
    }

    static boolean validateIdentifier(String id) {
        try {
            JobTracker.getDateFormat().parse(id);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    static boolean validateJobNumber(String id) {
        try {
            Integer.parseInt(id);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean hasRecovered() {
        return this.hasRecovered;
    }

    public long getRecoveryDuration() {
        return this.recoveryDuration;
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    LocalFileSystem getLocalFileSystem() throws IOException {
        return this.localFs;
    }

    TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public static Class<? extends JobTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapreduce.jobtracker.instrumentation", JobTrackerMetricsInst.class, JobTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends JobTrackerInstrumentation> t) {
        conf.setClass("mapreduce.jobtracker.instrumentation", t, JobTrackerInstrumentation.class);
    }

    JobTrackerInstrumentation getInstrumentation() {
        return this.myInstrumentation;
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapreduce.jobtracker.address", "localhost:8012");
        return NetUtils.createSocketAddr((String)jobTrackerStr);
    }

    void startExpireTrackersThread() {
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws InterruptedException, IOException {
        while (true) {
            try {
                this.recoveryManager.updateRestartCount();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed to initialize recovery manager. ", (Throwable)ioe);
                Thread.sleep(10000L);
                LOG.warn((Object)"Retrying...");
                continue;
            }
            break;
        }
        this.taskScheduler.start();
        this.recoveryManager.recover();
        this.refreshHosts();
        this.startExpireTrackersThread();
        this.expireLaunchingTaskThread.start();
        if (this.completedJobStatusStore.isActive()) {
            this.completedJobsStoreThread = new Thread((Runnable)this.completedJobStatusStore, "completedjobsStore-housekeeper");
            this.completedJobsStoreThread.start();
        }
        this.interTrackerServer.start();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            this.state = State.RUNNING;
        }
        LOG.info((Object)"Starting RUNNING");
        this.interTrackerServer.join();
        LOG.info((Object)"Stopped interTrackerServer");
    }

    void close() throws IOException {
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception shutting down JobTracker", (Throwable)ex);
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info((Object)"Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        this.stopExpireTrackersThread();
        if (this.taskScheduler != null) {
            this.taskScheduler.terminate();
        }
        if (this.expireLaunchingTaskThread != null && this.expireLaunchingTaskThread.isAlive()) {
            LOG.info((Object)"Stopping expireLaunchingTasks");
            this.expireLaunchingTaskThread.interrupt();
            try {
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.completedJobsStoreThread != null && this.completedJobsStoreThread.isAlive()) {
            LOG.info((Object)"Stopping completedJobsStore thread");
            this.completedJobsStoreThread.interrupt();
            try {
                this.completedJobsStoreThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.jobHistory != null) {
            this.jobHistory.shutDown();
        }
        DelegationTokenRenewal.close();
        LOG.info((Object)"stopped all jobtracker services");
    }

    void stopExpireTrackersThread() {
        if (this.expireTrackersThread != null && this.expireTrackersThread.isAlive()) {
            LOG.info((Object)"Stopping expireTrackers");
            this.expireTrackersThread.interrupt();
            try {
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    void createTaskEntry(org.apache.hadoop.mapred.TaskAttemptID taskid, String taskTracker, TaskInProgress tip) {
        LOG.info((Object)("Adding task (" + (Object)((Object)tip.getAttemptType(taskid)) + ") " + "'" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'"));
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<org.apache.hadoop.mapred.TaskAttemptID> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<org.apache.hadoop.mapred.TaskAttemptID>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(org.apache.hadoop.mapred.TaskAttemptID taskid) {
        Set<org.apache.hadoop.mapred.TaskAttemptID> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        if (this.taskidToTIPMap.remove(taskid) != null) {
            LOG.info((Object)("Removing task '" + taskid + "'"));
        }
    }

    void markCompletedTaskAttempt(String taskTracker, org.apache.hadoop.mapred.TaskAttemptID taskid) {
        Set<org.apache.hadoop.mapred.TaskAttemptID> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<org.apache.hadoop.mapred.TaskAttemptID>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Marked '" + taskid + "' from '" + taskTracker + "'"));
        }
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getTasks(TaskType.JOB_SETUP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.MAP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.REDUCE)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
    }

    void removeMarkedTasks(String taskTracker) {
        Set<org.apache.hadoop.mapred.TaskAttemptID> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (org.apache.hadoop.mapred.TaskAttemptID taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Removed marked completed task '" + taskid + "' from '" + taskTracker + "'"));
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    synchronized void removeJobTasks(JobInProgress job) {
        for (TaskType type : TaskType.values()) {
            for (TaskInProgress tip : job.getTasks(type)) {
                for (org.apache.hadoop.mapred.TaskAttemptID id : tip.getAllTaskAttemptIDs()) {
                    this.removeTaskEntry(id);
                }
            }
        }
    }

    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        JobID id = job.getStatus().getJobID();
        try {
            this.jobHistory.markCompleted(id);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to mark job " + id + " as completed!"), (Throwable)ioe);
        }
        JobTrackerInstrumentation metrics = this.getInstrumentation();
        metrics.finalizeJob(this.conf, id);
        this.addJobForCleanup(id);
        if (job.getStatus().getRunState() == org.apache.hadoop.mapred.JobStatus.SUCCEEDED && job.getNoOfBlackListedTrackers() > 0) {
            for (String hostName : job.getBlackListedTrackers()) {
                this.faultyTrackers.incrementFaults(hostName);
            }
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public String getTrackerIdentifier() {
        return this.trackerIdentifier;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            org.apache.hadoop.mapred.JobStatus status = jip.getStatus();
            if (status.getRunState() != org.apache.hadoop.mapred.JobStatus.RUNNING) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            org.apache.hadoop.mapred.JobStatus status = jip.getStatus();
            if (status.getRunState() != org.apache.hadoop.mapred.JobStatus.FAILED && status.getRunState() != org.apache.hadoop.mapred.JobStatus.KILLED) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getFailedJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.failedJobs();
        }
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            org.apache.hadoop.mapred.JobStatus status = jip.getStatus();
            if (status.getRunState() != org.apache.hadoop.mapred.JobStatus.SUCCEEDED) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getCompletedJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.completedJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<TaskTrackerStatus> taskTrackers() {
        ArrayList<TaskTrackerStatus> ttStatuses;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            ttStatuses = new ArrayList<TaskTrackerStatus>(this.taskTrackers.values().size());
            for (TaskTracker tt : this.taskTrackers.values()) {
                ttStatuses.add(tt.getStatus());
            }
        }
        return ttStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<TaskTrackerStatus> activeTaskTrackers() {
        ArrayList<TaskTrackerStatus> activeTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                activeTrackers.add(status);
            }
        }
        return activeTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<List<String>> taskTrackerNames() {
        ArrayList<String> activeTrackers = new ArrayList<String>();
        ArrayList<String> blacklistedTrackers = new ArrayList<String>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                    activeTrackers.add(status.getTrackerName());
                    continue;
                }
                blacklistedTrackers.add(status.getTrackerName());
            }
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(2);
        result.add(activeTrackers);
        result.add(blacklistedTrackers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<TaskTrackerStatus> blacklistedTaskTrackers() {
        ArrayList<TaskTrackerStatus> blacklistedTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                blacklistedTrackers.add(status);
            }
        }
        return blacklistedTrackers;
    }

    synchronized int getFaultCount(String hostName) {
        return this.faultyTrackers.getFaultCount(hostName);
    }

    int getBlacklistedTrackerCount() {
        return this.faultyTrackers.numBlacklistedTrackers;
    }

    public synchronized boolean isBlacklisted(String trackerID) {
        TaskTrackerStatus status = this.getTaskTrackerStatus(trackerID);
        if (status != null) {
            return this.faultyTrackers.isBlacklisted(status.getHost());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTrackerStatus getTaskTrackerStatus(String trackerID) {
        TaskTracker taskTracker;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            taskTracker = this.taskTrackers.get(trackerID);
        }
        return taskTracker == null ? null : taskTracker.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTracker getTaskTracker(String trackerID) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    JobTrackerStatistics getStatistics() {
        return this.statistics;
    }

    void addNewTracker(TaskTracker taskTracker) {
        Set<TaskTracker> trackers;
        TaskTrackerStatus status = taskTracker.getStatus();
        this.trackerExpiryQueue.add(status);
        String hostname = status.getHost();
        if (this.getNode(status.getTrackerName()) == null) {
            this.resolveAndAddToTopology(hostname);
        }
        if ((trackers = this.hostnameToTaskTracker.get(hostname)) == null) {
            trackers = Collections.synchronizedSet(new HashSet());
            this.hostnameToTaskTracker.put(hostname, trackers);
        }
        this.statistics.taskTrackerAdded(status.getTrackerName());
        this.getInstrumentation().addTrackers(1);
        LOG.info((Object)("Adding tracker " + status.getTrackerName() + " to host " + hostname));
        trackers.add(taskTracker);
    }

    public Node resolveAndAddToTopology(String name) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(name);
        List rNameList = this.dnsToSwitchMapping.resolve(tmpList);
        String rName = (String)rNameList.get(0);
        String networkLoc = NodeBase.normalize((String)rName);
        return this.addHostToNodeMapping(name, networkLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node addHostToNodeMapping(String host, String networkLoc) {
        Node node = null;
        Set<Node> set = this.nodesAtMaxLevel;
        synchronized (set) {
            node = this.clusterMap.getNode(networkLoc + "/" + host);
            if (node == null) {
                node = new NodeBase(host, networkLoc);
                this.clusterMap.add(node);
                if (node.getLevel() < this.getNumTaskCacheLevels()) {
                    LOG.fatal((Object)("Got a host whose level is: " + node.getLevel() + "." + " Should get at least a level of value: " + this.getNumTaskCacheLevels()));
                    try {
                        this.stopTracker();
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Exception encountered during shutdown: " + StringUtils.stringifyException((Throwable)ie)));
                        System.exit(-1);
                    }
                }
                this.hostnameToNodeMap.put(host, node);
                this.nodesAtMaxLevel.add(JobTracker.getParentNode(node, this.getNumTaskCacheLevels() - 1));
            }
        }
        return node;
    }

    public Collection<Node> getNodesAtMaxLevel() {
        return this.nodesAtMaxLevel;
    }

    public static Node getParentNode(Node node, int level) {
        for (int i = 0; i < level; ++i) {
            node = node.getParent();
        }
        return node;
    }

    public Node getNode(String name) {
        return this.hostnameToNodeMap.get(name);
    }

    public int getNumTaskCacheLevels() {
        return this.numTaskCacheLevels;
    }

    public int getNumResolvedTaskTrackers() {
        return this.numResolved;
    }

    @Override
    public int getNumberOfUniqueHosts() {
        return this.uniqueHostsMap.size();
    }

    @Override
    public void addJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.add(listener);
    }

    @Override
    public void removeJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.remove(listener);
    }

    void updateJobInProgressListeners(JobChangeEvent event) {
        for (JobInProgressListener listener : this.jobInProgressListeners) {
            listener.jobUpdated(event);
        }
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public String getBuildVersion() throws IOException {
        return VersionInfo.getBuildVersion();
    }

    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean restarted, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> commitTasksList;
        List<TaskTrackerAction> killJobsList;
        List<TaskTrackerAction> killTasksList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got heartbeat from: " + status.getTrackerName() + " (restarted: " + restarted + " initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId));
        }
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        long now = clock.getTime();
        boolean isBlacklisted = false;
        if (restarted) {
            this.faultyTrackers.markTrackerHealthy(status.getHost());
        } else {
            isBlacklisted = this.faultyTrackers.shouldAssignTasksToTracker(status.getHost(), now);
        }
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                LOG.warn((Object)("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker"));
                return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
            }
            if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info((Object)("Ignoring 'duplicate' heartbeat from '" + trackerName + "'; resending the previous 'lost' response"));
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        status.setLastSeen(now);
        if (!this.processHeartbeat(status, initialContact)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        isBlacklisted = this.faultyTrackers.isBlacklisted(status.getHost());
        if (acceptNewTasks && !isBlacklisted) {
            TaskTrackerStatus taskTrackerStatus = this.getTaskTrackerStatus(trackerName);
            if (taskTrackerStatus == null) {
                LOG.warn((Object)("Unknown task tracker polling; ignoring: " + trackerName));
            } else {
                List<Task> tasks = this.getSetupAndCleanupTasks(taskTrackerStatus);
                if (tasks == null) {
                    tasks = this.taskScheduler.assignTasks(this.taskTrackers.get(trackerName));
                }
                if (tasks != null) {
                    for (Task task : tasks) {
                        this.expireLaunchingTasks.addNewTask(task.getTaskID());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(trackerName + " -> LaunchTask: " + task.getTaskID()));
                        }
                        actions.add(new LaunchTaskAction(task));
                    }
                }
            }
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        if ((killJobsList = this.getJobsForCleanup(trackerName)) != null) {
            actions.addAll(killJobsList);
        }
        if ((commitTasksList = this.getTasksToSave(status)) != null) {
            actions.addAll(commitTasksList);
        }
        int nextInterval = this.getNextHeartbeatInterval();
        response.setHeartbeatInterval(nextInterval);
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    @Override
    public int getNextHeartbeatInterval() {
        int clusterSize = this.getClusterStatus().getTaskTrackers();
        int heartbeatInterval = Math.max((int)((double)(1000.0f * this.HEARTBEATS_SCALING_FACTOR) * Math.ceil((double)clusterSize / (double)this.NUM_HEARTBEATS_IN_SECOND)), 3000);
        return heartbeatInterval;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        int reduceSlots2;
        int mapSlots;
        TaskTrackerStatus oldStatus;
        TaskTracker tt = this.getTaskTracker(trackerName);
        TaskTrackerStatus taskTrackerStatus = oldStatus = tt == null ? null : tt.getStatus();
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            this.occupiedMapSlots -= oldStatus.countOccupiedMapSlots();
            this.occupiedReduceSlots -= oldStatus.countOccupiedReduceSlots();
            this.getInstrumentation().decRunningMaps(oldStatus.countMapTasks());
            this.getInstrumentation().decRunningReduces(oldStatus.countReduceTasks());
            this.getInstrumentation().decOccupiedMapSlots(oldStatus.countOccupiedMapSlots());
            this.getInstrumentation().decOccupiedReduceSlots(oldStatus.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(oldStatus.getHost())) {
                mapSlots = oldStatus.getMaxMapSlots();
                this.totalMapTaskCapacity -= mapSlots;
                reduceSlots2 = oldStatus.getMaxReduceSlots();
                this.totalReduceTaskCapacity -= reduceSlots2;
            }
            if (status == null) {
                this.taskTrackers.remove(trackerName);
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(oldStatus.getHost());
                if (numTaskTrackersInHost != null) {
                    Integer reduceSlots2 = numTaskTrackersInHost;
                    Integer n = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost - 1);
                    if (numTaskTrackersInHost > 0) {
                        this.uniqueHostsMap.put(oldStatus.getHost(), numTaskTrackersInHost);
                    } else {
                        this.uniqueHostsMap.remove(oldStatus.getHost());
                    }
                }
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            this.occupiedMapSlots += status.countOccupiedMapSlots();
            this.occupiedReduceSlots += status.countOccupiedReduceSlots();
            this.getInstrumentation().addRunningMaps(status.countMapTasks());
            this.getInstrumentation().addRunningReduces(status.countReduceTasks());
            this.getInstrumentation().addOccupiedMapSlots(status.countOccupiedMapSlots());
            this.getInstrumentation().addOccupiedReduceSlots(status.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                mapSlots = status.getMaxMapSlots();
                this.totalMapTaskCapacity += mapSlots;
                reduceSlots2 = status.getMaxReduceSlots();
                this.totalReduceTaskCapacity += reduceSlots2;
            }
            boolean alreadyPresent = false;
            TaskTracker taskTracker = this.taskTrackers.get(trackerName);
            if (taskTracker != null) {
                alreadyPresent = true;
            } else {
                taskTracker = new TaskTracker(trackerName);
            }
            taskTracker.setStatus(status);
            this.taskTrackers.put(trackerName, taskTracker);
            if (LOG.isDebugEnabled()) {
                int runningMaps = 0;
                int runningReduces = 0;
                int commitPendingMaps = 0;
                int commitPendingReduces = 0;
                int unassignedMaps = 0;
                int unassignedReduces = 0;
                int miscMaps = 0;
                int miscReduces = 0;
                List<TaskStatus> taskReports = status.getTaskReports();
                for (TaskStatus ts : taskReports) {
                    boolean isMap = ts.getIsMap();
                    TaskStatus.State state = ts.getRunState();
                    if (state == TaskStatus.State.RUNNING) {
                        if (isMap) {
                            ++runningMaps;
                            continue;
                        }
                        ++runningReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.UNASSIGNED) {
                        if (isMap) {
                            ++unassignedMaps;
                            continue;
                        }
                        ++unassignedReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.COMMIT_PENDING) {
                        if (isMap) {
                            ++commitPendingMaps;
                            continue;
                        }
                        ++commitPendingReduces;
                        continue;
                    }
                    if (isMap) {
                        ++miscMaps;
                        continue;
                    }
                    ++miscReduces;
                }
                LOG.debug((Object)(trackerName + ": Status -" + " running(m) = " + runningMaps + " unassigned(m) = " + unassignedMaps + " commit_pending(m) = " + commitPendingMaps + " misc(m) = " + miscMaps + " running(r) = " + runningReduces + " unassigned(r) = " + unassignedReduces + " commit_pending(r) = " + commitPendingReduces + " misc(r) = " + miscReduces));
            }
            if (!alreadyPresent) {
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(status.getHost());
                if (numTaskTrackersInHost == null) {
                    numTaskTrackersInHost = 0;
                }
                Integer n = numTaskTrackersInHost;
                Integer n2 = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost + 1);
                this.uniqueHostsMap.put(status.getHost(), numTaskTrackersInHost);
            }
        }
        this.getInstrumentation().setMapSlots(this.totalMapTaskCapacity);
        this.getInstrumentation().setReduceSlots(this.totalReduceTaskCapacity);
        return oldStatus != null;
    }

    void incrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots += reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots += reservedSlots;
        }
    }

    void decrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots -= reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots -= reservedSlots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeHealthStatus(TaskTrackerStatus trackerStatus) {
        TaskTrackerStatus.TaskTrackerHealthStatus status = trackerStatus.getHealthStatus();
        FaultyTrackersInfo faultyTrackersInfo = this.faultyTrackers;
        synchronized (faultyTrackersInfo) {
            this.faultyTrackers.setNodeHealthStatus(trackerStatus.getHost(), status.isNodeHealthy(), status.getHealthReport());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact) {
        this.getInstrumentation().heartbeat();
        String trackerName = trackerStatus.getTrackerName();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                TaskTracker taskTracker = this.getTaskTracker(trackerName);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(taskTracker);
                    }
                } else if (!seenBefore) {
                    LOG.warn((Object)("Status from unknown Tracker : " + trackerName));
                    this.updateTaskTrackerStatus(trackerName, null);
                    return false;
                }
                if (initialContact) {
                    if (this.isBlacklisted(trackerName)) {
                        this.faultyTrackers.incrBlackListedTrackers(1);
                    }
                    this.addNewTracker(taskTracker);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        this.updateNodeHealthStatus(trackerStatus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<org.apache.hadoop.mapred.TaskAttemptID> taskIds = this.trackerToTaskMap.get(taskTracker);
        ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
        if (taskIds != null) {
            for (org.apache.hadoop.mapred.TaskAttemptID killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (tip == null || !tip.shouldClose(killTaskId) || tip.getJob().isComplete()) continue;
                killList.add(new KillTaskAction(killTaskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(taskTracker + " -> KillTaskAction: " + killTaskId));
            }
        }
        Map<String, Set<org.apache.hadoop.mapred.TaskAttemptID>> map = this.trackerToTasksToCleanup;
        synchronized (map) {
            Set<org.apache.hadoop.mapred.TaskAttemptID> set = this.trackerToTasksToCleanup.remove(taskTracker);
            if (set != null) {
                for (org.apache.hadoop.mapred.TaskAttemptID id : set) {
                    killList.add(new KillTaskAction(id));
                }
            }
        }
        return killList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJobForCleanup(JobID id) {
        for (String taskTracker : this.taskTrackers.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Marking job " + id + " for cleanup by tracker " + taskTracker));
            }
            Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
            synchronized (map) {
                Set<JobID> jobsToKill = this.trackerToJobsToCleanup.get(taskTracker);
                if (jobsToKill == null) {
                    jobsToKill = new HashSet<JobID>();
                    this.trackerToJobsToCleanup.put(taskTracker, jobsToKill);
                }
                jobsToKill.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerAction> getJobsForCleanup(String taskTracker) {
        Set<JobID> jobs = null;
        Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            jobs = this.trackerToJobsToCleanup.remove(taskTracker);
        }
        if (jobs != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            for (JobID killJobId : jobs) {
                killList.add(new KillJobAction(killJobId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(taskTracker + " -> KillJobAction: " + killJobId));
            }
            return killList;
        }
        return null;
    }

    synchronized List<TaskTrackerAction> getTasksToSave(TaskTrackerStatus tts) {
        List<TaskStatus> taskStatuses = tts.getTaskReports();
        if (taskStatuses != null) {
            ArrayList<TaskTrackerAction> saveList = new ArrayList<TaskTrackerAction>();
            for (TaskStatus taskStatus : taskStatuses) {
                org.apache.hadoop.mapred.TaskAttemptID taskId;
                TaskInProgress tip;
                if (taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING || (tip = this.taskidToTIPMap.get(taskId = taskStatus.getTaskID())) == null || !tip.shouldCommit(taskId)) continue;
                saveList.add(new CommitTaskAction(taskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(tts.getTrackerName() + " -> CommitTaskAction: " + taskId));
            }
            return saveList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<Task> getSetupAndCleanupTasks(TaskTrackerStatus taskTracker) throws IOException {
        int maxMapTasks = taskTracker.getMaxMapSlots();
        int maxReduceTasks = taskTracker.getMaxReduceSlots();
        int numMaps = taskTracker.countOccupiedMapSlots();
        int numReduces = taskTracker.countOccupiedReduceSlots();
        int numTaskTrackers = this.getClusterStatus().getTaskTrackers();
        int numUniqueHosts = this.getNumberOfUniqueHosts();
        Task t = null;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            if (numMaps < maxMapTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
            if (numReduces < maxReduceTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        if (this.fs == null) {
            throw new IllegalStateException("FileSystem object not available yet");
        }
        return this.fs.getUri().toString();
    }

    public JobConf getConf() {
        return this.conf;
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn((Object)("Report from " + taskTracker + ": " + errorMessage));
    }

    static String getJobUniqueString(String jobid) {
        return jobid.substring(4);
    }

    @Deprecated
    public JobID getNewJobId() throws IOException {
        return JobID.downgrade(this.getNewJobID());
    }

    @Override
    public org.apache.hadoop.mapreduce.JobID getNewJobID() throws IOException {
        return new org.apache.hadoop.mapreduce.JobID(this.getTrackerIdentifier(), this.nextJobId.getAndIncrement());
    }

    @Override
    public synchronized JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobId, String jobSubmitDir, Credentials ts) throws IOException, InterruptedException {
        return this.submitJob(JobID.downgrade(jobId), jobSubmitDir, ts);
    }

    @Deprecated
    public org.apache.hadoop.mapred.JobStatus submitJob(JobID jobId, String jobSubmitDir, Credentials ts) throws IOException, InterruptedException {
        return this.submitJob(jobId, 0, UserGroupInformation.getCurrentUser(), jobSubmitDir, false, ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.hadoop.mapred.JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobID, int restartCount, UserGroupInformation ugi, String jobSubmitDir, boolean recovered, Credentials ts) throws IOException, InterruptedException {
        JobInfo jobInfo;
        JobID jobId = null;
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            jobId = JobID.downgrade(jobID);
            if (this.jobs.containsKey(jobId)) {
                return this.jobs.get(jobId).getStatus();
            }
            jobInfo = new JobInfo(jobId, new Text(ugi.getShortUserName()), new Path(jobSubmitDir));
        }
        JobInProgress job = new JobInProgress(this, this.conf, restartCount, jobInfo, ts);
        JobTracker jobTracker2 = this;
        synchronized (jobTracker2) {
            try {
                this.checkQueueValidity(job);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Queue given for job " + job.getJobID() + " is not valid: " + ioe));
                throw ioe;
            }
            try {
                this.aclsManager.checkAccess(job, ugi, Operation.SUBMIT_JOB);
            }
            catch (AccessControlException ace) {
                LOG.warn((Object)("Access denied for user " + job.getJobConf().getUser() + ". Ignoring job " + jobId), (Throwable)ace);
                throw ace;
            }
            this.checkMemoryRequirements(job);
            if (!recovered) {
                Path jobDir = this.getSystemDirectoryForJob(jobId);
                FileSystem.mkdirs((FileSystem)this.fs, (Path)jobDir, (FsPermission)new FsPermission(SYSTEM_DIR_PERMISSION));
                FSDataOutputStream out = this.fs.create(this.getSystemFileForJob(jobId));
                jobInfo.write((DataOutput)out);
                out.close();
            }
            return this.addJob(jobId, job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized org.apache.hadoop.mapred.JobStatus addJob(JobID jobId, JobInProgress job) {
        ++this.totalSubmissions;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                this.jobs.put(job.getProfile().getJobID(), job);
                for (JobInProgressListener listener : this.jobInProgressListeners) {
                    try {
                        listener.jobAdded(job);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Failed to add and so skipping the job : " + job.getJobID() + ". Exception : " + ioe));
                    }
                }
            }
        }
        this.myInstrumentation.submitJob(job.getJobConf(), jobId);
        LOG.info((Object)("Job " + jobId + " added successfully for user '" + job.getJobConf().getUser() + "' to queue '" + job.getJobConf().getQueueName() + "'"));
        return job.getStatus();
    }

    public void checkQueueValidity(JobInProgress job) throws IOException {
        String queue = job.getProfile().getQueueName();
        if (!this.queueManager.getLeafQueueNames().contains(queue)) {
            throw new IOException("Queue \"" + queue + "\" does not exist");
        }
        if (!this.queueManager.isRunning(queue)) {
            throw new IOException("Queue \"" + queue + "\" is not running");
        }
    }

    boolean areACLsEnabled() {
        return this.conf.getBoolean("mapreduce.cluster.acls.enabled", false);
    }

    @Override
    @Deprecated
    public synchronized ClusterStatus getClusterStatus() {
        return this.getClusterStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ClusterStatus getClusterStatus(boolean detailed) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            if (detailed) {
                List<List<String>> trackerNames = this.taskTrackerNames();
                Collection<ClusterStatus.BlackListInfo> blackListedTrackers = this.getBlackListedTrackers();
                return new ClusterStatus((Collection<String>)trackerNames.get(0), blackListedTrackers, this.tasktrackerExpiryInterval, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
            }
            return new ClusterStatus(this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), this.tasktrackerExpiryInterval, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
        }
    }

    @Override
    public synchronized ClusterMetrics getClusterMetrics() {
        return new ClusterMetrics(this.totalMaps, this.totalReduces, this.occupiedMapSlots, this.occupiedReduceSlots, this.reservedMapSlots, this.reservedReduceSlots, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.totalSubmissions, this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), this.getExcludedNodes().size());
    }

    @Override
    @Deprecated
    public org.apache.hadoop.mapreduce.server.jobtracker.State getJobTrackerState() {
        return org.apache.hadoop.mapreduce.server.jobtracker.State.valueOf(this.state.name());
    }

    @Override
    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.valueOf(this.state.name());
    }

    @Override
    public long getTaskTrackerExpiryInterval() {
        return this.tasktrackerExpiryInterval;
    }

    @Override
    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        List<String> activeTrackers = this.taskTrackerNames().get(0);
        TaskTrackerInfo[] info = new TaskTrackerInfo[activeTrackers.size()];
        for (int i = 0; i < activeTrackers.size(); ++i) {
            info[i] = new TaskTrackerInfo(activeTrackers.get(i));
        }
        return info;
    }

    @Override
    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        Collection<ClusterStatus.BlackListInfo> blackListed = this.getBlackListedTrackers();
        TaskTrackerInfo[] info = new TaskTrackerInfo[blackListed.size()];
        int i = 0;
        for (ClusterStatus.BlackListInfo binfo : blackListed) {
            info[i++] = new TaskTrackerInfo(binfo.getTrackerName(), binfo.getReasonForBlackListing(), binfo.getBlackListReport());
        }
        return info;
    }

    @Override
    public synchronized void killJob(org.apache.hadoop.mapreduce.JobID jobid) throws IOException {
        this.killJob(JobID.downgrade(jobid));
    }

    @Override
    @Deprecated
    public synchronized void killJob(JobID jobid) throws IOException {
        if (null == jobid) {
            LOG.info((Object)"Null jobid object sent to JobTracker.killJob()");
            return;
        }
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("killJob(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.KILL_JOB);
        this.killJob(job);
    }

    private synchronized void killJob(JobInProgress job) {
        LOG.info((Object)("Killing job " + job.getJobID()));
        org.apache.hadoop.mapred.JobStatus prevStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
        job.kill();
        org.apache.hadoop.mapred.JobStatus newStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState() && newStatus.getRunState() == org.apache.hadoop.mapred.JobStatus.KILLED) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initJob(JobInProgress job) {
        block10: {
            if (null == job) {
                LOG.info((Object)"Init on null job is not valid");
                return;
            }
            try {
                org.apache.hadoop.mapred.JobStatus prevStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                LOG.info((Object)("Initializing " + job.getJobID()));
                job.initTasks();
                if (job.isJobEmpty()) {
                    this.completeEmptyJob(job);
                } else if (!job.isSetupCleanupRequired()) {
                    job.completeSetup();
                }
                org.apache.hadoop.mapred.JobStatus newStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() == newStatus.getRunState()) break block10;
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                JobTracker jobTracker = this;
                synchronized (jobTracker) {
                    this.updateJobInProgressListeners(event);
                }
            }
            catch (JobInProgress.KillInterruptedException kie) {
                LOG.error((Object)("Job initialization interrupted :\n" + StringUtils.stringifyException((Throwable)kie)));
                this.killJob(job);
            }
            catch (Throwable t) {
                LOG.error((Object)("Job initialization failed:\n" + StringUtils.stringifyException((Throwable)t)));
                this.failJob(job);
            }
        }
    }

    private synchronized void completeEmptyJob(JobInProgress job) {
        job.completeEmptyJob();
    }

    @Override
    public synchronized void failJob(JobInProgress job) {
        if (null == job) {
            LOG.info((Object)"Fail on null job is not valid");
            return;
        }
        org.apache.hadoop.mapred.JobStatus prevStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
        LOG.info((Object)("Failing job " + job.getJobID()));
        job.fail();
        org.apache.hadoop.mapred.JobStatus newStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState()) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public synchronized void setJobPriority(org.apache.hadoop.mapreduce.JobID jobid, String priority) throws IOException {
        this.setJobPriority(JobID.downgrade(jobid), priority);
    }

    @Deprecated
    public synchronized void setJobPriority(JobID jobid, String priority) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("setJobPriority(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        JobPriority newPriority = JobPriority.valueOf(priority);
        this.setJobPriority(jobid, newPriority);
    }

    void storeCompletedJob(JobInProgress job) {
        this.completedJobStatusStore.store(job);
    }

    public JobProfile getJobProfile(org.apache.hadoop.mapreduce.JobID jobid) {
        return this.getJobProfile(JobID.downgrade(jobid));
    }

    private boolean isJobInited(JobInProgress job) {
        return job.inited();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public JobProfile getJobProfile(JobID jobid) {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getProfile();
            }
        }
        return this.completedJobStatusStore.readJobProfile(jobid);
    }

    @Override
    public org.apache.hadoop.mapred.JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID jobid) {
        return this.getJobStatus(JobID.downgrade(jobid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public org.apache.hadoop.mapred.JobStatus getJobStatus(JobID jobid) {
        if (null == jobid) {
            LOG.warn((Object)"JobTracker.getJobStatus() cannot get status for null jobid");
            return null;
        }
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getStatus();
            }
            org.apache.hadoop.mapred.JobStatus status = this.retireJobs.get(jobid);
            if (status != null) {
                return status;
            }
        }
        return this.completedJobStatusStore.readJobStatus(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID jobid) throws AccessControlException, IOException {
        org.apache.hadoop.mapred.Counters counters;
        JobInProgress job;
        JobID oldJobID = JobID.downgrade(jobid);
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            job = this.jobs.get(oldJobID);
        }
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_COUNTERS);
            if (!this.isJobInited(job)) {
                return EMPTY_COUNTERS;
            }
            counters = job.getCounters();
            if (counters != null) {
                return new Counters(counters);
            }
            return null;
        }
        counters = this.completedJobStatusStore.readCounters(oldJobID);
        if (counters != null) {
            return new Counters(counters);
        }
        return null;
    }

    @Deprecated
    public org.apache.hadoop.mapred.Counters getJobCounters(JobID jobid) {
        try {
            return org.apache.hadoop.mapred.Counters.downgrade(this.getJobCounters((org.apache.hadoop.mapreduce.JobID)jobid));
        }
        catch (AccessControlException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Deprecated
    public synchronized TaskReport[] getMapTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Deprecated
    public synchronized TaskReport[] getReduceTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Deprecated
    public synchronized TaskReport[] getCleanupTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportCleanupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportCleanupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Deprecated
    public synchronized TaskReport[] getSetupTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportSetupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportSetupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    public synchronized TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID jobid, TaskType type) throws AccessControlException, IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return EMPTY_TASK_REPORTS;
        }
        this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        switch (type) {
            case MAP: {
                return this.getMapTaskReports(JobID.downgrade(jobid));
            }
            case REDUCE: {
                return this.getReduceTaskReports(JobID.downgrade(jobid));
            }
            case JOB_CLEANUP: {
                return this.getCleanupTaskReports(JobID.downgrade(jobid));
            }
            case JOB_SETUP: {
                return this.getSetupTaskReports(JobID.downgrade(jobid));
            }
        }
        return EMPTY_TASK_REPORTS;
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return this.getTaskCompletionEvents(JobID.downgrade(jobid), fromEventId, maxEvents);
    }

    @Override
    @Deprecated
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (null != job) {
            return job.inited() ? job.getTaskCompletionEvents(fromEventId, maxEvents) : TaskCompletionEvent.EMPTY_ARRAY;
        }
        return this.completedJobStatusStore.readJobTaskCompletionEvents(jobid, fromEventId, maxEvents);
    }

    @Override
    public synchronized String[] getTaskDiagnostics(TaskAttemptID taskId) throws IOException {
        return this.getTaskDiagnostics(org.apache.hadoop.mapred.TaskAttemptID.downgrade(taskId));
    }

    @Deprecated
    public synchronized String[] getTaskDiagnostics(org.apache.hadoop.mapred.TaskAttemptID taskId) throws IOException {
        List<String> taskDiagnosticInfo = null;
        JobID jobId = taskId.getJobID();
        TaskID tipId = taskId.getTaskID();
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            TaskInProgress tip;
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
            if (this.isJobInited(job) && (tip = job.getTaskInProgress(tipId)) != null) {
                taskDiagnosticInfo = tip.getDiagnosticInfo(taskId);
            }
        }
        return taskDiagnosticInfo == null ? EMPTY_TASK_DIAGNOSTICS : taskDiagnosticInfo.toArray(new String[taskDiagnosticInfo.size()]);
    }

    TaskStatus[] getTaskStatuses(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(org.apache.hadoop.mapred.TaskAttemptID taskid) {
        TaskInProgress tip = this.getTip(taskid.getTaskID());
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    org.apache.hadoop.mapred.Counters getTipCounters(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? null : tip.getCounters();
    }

    TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public TaskInProgress getTip(TaskID tipid) {
        JobInProgress job = this.jobs.get(tipid.getJobID());
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    @Override
    public synchronized boolean killTask(TaskAttemptID taskid, boolean shouldFail) throws IOException {
        return this.killTask(org.apache.hadoop.mapred.TaskAttemptID.downgrade(taskid), shouldFail);
    }

    @Override
    @Deprecated
    public synchronized boolean killTask(org.apache.hadoop.mapred.TaskAttemptID taskid, boolean shouldFail) throws IOException {
        TaskInProgress tip = this.taskidToTIPMap.get(taskid);
        if (tip != null) {
            this.aclsManager.checkAccess(tip.getJob(), UserGroupInformation.getCurrentUser(), shouldFail ? Operation.FAIL_TASK : Operation.KILL_TASK);
            return tip.killTask(taskid, shouldFail);
        }
        LOG.info((Object)("Kill task attempt failed since task " + taskid + " was not found"));
        return false;
    }

    public synchronized String getAssignedTracker(org.apache.hadoop.mapred.TaskAttemptID taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    public org.apache.hadoop.mapred.JobStatus[] jobsToComplete() {
        return this.getJobStatus(this.jobs.values(), true);
    }

    @Override
    public JobStatus[] getAllJobs() {
        ArrayList<org.apache.hadoop.mapred.JobStatus> list = new ArrayList<org.apache.hadoop.mapred.JobStatus>();
        list.addAll(Arrays.asList(this.getJobStatus(this.jobs.values(), false)));
        list.addAll(this.retireJobs.getAll());
        return list.toArray(new org.apache.hadoop.mapred.JobStatus[list.size()]);
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        try {
            final String user = UserGroupInformation.getCurrentUser().getShortUserName();
            return (String)this.getMROwner().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    Path stagingRootDir = new Path(JobTracker.this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
                    FileSystem fs = stagingRootDir.getFileSystem((Configuration)JobTracker.this.conf);
                    return fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Override
    public String getJobHistoryDir() {
        return this.jobHistory.getCompletedJobHistoryLocation().toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        AccessControlList acl = this.queueManager.getQueueACL(queueName, QueueACL.ADMINISTER_JOBS);
        if (acl == null) {
            acl = new AccessControlList(" ");
        }
        return acl;
    }

    @Override
    public JobInProgress getJob(JobID jobid) {
        return this.jobs.get(jobid);
    }

    Path getSystemDirectoryForJob(JobID id) {
        return new Path(this.getSystemDir(), id.toString());
    }

    Path getSystemFileForJob(JobID id) {
        return new Path(this.getSystemDirectoryForJob(id) + "/" + JOB_INFO_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setJobPriority(JobID jobId, JobPriority priority) throws AccessControlException, IOException {
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.SET_JOB_PRIORITY);
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                org.apache.hadoop.mapred.JobStatus oldStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                job.setPriority(priority);
                org.apache.hadoop.mapred.JobStatus newStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.PRIORITY_CHANGED, oldStatus, newStatus);
                this.updateJobInProgressListeners(event);
            }
        } else {
            LOG.warn((Object)("Trying to change the priority of an unknown job: " + jobId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskStatuses(TaskTrackerStatus status) {
        String trackerName = status.getTrackerName();
        for (TaskStatus report : status.getTaskReports()) {
            List<org.apache.hadoop.mapred.TaskAttemptID> failedFetchMaps;
            Map<String, Set<ID>> map;
            report.setTaskTracker(trackerName);
            org.apache.hadoop.mapred.TaskAttemptID taskId = report.getTaskID();
            this.expireLaunchingTasks.removeTask(taskId);
            JobInProgress job = this.getJob(taskId.getJobID());
            if (job == null) {
                map = this.trackerToJobsToCleanup;
                synchronized (map) {
                    Set<JobID> jobs = this.trackerToJobsToCleanup.get(trackerName);
                    if (jobs == null) {
                        jobs = new HashSet<JobID>();
                        this.trackerToJobsToCleanup.put(trackerName, jobs);
                    }
                    jobs.add(taskId.getJobID());
                    continue;
                }
            }
            if (!job.inited()) {
                map = this.trackerToTasksToCleanup;
                synchronized (map) {
                    Set<org.apache.hadoop.mapred.TaskAttemptID> tasks = this.trackerToTasksToCleanup.get(trackerName);
                    if (tasks == null) {
                        tasks = new HashSet<org.apache.hadoop.mapred.TaskAttemptID>();
                        this.trackerToTasksToCleanup.put(trackerName, tasks);
                    }
                    tasks.add(taskId);
                    continue;
                }
            }
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip != null) {
                org.apache.hadoop.mapred.JobStatus prevStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                job.updateTaskStatus(tip, (TaskStatus)report.clone());
                org.apache.hadoop.mapred.JobStatus newStatus = (org.apache.hadoop.mapred.JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() != newStatus.getRunState()) {
                    JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                    this.updateJobInProgressListeners(event);
                }
            } else {
                LOG.info((Object)("Serious problem.  While updating status, cannot find taskid " + report.getTaskID()));
            }
            if ((failedFetchMaps = report.getFetchFailedMaps()) == null) continue;
            for (org.apache.hadoop.mapred.TaskAttemptID mapTaskId : failedFetchMaps) {
                TaskInProgress failedFetchMap = this.taskidToTIPMap.get(mapTaskId);
                if (failedFetchMap == null) continue;
                String failedFetchTrackerName = this.getAssignedTracker(mapTaskId);
                if (failedFetchTrackerName == null) {
                    failedFetchTrackerName = "Lost task tracker";
                }
                failedFetchMap.getJob().fetchFailureNotification(failedFetchMap, mapTaskId, failedFetchTrackerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lostTaskTracker(TaskTracker taskTracker) {
        String trackerName = taskTracker.getTrackerName();
        LOG.info((Object)("Lost tracker '" + trackerName + "'"));
        Map<String, Set<ID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            this.trackerToJobsToCleanup.remove(trackerName);
        }
        map = this.trackerToTasksToCleanup;
        synchronized (map) {
            this.trackerToTasksToCleanup.remove(trackerName);
        }
        Set<org.apache.hadoop.mapred.TaskAttemptID> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (org.apache.hadoop.mapred.TaskAttemptID taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                JobInProgress job = tip.getJob();
                if (!tip.isComplete() || tip.isMapTask() && !tip.isJobSetupTask() && job.desiredReduces() != 0) {
                    if (job.getStatus().getRunState() != org.apache.hadoop.mapred.JobStatus.RUNNING && job.getStatus().getRunState() != org.apache.hadoop.mapred.JobStatus.PREP) continue;
                    TaskStatus.State killState = tip.isRunningTask(taskId) && !tip.isJobSetupTask() && !tip.isJobCleanupTask() ? TaskStatus.State.KILLED_UNCLEAN : TaskStatus.State.KILLED;
                    job.failedTask(tip, taskId, "Lost task tracker: " + trackerName, tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, killState, trackerName);
                    jobsWithFailures.add(job);
                    continue;
                }
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName, taskTracker);
            }
            taskTracker.cancelAllReservations();
            this.removeMarkedTasks(trackerName);
        }
    }

    @Override
    public synchronized void refreshNodes() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.aclsManager.isMRAdmin(UserGroupInformation.getCurrentUser())) {
            AuditLogger.logFailure(user, "REFRESH_NODES", this.aclsManager.getAdminsAcl().toString(), "JobTracker", "Unauthorized user");
            throw new AccessControlException(user + " is not authorized to refresh nodes.");
        }
        AuditLogger.logSuccess(user, "REFRESH_NODES", "JobTracker");
        this.refreshHosts();
    }

    UserGroupInformation getMROwner() {
        return this.aclsManager.getMROwner();
    }

    private synchronized void refreshHosts() throws IOException {
        LOG.info((Object)"Refreshing hosts information");
        Configuration conf = new Configuration();
        this.hostsReader.updateFileNames(conf.get("mapreduce.jobtracker.hosts.filename", ""), conf.get("mapreduce.jobtracker.hosts.exclude.filename", ""));
        this.hostsReader.refresh();
        HashSet<String> excludeSet = new HashSet<String>();
        for (Map.Entry<String, TaskTracker> eSet : this.taskTrackers.entrySet()) {
            String trackerName = eSet.getKey();
            TaskTrackerStatus status = eSet.getValue().getStatus();
            if (this.inHostsList(status) && !this.inExcludedHostsList(status)) continue;
            excludeSet.add(status.getHost());
        }
        this.decommissionNodes(excludeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decommissionNodes(Set<String> hosts) throws IOException {
        LOG.info((Object)("Decommissioning " + hosts.size() + " nodes"));
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                int trackersDecommissioned = 0;
                for (String host : hosts) {
                    LOG.info((Object)("Decommissioning host " + host));
                    Set<TaskTracker> trackers = this.hostnameToTaskTracker.remove(host);
                    if (trackers != null) {
                        for (TaskTracker tracker : trackers) {
                            LOG.info((Object)("Decommission: Losing tracker " + tracker.getTrackerName() + " on host " + host));
                            this.removeTracker(tracker);
                        }
                        trackersDecommissioned += trackers.size();
                    }
                    LOG.info((Object)("Host " + host + " is ready for decommissioning"));
                }
                this.getInstrumentation().setDecommissionedTrackers(trackersDecommissioned);
            }
        }
    }

    Collection<String> getExcludedNodes() {
        return this.hostsReader.getExcludedHosts();
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        StringUtils.startupShutdownMessage(JobTracker.class, (String[])argv, (Log)LOG);
        try {
            if (argv.length == 0) {
                JobTracker tracker = JobTracker.startTracker(new JobConf());
                tracker.offerService();
            } else if ("-dumpConfiguration".equals(argv[0]) && argv.length == 1) {
                JobTracker.dumpConfiguration(new PrintWriter(System.out));
                System.out.println();
                Configuration conf = new Configuration();
                QueueManager.dumpConfiguration(new PrintWriter(System.out), conf);
            } else {
                System.out.println("usage: JobTracker [-dumpConfiguration]");
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    private static void dumpConfiguration(Writer writer) throws IOException {
        Configuration.dumpConfiguration((Configuration)new JobConf(), (Writer)writer);
        writer.write("\n");
    }

    @Override
    public QueueInfo[] getRootQueues() throws IOException {
        return this.getQueueInfoArray(this.queueManager.getRootQueues());
    }

    @Override
    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return this.getQueueInfoArray(this.queueManager.getChildQueues(queueName));
    }

    @Deprecated
    public JobQueueInfo[] getRootJobQueues() throws IOException {
        return this.queueManager.getRootQueues();
    }

    @Deprecated
    public JobQueueInfo[] getJobQueues() throws IOException {
        return this.queueManager.getJobQueueInfos();
    }

    @Deprecated
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return this.queueManager.getJobQueueInfo(queue);
    }

    private QueueInfo[] getQueueInfoArray(JobQueueInfo[] queues) throws IOException {
        for (JobQueueInfo queue : queues) {
            queue.setJobStatuses(this.getJobsFromQueue(queue.getQueueName()));
            for (JobQueueInfo childqueue : queue.getChildren()) {
                childqueue.setJobStatuses(this.getJobsFromQueue(childqueue.getQueueName()));
            }
        }
        return queues;
    }

    @Override
    public QueueInfo[] getQueues() throws IOException {
        return this.getQueueInfoArray(this.queueManager.getJobQueueInfos());
    }

    @Override
    public QueueInfo getQueue(String queue) throws IOException {
        JobQueueInfo jqueue = this.queueManager.getJobQueueInfo(queue);
        if (jqueue != null) {
            jqueue.setJobStatuses(this.getJobsFromQueue(jqueue.getQueueName()));
        }
        return jqueue;
    }

    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        Collection<JobInProgress> jips = null;
        if (this.queueManager.getLeafQueueNames().contains(queue)) {
            jips = this.taskScheduler.getJobs(queue);
        }
        return this.getJobStatus(jips, false);
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return this.queueManager.getQueueAcls(UserGroupInformation.getCurrentUser());
    }

    private synchronized org.apache.hadoop.mapred.JobStatus[] getJobStatus(Collection<JobInProgress> jips, boolean toComplete) {
        if (jips == null || jips.isEmpty()) {
            return new org.apache.hadoop.mapred.JobStatus[0];
        }
        ArrayList<org.apache.hadoop.mapred.JobStatus> jobStatusList = new ArrayList<org.apache.hadoop.mapred.JobStatus>();
        for (JobInProgress jip : jips) {
            org.apache.hadoop.mapred.JobStatus status = jip.getStatus();
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            if (toComplete) {
                if (status.getRunState() != org.apache.hadoop.mapred.JobStatus.RUNNING && status.getRunState() != org.apache.hadoop.mapred.JobStatus.PREP) continue;
                jobStatusList.add(status);
                continue;
            }
            jobStatusList.add(status);
        }
        return jobStatusList.toArray(new org.apache.hadoop.mapred.JobStatus[jobStatusList.size()]);
    }

    int getMaxTasksPerJob() {
        return this.conf.getInt("mapreduce.jobtracker.maxtasks.perjob", -1);
    }

    public void refreshServiceAcl() throws IOException {
        if (!this.conf.getBoolean("hadoop.security.authorization", false)) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.interTrackerServer.refreshServiceAcl((Configuration)this.conf, (PolicyProvider)new MapReducePolicyProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshQueues() throws IOException {
        LOG.info((Object)("Refreshing queue information. requested by : " + UserGroupInformation.getCurrentUser().getShortUserName()));
        TaskScheduler taskScheduler = this.taskScheduler;
        synchronized (taskScheduler) {
            this.queueManager.refreshQueues(new Configuration((Configuration)this.conf), this.taskScheduler.getQueueRefresher());
        }
    }

    private void initializeTaskMemoryRelatedConfig() {
        this.memSizeForMapSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapreduce.cluster.mapmemory.mb", -1L));
        this.memSizeForReduceSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapreduce.cluster.reducememory.mb", -1L));
        if (this.conf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)(JobConf.deprecatedString("mapred.task.limit.maxvmem") + " instead use " + "mapreduce.jobtracker.maxmapmemory.mb" + " and " + "mapreduce.jobtracker.maxreducememory.mb"));
            this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapred.task.limit.maxvmem", -1L));
            if (this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForMapTasks >= 0L) {
                this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = this.limitMaxMemForMapTasks / 0x100000L;
            }
        } else {
            this.limitMaxMemForMapTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapreduce.jobtracker.maxmapmemory.mb", -1L));
            this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapreduce.jobtracker.maxreducememory.mb", -1L));
        }
        LOG.info((Object)new StringBuilder().append("Scheduler configured with ").append("(memSizeForMapSlotOnJT, memSizeForReduceSlotOnJT,").append(" limitMaxMemForMapTasks, limitMaxMemForReduceTasks) (").append(this.memSizeForMapSlotOnJT).append(", ").append(this.memSizeForReduceSlotOnJT).append(", ").append(this.limitMaxMemForMapTasks).append(", ").append(this.limitMaxMemForReduceTasks).append(")"));
    }

    public void refreshSuperUserGroupsConfiguration() {
        LOG.info((Object)"Refreshing superuser proxy groups mapping ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + UserGroupInformation.getCurrentUser().getShortUserName()));
        Groups.getUserToGroupsMappingService().refresh();
    }

    private boolean perTaskMemoryConfigurationSetOnJT() {
        return this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForReduceTasks != -1L && this.memSizeForMapSlotOnJT != -1L && this.memSizeForReduceSlotOnJT != -1L;
    }

    void checkMemoryRequirements(JobInProgress job) throws IOException {
        if (!this.perTaskMemoryConfigurationSetOnJT()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Per-Task memory configuration is not set on JT. Not checking the job for invalid memory requirements.");
            }
            return;
        }
        boolean invalidJob = false;
        String msg = "";
        long maxMemForMapTask = job.getMemoryForMapTask();
        long maxMemForReduceTask = job.getMemoryForReduceTask();
        if (maxMemForMapTask == -1L || maxMemForReduceTask == -1L) {
            invalidJob = true;
            msg = "Invalid job requirements.";
        }
        if (maxMemForMapTask > this.limitMaxMemForMapTasks || maxMemForReduceTask > this.limitMaxMemForReduceTasks) {
            invalidJob = true;
            msg = "Exceeds the cluster's max-memory-limit.";
        }
        if (invalidJob) {
            StringBuilder jobStr = new StringBuilder().append(job.getJobID().toString()).append("(").append(maxMemForMapTask).append(" memForMapTasks ").append(maxMemForReduceTask).append(" memForReduceTasks): ");
            LOG.warn((Object)(jobStr.toString() + msg));
            throw new IOException(jobStr.toString() + msg);
        }
    }

    synchronized String getFaultReport(String host) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, false);
        if (fi == null) {
            return "";
        }
        return fi.getTrackerFaultReport();
    }

    synchronized Set<ReasonForBlackListing> getReasonForBlackList(String host) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, false);
        if (fi == null) {
            return new HashSet<ReasonForBlackListing>();
        }
        return fi.getReasonforblacklisting();
    }

    synchronized Collection<ClusterStatus.BlackListInfo> getBlackListedTrackers() {
        ArrayList<ClusterStatus.BlackListInfo> blackListedTrackers = new ArrayList<ClusterStatus.BlackListInfo>();
        for (TaskTrackerStatus tracker : this.blacklistedTaskTrackers()) {
            String hostName = tracker.getHost();
            ClusterStatus.BlackListInfo bi = new ClusterStatus.BlackListInfo();
            bi.setTrackerName(tracker.getTrackerName());
            Set<ReasonForBlackListing> rfbs = this.getReasonForBlackList(hostName);
            StringBuffer sb = new StringBuffer();
            for (ReasonForBlackListing rfb : rfbs) {
                sb.append(rfb.toString());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.replace(sb.length() - 1, sb.length(), "");
            }
            bi.setReasonForBlackListing(sb.toString());
            bi.setBlackListReport(this.getFaultReport(hostName));
            blackListedTrackers.add(bi);
        }
        return blackListedTrackers;
    }

    synchronized void incrementFaults(String hostName) {
        this.faultyTrackers.incrementFaults(hostName);
    }

    JobTracker(final JobConf conf, Clock clock, boolean ignoredForSimulation) throws IOException {
        JobTrackerInstrumentation tmp;
        JobTracker.clock = clock;
        this.conf = conf;
        this.trackerIdentifier = JobTracker.getDateFormat().format(new Date());
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)conf);
        }
        this.localFs = FileSystem.getLocal((Configuration)conf);
        this.tasktrackerExpiryInterval = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        this.retiredJobsCacheSize = conf.getInt("mapred.job.tracker.retiredjobs.cache.size", 1000);
        this.MAX_BLACKLISTS_PER_TRACKER = conf.getInt("mapred.max.tracker.blacklists", 4);
        this.NUM_HEARTBEATS_IN_SECOND = conf.getInt("mapred.heartbeats.in.second", 100);
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobtracker.keytab.file", (String)"mapreduce.jobtracker.kerberos.principal", (String)this.localMachine);
        this.secretManager = null;
        this.hostsReader = new HostsFileReader(conf.get("mapreduce.jobtracker.hosts.filename", ""), conf.get("mapreduce.jobtracker.hosts.exclude.filename", ""));
        Configuration clusterConf = new Configuration((Configuration)this.conf);
        this.queueManager = new QueueManager(clusterConf);
        this.aclsManager = new ACLsManager(conf, new JobACLsManager(conf), this.queueManager);
        LOG.info((Object)("Starting jobtracker with owner as " + this.getMROwner().getShortUserName()));
        Class schedulerClass = conf.getClass("mapreduce.jobtracker.taskscheduler", JobQueueTaskScheduler.class, TaskScheduler.class);
        this.taskScheduler = (TaskScheduler)ReflectionUtils.newInstance((Class)schedulerClass, (Configuration)conf);
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)conf.get("mapreduce.jobtracker.http.address", "0.0.0.0:50030"));
        String infoBindAddress = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.startTime = clock.getTime();
        this.infoServer = new HttpServer("job", infoBindAddress, tmpInfoPort, tmpInfoPort == 0, (Configuration)conf);
        this.infoServer.setAttribute("job.tracker", (Object)this);
        FileSystem historyFS = null;
        this.jobHistory = new JobHistory();
        final JobTracker jtFinal = this;
        try {
            historyFS = (FileSystem)this.getMROwner().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    JobTracker.this.jobHistory.init(jtFinal, conf, jtFinal.localMachine, jtFinal.startTime);
                    JobTracker.this.jobHistory.initDone(conf, JobTracker.this.fs);
                    String historyLogDir = JobTracker.this.jobHistory.getCompletedJobHistoryLocation().toString();
                    JobTracker.this.infoServer.setAttribute("historyLogDir", (Object)historyLogDir);
                    return new Path(historyLogDir).getFileSystem((Configuration)conf);
                }
            });
        }
        catch (InterruptedException e1) {
            throw (IOException)new IOException().initCause(e1);
        }
        this.infoServer.setAttribute("fileSys", (Object)historyFS);
        this.infoServer.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        Class<? extends JobTrackerInstrumentation> metricsInst = JobTracker.getInstrumentationClass(conf);
        try {
            Constructor<? extends JobTrackerInstrumentation> c = metricsInst.getConstructor(JobTracker.class, JobConf.class);
            tmp = c.newInstance(new Object[]{this, conf});
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize job tracker metrics", (Throwable)e);
            tmp = new JobTrackerMetricsInst(this, conf);
        }
        this.myInstrumentation = tmp;
        this.recoveryManager = new RecoveryManager();
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)conf);
        this.numTaskCacheLevels = conf.getInt("mapred.task.cache.levels", 2);
        this.completedJobStatusStore = new CompletedJobStatusStore(conf, this.aclsManager);
    }

    String getLocalJobFilePath(org.apache.hadoop.mapreduce.JobID jobId) {
        return System.getProperty("hadoop.log.dir") + File.separator + jobId + "_conf.xml";
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        this.secretManager.cancelToken(token, user);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos authentication");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Text owner = new Text(ugi.getUserName());
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier(owner, renewer, realUser);
        return new Token((TokenIdentifier)ident, (SecretManager)this.secretManager);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be renewed only with kerberos authentication");
        }
        String user = UserGroupInformation.getCurrentUser().getUserName();
        return this.secretManager.renewToken(token, user);
    }

    JobACLsManager getJobACLsManager() {
        return this.aclsManager.getJobACLsManager();
    }

    ACLsManager getACLsManager() {
        return this.aclsManager;
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.getRealAuthenticationMethod((UserGroupInformation)UserGroupInformation.getCurrentUser());
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS;
    }

    static {
        ConfigUtil.loadResources();
        UPDATE_FAULTY_TRACKER_INTERVAL = 86400000L;
        MAX_BLACKLIST_PERCENT = 0.5;
        SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
        SYSTEM_FILE_PERMISSION = FsPermission.createImmutable((short)448);
        clock = null;
        DEFAULT_CLOCK = new Clock();
        LOG = LogFactory.getLog(JobTracker.class);
        EMPTY_COUNTERS = new Counters();
        EMPTY_TASK_REPORTS = new TaskReport[0];
        EMPTY_TASK_DIAGNOSTICS = new String[0];
    }

    class RecoveryManager {
        private Set<JobID> jobsToRecover = new TreeSet<JobID>();
        private int recovered;
        private int restartCount = 0;
        private boolean shouldRecover = false;

        public boolean contains(JobID id) {
            return this.jobsToRecover.contains(id);
        }

        int getRecovered() {
            return this.recovered;
        }

        void addJobForRecovery(JobID id) {
            this.jobsToRecover.add(id);
        }

        public boolean shouldRecover() {
            return this.shouldRecover;
        }

        Set<JobID> getJobsToRecover() {
            return this.jobsToRecover;
        }

        void addJobForRecovery(FileStatus status) throws IOException {
            JobTracker.this.recoveryManager.addJobForRecovery(JobID.forName(status.getPath().getName()));
            this.shouldRecover = true;
        }

        Path getRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info");
        }

        Path getTempRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info.recover");
        }

        void updateRestartCount() throws IOException {
            Path restartFile = this.getRestartCountFile();
            Path tmpRestartFile = this.getTempRestartCountFile();
            FsPermission filePerm = new FsPermission(SYSTEM_FILE_PERMISSION);
            if (JobTracker.this.fs.exists(restartFile)) {
                JobTracker.this.fs.delete(tmpRestartFile, false);
            } else if (JobTracker.this.fs.exists(tmpRestartFile)) {
                JobTracker.this.fs.rename(tmpRestartFile, restartFile);
            } else {
                this.shouldRecover = false;
                try {
                    FSDataOutputStream out = FileSystem.create((FileSystem)JobTracker.this.fs, (Path)restartFile, (FsPermission)filePerm);
                    out.writeInt(0);
                    out.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Writing to file " + restartFile + " failed!"));
                    LOG.warn((Object)"FileSystem is not ready yet!");
                    JobTracker.this.fs.delete(restartFile, false);
                    throw ioe;
                }
                return;
            }
            FSDataInputStream in = JobTracker.this.fs.open(restartFile);
            try {
                this.restartCount = in.readInt();
                ++this.restartCount;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("System directory is garbled. Failed to read file " + restartFile));
                LOG.warn((Object)"Jobtracker recovery is not possible with garbled system directory! Please delete the system directory and restart the jobtracker. Note that deleting the system directory will result in loss of all the running jobs.");
                throw new RuntimeException(ioe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            FSDataOutputStream out = FileSystem.create((FileSystem)JobTracker.this.fs, (Path)tmpRestartFile, (FsPermission)filePerm);
            out.writeInt(this.restartCount);
            out.close();
            JobTracker.this.fs.delete(restartFile, false);
            JobTracker.this.fs.rename(tmpRestartFile, restartFile);
        }

        public void recover() {
            long recoveryProcessStartTime = clock.getTime();
            if (!this.shouldRecover()) {
                this.jobsToRecover.clear();
                return;
            }
            LOG.info((Object)("Starting the recovery process for " + this.jobsToRecover.size() + " jobs ..."));
            for (JobID jobId : this.jobsToRecover) {
                LOG.info((Object)("Submitting job " + jobId));
                try {
                    Path jobInfoFile = JobTracker.this.getSystemFileForJob(jobId);
                    FSDataInputStream in = JobTracker.this.fs.open(jobInfoFile);
                    JobInfo token = new JobInfo();
                    token.readFields((DataInput)in);
                    in.close();
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)token.getUser().toString());
                    JobTracker.this.submitJob(token.getJobID(), this.restartCount, ugi, token.getJobSubmitDir().toString(), true, null);
                    ++this.recovered;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not recover job " + jobId), (Throwable)e);
                }
            }
            JobTracker.this.recoveryDuration = clock.getTime() - recoveryProcessStartTime;
            JobTracker.this.hasRecovered = true;
            LOG.info((Object)("Recovery done! Recoverd " + this.recovered + " of " + this.jobsToRecover.size() + " jobs."));
            LOG.info((Object)("Recovery Duration (ms):" + JobTracker.this.recoveryDuration));
        }
    }

    private class FaultyTrackersInfo {
        private Map<String, FaultInfo> potentiallyFaultyTrackers = new HashMap<String, FaultInfo>();
        private volatile int numBlacklistedTrackers = 0;

        private FaultyTrackersInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementFaults(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.getFaultInfo(hostName, true);
                long now = clock.getTime();
                int numFaults = fi.getFaultCount();
                fi.setFaultCount(++numFaults);
                fi.setLastUpdated(now);
                if (this.exceedsFaults(fi)) {
                    LOG.info((Object)("Adding " + hostName + " to the blacklist" + " across all jobs"));
                    String reason = String.format("%d failures on the tracker", numFaults);
                    this.blackListTracker(hostName, reason, ReasonForBlackListing.EXCEEDING_FAILURES);
                }
            }
        }

        private void incrBlackListedTrackers(int count) {
            this.numBlacklistedTrackers += count;
            JobTracker.this.getInstrumentation().addBlackListedTrackers(count);
        }

        private void decrBlackListedTrackers(int count) {
            this.numBlacklistedTrackers -= count;
            JobTracker.this.getInstrumentation().decBlackListedTrackers(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blackListTracker(String hostName, String reason, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, true);
            boolean blackListed = fi.isBlacklisted();
            if (blackListed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding blacklisted reason for tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                }
                if (!fi.getReasonforblacklisting().contains((Object)rfb)) {
                    LOG.info((Object)("Adding blacklisted reason for tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                }
                fi.addBlackListedReason(rfb, reason);
            } else {
                Set<TaskTracker> trackers;
                LOG.info((Object)("Blacklisting tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                Set<TaskTracker> set = trackers = JobTracker.this.hostnameToTaskTracker.get(hostName);
                synchronized (set) {
                    for (TaskTracker tracker : trackers) {
                        tracker.cancelAllReservations();
                    }
                }
                this.removeHostCapacity(hostName);
                fi.setBlacklist(rfb, reason);
            }
        }

        private boolean canUnBlackListTracker(String hostName, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, false);
            if (fi == null) {
                return false;
            }
            Set<ReasonForBlackListing> rfbSet = fi.getReasonforblacklisting();
            return fi.isBlacklisted() && rfbSet.contains((Object)rfb);
        }

        private void unBlackListTracker(String hostName, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, false);
            if (fi.removeBlackListedReason(rfb) && fi.getReasonforblacklisting().isEmpty()) {
                this.addHostCapacity(hostName);
                LOG.info((Object)("Unblacklisting tracker : " + hostName));
                fi.unBlacklist();
                if (fi.numFaults == 0) {
                    this.potentiallyFaultyTrackers.remove(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FaultInfo getFaultInfo(String hostName, boolean createIfNeccessary) {
            FaultInfo fi = null;
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                fi = this.potentiallyFaultyTrackers.get(hostName);
                long now = clock.getTime();
                if (fi == null && createIfNeccessary) {
                    fi = new FaultInfo(now);
                    this.potentiallyFaultyTrackers.put(hostName, fi);
                }
            }
            return fi;
        }

        private boolean exceedsFaults(FaultInfo fi) {
            int faultCount = fi.getFaultCount();
            if (faultCount >= JobTracker.this.MAX_BLACKLISTS_PER_TRACKER) {
                long clusterSize = JobTracker.this.getClusterStatus().getTaskTrackers();
                long sum = 0L;
                for (FaultInfo f : this.potentiallyFaultyTrackers.values()) {
                    sum += (long)f.getFaultCount();
                }
                double avg = (double)sum / (double)clusterSize;
                long totalCluster = clusterSize + (long)this.numBlacklistedTrackers;
                if ((double)faultCount - avg > JobTracker.this.AVERAGE_BLACKLIST_THRESHOLD * avg && (double)this.numBlacklistedTrackers < (double)totalCluster * MAX_BLACKLIST_PERCENT) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markTrackerHealthy(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.remove(hostName);
                if (fi != null && fi.isBlacklisted()) {
                    LOG.info((Object)("Removing " + hostName + " from blacklist"));
                    this.addHostCapacity(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldAssignTasksToTracker(String hostName, long now) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null && now - fi.getLastUpdated() > UPDATE_FAULTY_TRACKER_INTERVAL) {
                    int numFaults = fi.getFaultCount() - 1;
                    fi.setFaultCount(numFaults);
                    fi.setLastUpdated(now);
                    if (this.canUnBlackListTracker(hostName, ReasonForBlackListing.EXCEEDING_FAILURES)) {
                        this.unBlackListTracker(hostName, ReasonForBlackListing.EXCEEDING_FAILURES);
                    }
                }
                return fi != null && fi.isBlacklisted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity -= mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity -= reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().addBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().addBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.remove(hostName);
                this.incrBlackListedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity += mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity += reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().decBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().decBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.put(hostName, numTrackersOnHost);
                this.decrBlackListedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isBlacklisted(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.isBlacklisted();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getFaultCount(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getFaultCount();
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<ReasonForBlackListing> getReasonForBlackListing(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getReasonforblacklisting();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNodeHealthStatus(String hostName, boolean isHealthy, String reason) {
            FaultInfo fi = null;
            if (!isHealthy) {
                fi = this.getFaultInfo(hostName, true);
                fi.setHealthy(isHealthy);
                this.updateNodeHealthFailureStatistics(hostName, fi);
                Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
                synchronized (map) {
                    this.blackListTracker(hostName, reason, ReasonForBlackListing.NODE_UNHEALTHY);
                }
            } else {
                fi = this.getFaultInfo(hostName, false);
                if (fi == null) {
                    return;
                }
                if (this.canUnBlackListTracker(hostName, ReasonForBlackListing.NODE_UNHEALTHY)) {
                    this.unBlackListTracker(hostName, ReasonForBlackListing.NODE_UNHEALTHY);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateNodeHealthFailureStatistics(String hostName, FaultInfo fi) {
            if (!fi.getReasonforblacklisting().contains((Object)ReasonForBlackListing.NODE_UNHEALTHY)) {
                Set<TaskTracker> trackers;
                Set<TaskTracker> set = trackers = JobTracker.this.hostnameToTaskTracker.get(hostName);
                synchronized (set) {
                    for (TaskTracker t : trackers) {
                        JobTrackerStatistics.TaskTrackerStat stat = JobTracker.this.statistics.getTaskTrackerStat(t.getTrackerName());
                        stat.incrHealthCheckFailed();
                    }
                }
            }
        }
    }

    private static class FaultInfo {
        static final String FAULT_FORMAT_STRING = "%d failures on the tracker";
        int numFaults = 0;
        long lastUpdated;
        boolean blacklisted;
        private boolean isHealthy;
        private HashMap<ReasonForBlackListing, String> rfbMap;

        FaultInfo(long time) {
            this.lastUpdated = time;
            this.blacklisted = false;
            this.rfbMap = new HashMap();
        }

        void setFaultCount(int num) {
            this.numFaults = num;
        }

        void setLastUpdated(long timeStamp) {
            this.lastUpdated = timeStamp;
        }

        int getFaultCount() {
            return this.numFaults;
        }

        long getLastUpdated() {
            return this.lastUpdated;
        }

        boolean isBlacklisted() {
            return this.blacklisted;
        }

        void setBlacklist(ReasonForBlackListing rfb, String trackerFaultReport) {
            this.blacklisted = true;
            this.rfbMap.put(rfb, trackerFaultReport);
        }

        public void setHealthy(boolean isHealthy) {
            this.isHealthy = isHealthy;
        }

        public boolean isHealthy() {
            return this.isHealthy;
        }

        public String getTrackerFaultReport() {
            StringBuffer sb = new StringBuffer();
            for (String reasons : this.rfbMap.values()) {
                sb.append(reasons);
                sb.append("\n");
            }
            if (sb.length() > 0) {
                sb.replace(sb.length() - 1, sb.length(), "");
            }
            return sb.toString();
        }

        Set<ReasonForBlackListing> getReasonforblacklisting() {
            return this.rfbMap.keySet();
        }

        public void unBlacklist() {
            this.blacklisted = false;
            this.rfbMap.clear();
        }

        public boolean removeBlackListedReason(ReasonForBlackListing rfb) {
            String str = this.rfbMap.remove((Object)rfb);
            return str != null;
        }

        public void addBlackListedReason(ReasonForBlackListing rfb, String reason) {
            this.rfbMap.put(rfb, reason);
        }
    }

    static enum ReasonForBlackListing {
        EXCEEDING_FAILURES,
        NODE_UNHEALTHY;

    }

    class RetireJobs {
        private final Map<JobID, org.apache.hadoop.mapred.JobStatus> jobIDStatusMap = new HashMap<JobID, org.apache.hadoop.mapred.JobStatus>();
        private final LinkedList<org.apache.hadoop.mapred.JobStatus> jobStatusQ = new LinkedList();

        synchronized void addToCache(org.apache.hadoop.mapred.JobStatus status) {
            status.setRetired();
            this.jobStatusQ.add(status);
            this.jobIDStatusMap.put(status.getJobID(), status);
            if (this.jobStatusQ.size() > JobTracker.this.retiredJobsCacheSize) {
                org.apache.hadoop.mapred.JobStatus removed = this.jobStatusQ.remove();
                this.jobIDStatusMap.remove(removed.getJobID());
                LOG.info((Object)("Retired job removed from cache " + removed.getJobID()));
            }
        }

        synchronized org.apache.hadoop.mapred.JobStatus get(JobID jobId) {
            return this.jobIDStatusMap.get(jobId);
        }

        synchronized LinkedList<org.apache.hadoop.mapred.JobStatus> getAll() {
            return (LinkedList)this.jobStatusQ.clone();
        }
    }

    class ExpireTrackers
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(JobTracker.this.tasktrackerExpiryInterval / 3L);
                        JobTracker.this.checkExpiredTrackers();
                    }
                }
                catch (InterruptedException iex) {
                }
                catch (Exception t) {
                    LOG.error((Object)("Tracker Expiry Thread got exception: " + StringUtils.stringifyException((Throwable)t)));
                    continue;
                }
                break;
            }
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private Map<org.apache.hadoop.mapred.TaskAttemptID, Long> launchingTasks = new LinkedHashMap<org.apache.hadoop.mapred.TaskAttemptID, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(JobTracker.this.tasktrackerExpiryInterval / 3L);
                        long now = clock.getTime();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Starting launching task sweep");
                        }
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            Map<org.apache.hadoop.mapred.TaskAttemptID, Long> map = this.launchingTasks;
                            synchronized (map) {
                                Iterator<Map.Entry<org.apache.hadoop.mapred.TaskAttemptID, Long>> itr = this.launchingTasks.entrySet().iterator();
                                while (itr.hasNext()) {
                                    Map.Entry<org.apache.hadoop.mapred.TaskAttemptID, Long> pair = itr.next();
                                    org.apache.hadoop.mapred.TaskAttemptID taskId = pair.getKey();
                                    long age = now - pair.getValue();
                                    LOG.info((Object)(taskId + " is " + age + " ms debug."));
                                    if (age <= JobTracker.this.tasktrackerExpiryInterval) break;
                                    LOG.info((Object)("Launching task " + taskId + " timed out."));
                                    TaskInProgress tip = null;
                                    tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                    if (tip != null) {
                                        JobInProgress job = tip.getJob();
                                        String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                        TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTrackerStatus(trackerName);
                                        if (trackerStatus != null) {
                                            job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerName);
                                        }
                                    }
                                    itr.remove();
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Expire Launching Task Thread got exception: " + StringUtils.stringifyException((Throwable)e)));
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(org.apache.hadoop.mapred.TaskAttemptID taskName) {
            Map<org.apache.hadoop.mapred.TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, clock.getTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(org.apache.hadoop.mapred.TaskAttemptID taskName) {
            Map<org.apache.hadoop.mapred.TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class IllegalStateException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public IllegalStateException(String msg) {
            super(msg);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

